/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.eventsourcing.domain.source.jdbm;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Comparator;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import jdbm.RecordManager;
import jdbm.RecordManagerFactory;
import jdbm.Serializer;
import jdbm.btree.BTree;
import jdbm.helper.ByteArrayComparator;
import jdbm.helper.DefaultSerializer;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import jdbm.recman.CacheRecordManager;
import org.qi4j.api.activation.Activators;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.service.qualifier.Tagged;
import org.qi4j.api.value.ValueSerialization;
import org.qi4j.functional.Function;
import org.qi4j.io.Input;
import org.qi4j.io.Output;
import org.qi4j.io.Receiver;
import org.qi4j.io.Sender;
import org.qi4j.io.Transforms;
import org.qi4j.library.eventsourcing.domain.api.UnitOfWorkDomainEventsValue;
import org.qi4j.library.eventsourcing.domain.source.AbstractEventStoreMixin;
import org.qi4j.library.eventsourcing.domain.source.EventManagement;
import org.qi4j.library.eventsourcing.domain.source.EventSource;
import org.qi4j.library.eventsourcing.domain.source.EventStore;
import org.qi4j.library.eventsourcing.domain.source.EventStoreActivation;
import org.qi4j.library.eventsourcing.domain.source.EventStream;
import org.qi4j.library.fileconfig.FileConfiguration;

@Mixins(value={JdbmEventStoreMixin.class})
@Activators(value={EventStoreActivation.Activator.class})
public interface JdbmEventStoreService
extends EventSource,
EventStore,
EventStream,
EventManagement,
EventStoreActivation,
ServiceComposite {

    public static class JdbmEventStoreMixin
    extends AbstractEventStoreMixin
    implements EventManagement,
    EventSource {
        @Service
        private FileConfiguration fileConfig;
        @Service
        @Tagged(value={"json"})
        private ValueSerialization valueSerialization;
        private RecordManager recordManager;
        private BTree index;
        private Serializer serializer;
        private File dataFile;
        private long currentCount;

        public void activateEventStore() throws Exception {
            super.activateEventStore();
            this.dataFile = new File(this.fileConfig.dataDirectory(), this.identity.identity() + "/events");
            File directory = this.dataFile.getAbsoluteFile().getParentFile();
            directory.mkdirs();
            String name = this.dataFile.getAbsolutePath();
            Properties properties = new Properties();
            properties.put("jdbm.autoCommit", "false");
            properties.put("jdbm.disableTransactions", "false");
            this.initialize(name, properties);
        }

        public void passivateEventStore() throws Exception {
            super.passivateEventStore();
            this.recordManager.close();
        }

        public Output<String, IOException> restore() {
            Output map = Transforms.map((Function)new Transforms.ProgressLog<String>(1000L){

                protected void logProgress() {
                    try {
                        JdbmEventStoreMixin.this.recordManager.commit();
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Could not commit data", e);
                    }
                }
            }, (Output)Transforms.map((Function)new Function<String, UnitOfWorkDomainEventsValue>(){

                public UnitOfWorkDomainEventsValue map(String item) {
                    return (UnitOfWorkDomainEventsValue)JdbmEventStoreMixin.this.valueSerialization.deserialize(JdbmEventStoreMixin.this.eventsType, item);
                }
            }, this.storeEvents0()));
            return Transforms.lock((Lock)this.lock, (Output)map);
        }

        public Input<UnitOfWorkDomainEventsValue, IOException> events(final long offset, long limit) {
            return new Input<UnitOfWorkDomainEventsValue, IOException>(){

                public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super UnitOfWorkDomainEventsValue, ReceiverThrowableType> output) throws IOException, ReceiverThrowableType {
                    output.receiveFrom((Sender)new Sender<UnitOfWorkDomainEventsValue, IOException>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public <ReceiverThrowableType extends Throwable> void sendTo(Receiver<? super UnitOfWorkDomainEventsValue, ReceiverThrowableType> receiver) throws ReceiverThrowableType, IOException {
                            JdbmEventStoreMixin.this.lock();
                            try {
                                TupleBrowser browser = JdbmEventStoreMixin.this.index.browse((Object)(offset + 1L));
                                Tuple tuple = new Tuple();
                                while (browser.getNext(tuple)) {
                                    UnitOfWorkDomainEventsValue domainEvents = JdbmEventStoreMixin.this.readTransactionEvents(tuple);
                                    receiver.receive((Object)domainEvents);
                                }
                            }
                            catch (Exception e) {
                                JdbmEventStoreMixin.this.logger.warn("Could not iterate events", (Throwable)e);
                            }
                            finally {
                                JdbmEventStoreMixin.this.lock.unlock();
                            }
                        }
                    });
                }
            };
        }

        public long count() {
            return this.currentCount;
        }

        protected Output<UnitOfWorkDomainEventsValue, IOException> storeEvents0() {
            return new Output<UnitOfWorkDomainEventsValue, IOException>(){

                public <SenderThrowableType extends Throwable> void receiveFrom(Sender<? extends UnitOfWorkDomainEventsValue, SenderThrowableType> sender) throws IOException, SenderThrowableType {
                    try {
                        sender.sendTo((Receiver)new Receiver<UnitOfWorkDomainEventsValue, IOException>(){

                            public void receive(UnitOfWorkDomainEventsValue item) throws IOException {
                                String jsonString = JdbmEventStoreMixin.this.valueSerialization.serialize((Object)item);
                                JdbmEventStoreMixin.this.currentCount++;
                                JdbmEventStoreMixin.this.index.insert((Object)JdbmEventStoreMixin.this.currentCount, (Object)jsonString.getBytes("UTF-8"), false);
                            }
                        });
                        JdbmEventStoreMixin.this.recordManager.commit();
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    finally {
                        JdbmEventStoreMixin.this.recordManager.rollback();
                    }
                }
            };
        }

        private void initialize(String name, Properties properties) throws IOException {
            this.recordManager = RecordManagerFactory.createRecordManager((String)name, (Properties)properties);
            this.serializer = DefaultSerializer.INSTANCE;
            this.recordManager = new CacheRecordManager(this.recordManager, 1000, false);
            long recid = this.recordManager.getNamedObject("index");
            if (recid != 0L) {
                this.index = BTree.load((RecordManager)this.recordManager, (long)recid);
                this.currentCount = this.index.size();
            } else {
                ByteArrayComparator comparator = new ByteArrayComparator();
                this.index = BTree.createInstance((RecordManager)this.recordManager, (Comparator)comparator, (Serializer)this.serializer, (Serializer)DefaultSerializer.INSTANCE, (int)16);
                this.recordManager.setNamedObject("index", this.index.getRecid());
                this.currentCount = 0L;
            }
            this.recordManager.commit();
        }

        private UnitOfWorkDomainEventsValue readTransactionEvents(Tuple tuple) throws UnsupportedEncodingException {
            byte[] eventData = (byte[])tuple.getValue();
            String eventJson = new String(eventData, "UTF-8");
            return (UnitOfWorkDomainEventsValue)this.valueSerialization.deserialize(this.eventsType, eventJson);
        }
    }
}

