/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.scheduler;

import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.service.ServiceActivation;
import org.qi4j.api.structure.Module;
import org.qi4j.api.unitofwork.NoSuchEntityException;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.unitofwork.UnitOfWorkCompletionException;
import org.qi4j.api.usecase.Usecase;
import org.qi4j.api.usecase.UsecaseBuilder;
import org.qi4j.library.scheduler.Scheduler;
import org.qi4j.library.scheduler.SchedulerConfiguration;
import org.qi4j.library.scheduler.SchedulerService;
import org.qi4j.library.scheduler.Task;
import org.qi4j.library.scheduler.schedule.Schedule;
import org.qi4j.library.scheduler.schedule.ScheduleFactory;
import org.qi4j.library.scheduler.schedule.ScheduleTime;
import org.qi4j.library.scheduler.schedule.Schedules;
import org.qi4j.library.scheduler.schedule.cron.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerMixin
implements Scheduler,
ServiceActivation {
    private static final Logger LOGGER = LoggerFactory.getLogger(Scheduler.class);
    private static final int DEFAULT_WORKERS_COUNT = Runtime.getRuntime().availableProcessors() + 1;
    private static final int DEFAULT_WORKQUEUE_SIZE = 10;
    @Service
    private ScheduleFactory scheduleFactory;
    private final SortedSet<ScheduleTime> timingQueue = new TreeSet<ScheduleTime>();
    private ScheduledExecutorService managementExecutor;
    private ThreadPoolExecutor taskExecutor;
    @Structure
    private Module module;
    @This
    private SchedulerService me;
    @This
    private ThreadFactory threadFactory;
    @This
    private RejectedExecutionHandler rejectionHandler;
    @This
    private Configuration<SchedulerConfiguration> config;
    private ScheduleHandler scheduleHandler;

    @Override
    public Schedule scheduleOnce(Task task, int initialSecondsDelay, boolean durable) {
        long now = System.currentTimeMillis();
        Schedule schedule = this.scheduleFactory.newOnceSchedule(task, new DateTime(now + (long)(initialSecondsDelay * 1000)), durable);
        if (durable) {
            Schedules schedules = (Schedules)this.module.currentUnitOfWork().get(Schedules.class, SchedulerMixin.getSchedulesIdentity(this.me));
            schedules.schedules().add((Object)schedule);
        }
        this.dispatchForExecution(schedule);
        return schedule;
    }

    @Override
    public Schedule scheduleOnce(Task task, DateTime runAt, boolean durable) {
        Schedule schedule = this.scheduleFactory.newOnceSchedule(task, runAt, durable);
        this.dispatchForExecution(schedule);
        if (durable) {
            Schedules schedules = (Schedules)this.module.currentUnitOfWork().get(Schedules.class, SchedulerMixin.getSchedulesIdentity(this.me));
            schedules.schedules().add((Object)schedule);
        }
        return schedule;
    }

    @Override
    public Schedule scheduleCron(Task task, String cronExpression, boolean durable) {
        DateTime now = new DateTime();
        Schedule schedule = this.scheduleFactory.newCronSchedule(task, cronExpression, now, durable);
        if (durable) {
            Schedules schedules = (Schedules)this.module.currentUnitOfWork().get(Schedules.class, SchedulerMixin.getSchedulesIdentity(this.me));
            schedules.schedules().add((Object)schedule);
        }
        this.dispatchForExecution(schedule);
        return schedule;
    }

    @Override
    public Schedule scheduleCron(Task task, @CronExpression String cronExpression, DateTime start, boolean durable) {
        Schedule schedule = this.scheduleFactory.newCronSchedule(task, cronExpression, start, durable);
        if (durable) {
            Schedules schedules = (Schedules)this.module.currentUnitOfWork().get(Schedules.class, SchedulerMixin.getSchedulesIdentity(this.me));
            schedules.schedules().add((Object)schedule);
        }
        this.dispatchForExecution(schedule);
        return schedule;
    }

    @Override
    public Schedule scheduleCron(Task task, String cronExpression, long initialDelay, boolean durable) {
        DateTime start = new DateTime(System.currentTimeMillis() + initialDelay);
        Schedule schedule = this.scheduleFactory.newCronSchedule(task, cronExpression, start, durable);
        if (durable) {
            Schedules schedules = (Schedules)this.module.currentUnitOfWork().get(Schedules.class, SchedulerMixin.getSchedulesIdentity(this.me));
            schedules.schedules().add((Object)schedule);
        }
        this.dispatchForExecution(schedule);
        return schedule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchForExecution(Schedule schedule) {
        long now = System.currentTimeMillis();
        SortedSet<ScheduleTime> sortedSet = this.timingQueue;
        synchronized (sortedSet) {
            if (this.timingQueue.size() == 0) {
                long nextRun = schedule.nextRun(now);
                if (nextRun < 0L) {
                    return;
                }
                this.timingQueue.add(new ScheduleTime((String)schedule.identity().get(), nextRun));
                if (this.scheduleHandler == null) {
                    this.dispatchHandler();
                }
            } else {
                ScheduleTime first = this.timingQueue.first();
                long nextRun = schedule.nextRun(now);
                if (nextRun < 0L) {
                    return;
                }
                this.timingQueue.add(new ScheduleTime((String)schedule.identity().get(), nextRun));
                ScheduleTime newFirst = this.timingQueue.first();
                if (!first.equals(newFirst)) {
                    if (this.scheduleHandler != null && this.scheduleHandler.future != null) {
                        this.scheduleHandler.future.cancel(true);
                    }
                    this.dispatchHandler();
                }
            }
        }
    }

    private void dispatchHandler() {
        this.scheduleHandler = new ScheduleHandler();
        this.managementExecutor.schedule(this.scheduleHandler, this.timingQueue.first().nextTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public void activateService() throws Exception {
        SchedulerConfiguration configuration = (SchedulerConfiguration)this.config.get();
        Integer workersCount = (Integer)configuration.workersCount().get();
        Integer workQueueSize = (Integer)configuration.workQueueSize().get();
        if (workersCount == null) {
            workersCount = DEFAULT_WORKERS_COUNT;
            LOGGER.debug("Workers count absent from configuration, falled back to default: {} workers", (Object)DEFAULT_WORKERS_COUNT);
        }
        if (workQueueSize == null) {
            workQueueSize = 10;
            LOGGER.debug("WorkQueue size absent from configuration, falled back to default: {}", (Object)10);
        }
        int corePoolSize = 2;
        if (workersCount > 4) {
            corePoolSize = workersCount / 4;
        }
        this.taskExecutor = new ThreadPoolExecutor(corePoolSize, workersCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(workQueueSize), this.threadFactory, this.rejectionHandler);
        this.taskExecutor.prestartAllCoreThreads();
        this.managementExecutor = new ScheduledThreadPoolExecutor(2, this.threadFactory, this.rejectionHandler);
        this.loadSchedules();
        LOGGER.debug("Activated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSchedules() throws UnitOfWorkCompletionException {
        UnitOfWork uow = this.module.newUnitOfWork();
        try {
            Schedules schedules = (Schedules)uow.get(Schedules.class, SchedulerMixin.getSchedulesIdentity(this.me));
            for (Schedule schedule : schedules.schedules()) {
                this.dispatchForExecution(schedule);
            }
        }
        catch (NoSuchEntityException e) {
            uow.newEntity(Schedules.class, SchedulerMixin.getSchedulesIdentity(this.me));
            uow.complete();
        }
        finally {
            if (uow.isOpen()) {
                uow.discard();
            }
        }
    }

    public static String getSchedulesIdentity(SchedulerService service) {
        return "Schedules:" + (String)service.identity().get();
    }

    public void passivateService() throws Exception {
        this.managementExecutor.shutdown();
        this.taskExecutor.shutdown();
        this.managementExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        this.managementExecutor.shutdownNow();
        this.taskExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        this.taskExecutor.shutdownNow();
        LOGGER.debug("Passivated");
    }

    public static class ScheduleRunner
    implements Runnable {
        private final Module module;
        private final ScheduleTime schedule;
        private final SchedulerMixin schedulerMixin;

        public ScheduleRunner(ScheduleTime schedule, SchedulerMixin schedulerMixin, Module module) {
            this.schedule = schedule;
            this.schedulerMixin = schedulerMixin;
            this.module = module;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Usecase usecase = UsecaseBuilder.newUsecase((String)"ScheduleRunner");
            UnitOfWork uow = this.module.newUnitOfWork(usecase);
            try {
                Schedule schedule = (Schedule)uow.get(Schedule.class, this.schedule.scheduleIdentity);
                Task task = (Task)schedule.task().get();
                schedule = (Schedule)uow.get(Schedule.class, this.schedule.scheduleIdentity);
                try {
                    schedule.taskStarting();
                    task.run();
                    schedule.taskCompletedSuccessfully();
                }
                catch (RuntimeException ex) {
                    schedule.taskCompletedWithException(ex);
                }
                this.schedulerMixin.dispatchForExecution(schedule);
                uow.complete();
            }
            catch (UnitOfWorkCompletionException unitOfWorkCompletionException) {
            }
            finally {
                if (uow.isOpen()) {
                    uow.discard();
                }
            }
        }
    }

    class ScheduleHandler
    implements Runnable {
        private ScheduledFuture<?> future;

        ScheduleHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SortedSet sortedSet = SchedulerMixin.this.timingQueue;
            synchronized (sortedSet) {
                ScheduleTime scheduleTime = (ScheduleTime)SchedulerMixin.this.timingQueue.first();
                SchedulerMixin.this.timingQueue.remove(scheduleTime);
                ScheduleRunner scheduleRunner = new ScheduleRunner(scheduleTime, SchedulerMixin.this, SchedulerMixin.this.module);
                SchedulerMixin.this.taskExecutor.submit(scheduleRunner);
                if (SchedulerMixin.this.timingQueue.size() == 0) {
                    SchedulerMixin.this.scheduleHandler = null;
                } else {
                    ScheduleTime nextTime = (ScheduleTime)SchedulerMixin.this.timingQueue.first();
                    this.future = SchedulerMixin.this.managementExecutor.schedule(SchedulerMixin.this.scheduleHandler, nextTime.nextTime, TimeUnit.MILLISECONDS);
                }
            }
        }
    }
}

