/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.scheduler.timeline;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.joda.time.DateTime;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.structure.Module;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.library.scheduler.Task;
import org.qi4j.library.scheduler.schedule.Schedule;
import org.qi4j.library.scheduler.timeline.Timeline;
import org.qi4j.library.scheduler.timeline.TimelineRecord;
import org.qi4j.library.scheduler.timeline.TimelineRecordStep;
import org.qi4j.library.scheduler.timeline.TimelineScheduleState;

public class TimelineScheduleMixin
implements Timeline {
    @Structure
    private Module module;
    @This
    private TimelineScheduleState state;
    @This
    private Schedule me;

    @Override
    public Iterable<TimelineRecord> getLastRecords(int maxResults) {
        List timelineRecords = (List)this.state.history().get();
        int size = timelineRecords.size();
        if (size < maxResults) {
            return Collections.unmodifiableCollection(timelineRecords);
        }
        TreeSet<TimelineRecord> result = new TreeSet<TimelineRecord>();
        for (int i = size - maxResults; i < size; ++i) {
            result.add((TimelineRecord)timelineRecords.get(i));
        }
        return result;
    }

    @Override
    public Iterable<TimelineRecord> getNextRecords(int maxResults) {
        TreeSet<TimelineRecord> result = new TreeSet<TimelineRecord>();
        long time = System.currentTimeMillis();
        for (int i = 0; i < maxResults; ++i) {
            time = this.me.nextRun(time);
            result.add(this.createFutureRecord(time));
        }
        return result;
    }

    @Override
    public Iterable<TimelineRecord> getRecords(DateTime from, DateTime to) {
        return this.getRecords(from.getMillis(), to.getMillis());
    }

    @Override
    public Iterable<TimelineRecord> getRecords(long from, long to) {
        long now = System.currentTimeMillis();
        TreeSet<TimelineRecord> result = new TreeSet<TimelineRecord>();
        result.addAll(this.getPastRecords(from));
        result.addAll(this.getFutureRecords(now, to));
        return result;
    }

    private Collection<? extends TimelineRecord> getPastRecords(long from) {
        TreeSet<TimelineRecord> result = new TreeSet<TimelineRecord>();
        List timelineRecords = (List)this.state.history().get();
        for (TimelineRecord record : timelineRecords) {
            Long timestamp = (Long)record.timestamp().get();
            if (timestamp < from) continue;
            result.add(record);
        }
        return result;
    }

    private Collection<? extends TimelineRecord> getFutureRecords(long now, long to) {
        if (now > to) {
            return Collections.emptyList();
        }
        TreeSet<TimelineRecord> result = new TreeSet<TimelineRecord>();
        long time = now;
        while (time <= to) {
            if ((time = this.me.nextRun(time)) > to) continue;
            result.add(this.createFutureRecord(time));
        }
        return result;
    }

    private TimelineRecord createFutureRecord(long when) {
        ValueBuilder builder = this.module.newValueBuilder(TimelineRecord.class);
        TimelineRecord prototype = (TimelineRecord)builder.prototype();
        prototype.step().set((Object)TimelineRecordStep.FUTURE);
        prototype.taskName().set(((Task)this.me.task().get()).name().get());
        List tags = (List)((Task)this.me.task().get()).tags().get();
        prototype.taskTags().set((Object)tags);
        prototype.timestamp().set((Object)when);
        prototype.scheduleIdentity().set(this.me.identity().get());
        prototype.details().set((Object)"");
        return (TimelineRecord)builder.newInstance();
    }
}

