/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.scheduler.timeline;

import java.util.TreeSet;
import org.joda.time.DateTime;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.structure.Module;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.functional.Iterables;
import org.qi4j.library.scheduler.SchedulerMixin;
import org.qi4j.library.scheduler.SchedulerService;
import org.qi4j.library.scheduler.schedule.Schedule;
import org.qi4j.library.scheduler.schedule.Schedules;
import org.qi4j.library.scheduler.timeline.Timeline;
import org.qi4j.library.scheduler.timeline.TimelineRecord;

public abstract class TimelineSchedulerServiceMixin
implements Timeline,
ServiceComposite {
    @Structure
    private Module module;
    @Service
    private SchedulerService scheduler;

    @Override
    public Iterable<TimelineRecord> getLastRecords(int maxResults) {
        TreeSet result = new TreeSet();
        UnitOfWork uow = this.module.currentUnitOfWork();
        String schedulesName = SchedulerMixin.getSchedulesIdentity(this.scheduler);
        Schedules schedules = (Schedules)uow.get(Schedules.class, schedulesName);
        for (Schedule schedule : schedules.schedules()) {
            Timeline timeline = (Timeline)((Object)schedule);
            Iterable<TimelineRecord> lastRecords = timeline.getLastRecords(maxResults);
            Iterables.addAll(result, lastRecords);
        }
        return Iterables.limit((int)maxResults, (Iterable)Iterables.reverse(result));
    }

    @Override
    public Iterable<TimelineRecord> getNextRecords(int maxResults) {
        TreeSet result = new TreeSet();
        UnitOfWork uow = this.module.currentUnitOfWork();
        String schedulesName = SchedulerMixin.getSchedulesIdentity(this.scheduler);
        Schedules schedules = (Schedules)uow.get(Schedules.class, schedulesName);
        for (Schedule schedule : schedules.schedules()) {
            Timeline timeline = (Timeline)((Object)schedule);
            Iterable<TimelineRecord> lastRecords = timeline.getNextRecords(maxResults);
            Iterables.addAll(result, lastRecords);
        }
        return Iterables.limit((int)maxResults, result);
    }

    @Override
    public Iterable<TimelineRecord> getRecords(DateTime from, DateTime to) {
        TreeSet<TimelineRecord> result = new TreeSet<TimelineRecord>();
        UnitOfWork uow = this.module.currentUnitOfWork();
        String schedulesName = SchedulerMixin.getSchedulesIdentity(this.scheduler);
        Schedules schedules = (Schedules)uow.get(Schedules.class, schedulesName);
        for (Schedule schedule : schedules.schedules()) {
            Timeline timeline = (Timeline)((Object)schedule);
            Iterable<TimelineRecord> lastRecords = timeline.getRecords(from, to);
            Iterables.addAll(result, lastRecords);
        }
        return result;
    }

    @Override
    public Iterable<TimelineRecord> getRecords(long from, long to) {
        TreeSet<TimelineRecord> result = new TreeSet<TimelineRecord>();
        UnitOfWork uow = this.module.currentUnitOfWork();
        String schedulesName = SchedulerMixin.getSchedulesIdentity(this.scheduler);
        Schedules schedules = (Schedules)uow.get(Schedules.class, schedulesName);
        for (Schedule schedule : schedules.schedules()) {
            Timeline timeline = (Timeline)((Object)schedule);
            Iterable<TimelineRecord> lastRecords = timeline.getRecords(from, to);
            Iterables.addAll(result, lastRecords);
        }
        return result;
    }
}

