/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.entitystore.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.qi4j.api.common.Optional;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.This;
import org.qi4j.entitystore.file.FileEntityStoreActivation;
import org.qi4j.entitystore.file.FileEntityStoreConfiguration;
import org.qi4j.io.Files;
import org.qi4j.io.Input;
import org.qi4j.io.Output;
import org.qi4j.io.Receiver;
import org.qi4j.io.Sender;
import org.qi4j.library.fileconfig.FileConfiguration;
import org.qi4j.spi.entitystore.BackupRestore;
import org.qi4j.spi.entitystore.EntityAlreadyExistsException;
import org.qi4j.spi.entitystore.EntityNotFoundException;
import org.qi4j.spi.entitystore.EntityStoreException;
import org.qi4j.spi.entitystore.helpers.MapEntityStore;

public class FileEntityStoreMixin
implements FileEntityStoreActivation,
MapEntityStore,
BackupRestore {
    @Optional
    @Service
    FileConfiguration fileConfiguration;
    @This
    private Configuration<FileEntityStoreConfiguration> config;
    private File dataDirectory;
    private int slices;

    @Override
    public void initialize() throws Exception {
        String pathName = (String)((FileEntityStoreConfiguration)this.config.get()).directory().get();
        if (pathName == null) {
            if (this.fileConfiguration != null) {
                String storeId = (String)((FileEntityStoreConfiguration)this.config.get()).identity().get();
                pathName = new File(this.fileConfiguration.dataDirectory(), storeId).getAbsolutePath();
            } else {
                pathName = System.getProperty("user.dir") + "/qi4j/filestore/";
            }
        }
        this.dataDirectory = new File(pathName).getAbsoluteFile();
        if (!this.dataDirectory.exists() && !this.dataDirectory.mkdirs()) {
            throw new IOException("Unable to create directory " + this.dataDirectory);
        }
        File slicesFile = new File(this.dataDirectory, "slices");
        if (slicesFile.exists()) {
            this.slices = this.readIntegerInFile(slicesFile);
        }
        if (this.slices < 1) {
            Integer slicesConf = (Integer)((FileEntityStoreConfiguration)this.config.get()).slices().get();
            this.slices = slicesConf == null ? 10 : slicesConf;
            this.writeIntegerToFile(slicesFile, this.slices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIntegerToFile(File file, int value) throws IOException {
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            fw = new FileWriter(file);
            bw = new BufferedWriter(fw);
            bw.write("" + value);
            bw.flush();
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            if (fw != null) {
                fw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readIntegerInFile(File file) throws IOException {
        FileReader fis = null;
        BufferedReader br = null;
        try {
            fis = new FileReader(file);
            br = new BufferedReader(fis);
            int n = Integer.parseInt(br.readLine());
            return n;
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
    }

    public Reader get(EntityReference entityReference) throws EntityStoreException {
        try {
            File f = this.getDataFile(entityReference);
            if (!f.exists()) {
                throw new EntityNotFoundException(entityReference);
            }
            byte[] serializedState = this.fetch(f);
            return new StringReader(new String(serializedState, "UTF-8"));
        }
        catch (IOException e) {
            throw new EntityStoreException((Throwable)e);
        }
    }

    private byte[] readDataFromStream(BufferedInputStream in, byte[] buf) throws IOException {
        int size = in.read(buf);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2000);
        while (size > 0) {
            baos.write(buf, 0, size);
            size = in.read(buf);
        }
        return baos.toByteArray();
    }

    public void applyChanges(MapEntityStore.MapChanges changes) throws IOException {
        try {
            changes.visitMap(new MapEntityStore.MapChanger(){

                public Writer newEntity(final EntityReference ref, EntityDescriptor descriptor) throws IOException {
                    return new StringWriter(1000){

                        @Override
                        public void close() throws IOException {
                            super.close();
                            byte[] stateArray = this.toString().getBytes("UTF-8");
                            File dataFile = FileEntityStoreMixin.this.getDataFile(ref);
                            if (dataFile.exists()) {
                                throw new EntityAlreadyExistsException(ref);
                            }
                            FileEntityStoreMixin.this.store(dataFile, stateArray);
                        }
                    };
                }

                public Writer updateEntity(final EntityReference ref, EntityDescriptor descriptor) throws IOException {
                    return new StringWriter(1000){

                        @Override
                        public void close() throws IOException {
                            super.close();
                            byte[] stateArray = this.toString().getBytes("UTF-8");
                            File dataFile = FileEntityStoreMixin.this.getDataFile(ref);
                            FileEntityStoreMixin.this.store(dataFile, stateArray);
                        }
                    };
                }

                public void removeEntity(EntityReference ref, EntityDescriptor descriptor) throws EntityNotFoundException {
                    File dataFile = FileEntityStoreMixin.this.getDataFile(ref);
                    if (!dataFile.exists()) {
                        throw new EntityNotFoundException(ref);
                    }
                    dataFile.delete();
                }
            });
        }
        catch (RuntimeException e) {
            if (e instanceof EntityStoreException) {
                throw e;
            }
            throw new IOException(e);
        }
    }

    public Input<String, IOException> backup() {
        return new Input<String, IOException>(){

            public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super String, ReceiverThrowableType> output) throws IOException, ReceiverThrowableType {
                output.receiveFrom((Sender)new Sender<String, IOException>(){

                    public <ThrowableType extends Throwable> void sendTo(Receiver<? super String, ThrowableType> receiver) throws ThrowableType, IOException {
                        for (File sliceDirectory : FileEntityStoreMixin.this.dataDirectory.listFiles()) {
                            for (File file : sliceDirectory.listFiles()) {
                                byte[] stateArray = FileEntityStoreMixin.this.fetch(file);
                                receiver.receive((Object)new String(stateArray, "UTF-8"));
                            }
                        }
                    }
                });
            }
        };
    }

    public Output<String, IOException> restore() {
        return new Output<String, IOException>(){

            public <SenderThrowableType extends Throwable> void receiveFrom(Sender<? extends String, SenderThrowableType> sender) throws IOException, SenderThrowableType {
                sender.sendTo((Receiver)new Receiver<String, IOException>(){

                    public void receive(String item) throws IOException {
                        String id = item.substring("{\"identity\":\"".length());
                        id = id.substring(0, id.indexOf(34));
                        byte[] stateArray = item.getBytes("UTF-8");
                        FileEntityStoreMixin.this.store(FileEntityStoreMixin.this.getDataFile(id), stateArray);
                    }
                });
            }
        };
    }

    public Input<Reader, IOException> entityStates() {
        return new Input<Reader, IOException>(){

            public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super Reader, ReceiverThrowableType> output) throws IOException, ReceiverThrowableType {
                output.receiveFrom((Sender)new Sender<Reader, IOException>(){

                    public <ThrowableType extends Throwable> void sendTo(Receiver<? super Reader, ThrowableType> receiver) throws ThrowableType, IOException {
                        for (File sliceDirectory : FileEntityStoreMixin.this.dataDirectory.listFiles()) {
                            for (File file : sliceDirectory.listFiles()) {
                                byte[] serializedState = FileEntityStoreMixin.this.fetch(file);
                                receiver.receive((Object)new StringReader(new String(serializedState, "UTF-8")));
                            }
                        }
                    }
                });
            }
        };
    }

    private File getDataFile(String identity) {
        identity = this.replaceInvalidChars(identity);
        String slice = "" + Math.abs(identity.hashCode()) % this.slices;
        File sliceDirectory = new File(this.dataDirectory, slice);
        if (!sliceDirectory.exists()) {
            sliceDirectory.mkdirs();
        }
        return new File(sliceDirectory, identity + ".json");
    }

    private String replaceInvalidChars(String identity) {
        StringBuilder b = new StringBuilder(identity.length() + 30);
        for (int i = 0; i < identity.length(); ++i) {
            char ch = identity.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '.' || ch == '-') {
                b.append(ch);
                continue;
            }
            char value = ch;
            b.append('~');
            b.append(this.toHex(value));
        }
        return b.toString();
    }

    private String toHex(int value) {
        String result = "000" + Integer.toHexString(value);
        return result.substring(result.length() - 4);
    }

    private File getDataFile(EntityReference ref) {
        return this.getDataFile(ref.identity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] fetch(File dataFile) throws IOException {
        byte[] buf = new byte[1000];
        BufferedInputStream in = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(dataFile);
            in = new BufferedInputStream(fis);
            byte[] byArray = this.readDataFromStream(in, buf);
            return byArray;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(File dataFile, byte[] stateArray) throws IOException {
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        File tempFile = Files.createTemporayFileOf((File)dataFile);
        tempFile.deleteOnExit();
        try {
            fos = new FileOutputStream(tempFile, false);
            bos = new BufferedOutputStream(fos);
            bos.write(stateArray);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
        dataFile.delete();
        tempFile.renameTo(dataFile);
    }
}

