/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.admin;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.index.rdf.indexing.RdfExporter;
import org.restlet.data.MediaType;
import org.restlet.representation.OutputRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;

public class IndexResource
extends ServerResource {
    @Service
    private RdfExporter exporter;

    public IndexResource() {
        this.getVariants().addAll(Arrays.asList(new Variant(MediaType.TEXT_PLAIN), new Variant(MediaType.APPLICATION_RDF_TRIG), new Variant(MediaType.APPLICATION_RDF_XML)));
        this.setNegotiated(true);
    }

    public Representation get(Variant variant) throws ResourceException {
        if (variant.getMediaType().equals((Object)MediaType.APPLICATION_RDF_XML)) {
            return new RdfXmlOutputRepresentation();
        }
        if (variant.getMediaType().equals((Object)MediaType.APPLICATION_RDF_TRIG)) {
            return new RdfTrigOutputRepresentation(MediaType.APPLICATION_RDF_TRIG);
        }
        if (variant.getMediaType().equals((Object)MediaType.TEXT_PLAIN)) {
            return new RdfTrigOutputRepresentation(MediaType.TEXT_PLAIN);
        }
        return null;
    }

    private class RdfXmlOutputRepresentation
    extends OutputRepresentation {
        public RdfXmlOutputRepresentation() {
            super(MediaType.APPLICATION_RDF_XML);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(OutputStream outputStream) throws IOException {
            try (PrintWriter pw = null;){
                OutputStreamWriter osw = new OutputStreamWriter(outputStream, "UTF-8");
                pw = new PrintWriter(osw);
                IndexResource.this.exporter.exportFormalToWriter(pw);
                pw.flush();
            }
        }
    }

    private class RdfTrigOutputRepresentation
    extends OutputRepresentation {
        public RdfTrigOutputRepresentation(MediaType mediaType) {
            super(mediaType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(OutputStream outputStream) throws IOException {
            try (PrintStream ps = null;){
                ps = new PrintStream(outputStream);
                IndexResource.this.exporter.exportReadableToStream(ps);
            }
        }
    }
}

