/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.osgi;

import java.lang.reflect.Type;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.qi4j.api.activation.ActivatorAdapter;
import org.qi4j.api.activation.Activators;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.service.ServiceDescriptor;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.Classes;
import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;

@Mixins(value={OSGiEnabledServiceMixin.class})
@Activators(value={Activator.class})
public interface OSGiEnabledService
extends ServiceComposite {
    public void registerServices() throws Exception;

    public void unregisterServices() throws Exception;

    public static abstract class OSGiEnabledServiceMixin
    implements OSGiEnabledService {
        @Uses
        ServiceDescriptor descriptor;
        @Structure
        private Module module;
        private ServiceRegistration registration;

        @Override
        public void registerServices() throws Exception {
            BundleContext context = (BundleContext)this.descriptor.metaInfo(BundleContext.class);
            if (context == null) {
                return;
            }
            for (ServiceReference ref : this.module.findServices((Class)Iterables.first((Iterable)this.descriptor.types()))) {
                if (!ref.identity().equals(this.identity().get())) continue;
                Iterable classesSet = Iterables.cast((Iterable)this.descriptor.types());
                Dictionary properties = (Dictionary)this.descriptor.metaInfo(Dictionary.class);
                String[] clazzes = this.fetchInterfacesImplemented(classesSet);
                this.registration = context.registerService(clazzes, ref.get(), properties);
            }
        }

        private String[] fetchInterfacesImplemented(Iterable<Type> classesSet) {
            return (String[])Iterables.toArray(String.class, (Iterable)Iterables.map((Function)Classes.toClassName(), (Iterable)Classes.typesOf(classesSet)));
        }

        @Override
        public void unregisterServices() throws Exception {
            if (this.registration != null) {
                this.registration.unregister();
                this.registration = null;
            }
        }
    }

    public static class Activator
    extends ActivatorAdapter<ServiceReference<OSGiEnabledService>> {
        public void afterActivation(ServiceReference<OSGiEnabledService> activated) throws Exception {
            ((OSGiEnabledService)activated.get()).registerServices();
        }

        public void beforePassivation(ServiceReference<OSGiEnabledService> passivating) throws Exception {
            ((OSGiEnabledService)passivating.get()).unregisterServices();
        }
    }
}

