/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.osgi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.qi4j.api.service.ImportedServiceDescriptor;
import org.qi4j.api.service.ServiceImporter;
import org.qi4j.api.service.ServiceImporterException;
import org.qi4j.api.service.ServiceUnavailableException;
import org.qi4j.library.osgi.OSGiImportInfo;

public class OSGiServiceImporter
implements ServiceImporter {
    public Object importService(ImportedServiceDescriptor serviceDescriptor) throws ServiceImporterException {
        OSGiImportInfo info = (OSGiImportInfo)serviceDescriptor.metaInfo(OSGiImportInfo.class);
        BundleContext context = info.bundleContext();
        ServiceTrackerHandler handler = new ServiceTrackerHandler(context, serviceDescriptor.type());
        handler.open();
        return Proxy.newProxyInstance(serviceDescriptor.type().getClassLoader(), info.interfaces(), (InvocationHandler)handler);
    }

    public boolean isAvailable(Object instance) {
        ServiceTrackerHandler handler = (ServiceTrackerHandler)Proxy.getInvocationHandler(instance);
        return handler.isAvailable();
    }

    public static class ServiceTrackerHandler
    extends ServiceTracker
    implements InvocationHandler {
        private volatile Object service;
        private Class typeToImport;

        public ServiceTrackerHandler(BundleContext context, Class typeToImport) {
            super(context, typeToImport.getName(), null);
            this.typeToImport = typeToImport;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object temporary;
            ServiceTrackerHandler serviceTrackerHandler = this;
            synchronized (serviceTrackerHandler) {
                if (this.service == null) {
                    this.wait(5000L);
                    if (this.service == null) {
                        throw new ServiceUnavailableException("The OSGi service is currently not available: " + this.typeToImport.getName());
                    }
                }
                temporary = this.service;
            }
            return method.invoke(temporary, args);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object addingService(ServiceReference reference) {
            ServiceTrackerHandler serviceTrackerHandler = this;
            synchronized (serviceTrackerHandler) {
                this.service = super.addingService(reference);
                this.notifyAll();
                return this.service;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference reference, Object service) {
            ServiceTrackerHandler serviceTrackerHandler = this;
            synchronized (serviceTrackerHandler) {
                super.removedService(reference, service);
                this.notifyAll();
                this.service = null;
            }
        }

        public boolean isAvailable() {
            return this.service != null;
        }
    }
}

