/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.uowfile.internal;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.qi4j.io.Inputs;
import org.qi4j.io.Outputs;
import org.qi4j.library.uowfile.internal.ConcurrentUoWFileStateModificationException;
import org.qi4j.library.uowfile.internal.UoWFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UoWFile {
    static final Logger LOGGER = LoggerFactory.getLogger((String)"org.qi4j.library.uowfile");
    private static final int FILE_BUFFER_SIZE = 4096;
    private static final AtomicLong COUNT = new AtomicLong(0L);
    private final long originalIdentity;
    private final File original;
    private final File current;
    private final File backup;

    UoWFile(File original, File workDir) {
        this.originalIdentity = original.length() + original.lastModified();
        this.original = original;
        long count = COUNT.incrementAndGet();
        this.current = new File(workDir, original.getName() + ".current." + count);
        this.backup = new File(workDir, original.getName() + ".backup." + count);
    }

    public File asFile() {
        return this.current;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(UoWFile.class.getSimpleName());
        sb.append("{").append(this.original.getParentFile().getName()).append("/( ").append(this.original.getName()).append("(").append(this.originalIdentity).append("->").append(this.fileTag(this.original)).append(") | ").append(this.current.getName()).append("(").append(this.fileTag(this.current)).append(") | ").append(this.backup.getName()).append("(").append(this.fileTag(this.backup)).append(") )}");
        return sb.toString();
    }

    void copyOriginalToCurrent() {
        if (this.original.exists()) {
            this.copy(this.original, this.current);
        }
    }

    void apply() throws ConcurrentUoWFileStateModificationException {
        LOGGER.trace("Will apply changes to {}", (Object)this);
        if (this.fileTag(this.current) != this.originalIdentity) {
            if (this.fileTag(this.original) != this.originalIdentity) {
                LOGGER.info("Concurrent modification, original creation identity is {} and original apply identity is {}", (Object)this.originalIdentity, (Object)this.fileTag(this.original));
                throw new ConcurrentUoWFileStateModificationException(this);
            }
            if (this.original.exists()) {
                this.move(this.original, this.backup);
            }
            if (this.current.exists()) {
                this.move(this.current, this.original);
            }
            LOGGER.debug("Applied changes to {}", (Object)this.original);
        }
    }

    void rollback() {
        if (this.backup.exists()) {
            if (this.fileTag(this.original) != this.originalIdentity) {
                this.delete(this.original);
                this.move(this.backup, this.original);
            }
            LOGGER.debug("Restored backup to {}", (Object)this.original);
        }
    }

    void cleanup() {
        if (this.current.exists()) {
            this.delete(this.current);
        }
        if (this.backup.exists()) {
            this.delete(this.backup);
        }
    }

    private long fileTag(File file) {
        return file.length() + file.lastModified();
    }

    private void copy(File source, File dest) {
        try {
            Inputs.byteBuffer((File)source, (int)4096).transferTo(Outputs.byteBuffer((File)dest));
        }
        catch (IOException ex) {
            throw new UoWFileException(ex);
        }
    }

    private void delete(File file) {
        if (!file.delete()) {
            throw new UoWFileException(new IOException("Unable to delete file " + file));
        }
    }

    private void move(File source, File dest) {
        if (!source.renameTo(dest)) {
            this.copy(source, dest);
            if (!source.delete()) {
                throw new UoWFileException(new IOException("Unable to delete source file " + source + " after copy(move) to " + dest + " (rename failed before that)."));
            }
            LOGGER.warn("Moved {} to {} using a copy/delete operation instead of an atomic move. Are they on different filesystems?", (Object)source, (Object)dest);
        }
    }
}

