/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.uowfile.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.qi4j.api.common.Optional;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceActivation;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.structure.Application;
import org.qi4j.api.structure.Module;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.unitofwork.UnitOfWorkCallback;
import org.qi4j.api.unitofwork.UnitOfWorkCompletionException;
import org.qi4j.library.fileconfig.FileConfiguration;
import org.qi4j.library.uowfile.internal.ConcurrentUoWFileModificationException;
import org.qi4j.library.uowfile.internal.ConcurrentUoWFileStateModificationException;
import org.qi4j.library.uowfile.internal.UoWFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mixins(value={Mixin.class})
public interface UoWFileFactory
extends ServiceActivation {
    public UoWFile createCurrentUoWFile(File var1);

    public static class Mixin
    implements UoWFileFactory {
        private static final Logger LOGGER = LoggerFactory.getLogger((String)"org.qi4j.library.uowfile");
        @Structure
        private Application app;
        @Structure
        private Module module;
        @This
        private ServiceComposite me;
        @Optional
        @Service
        private FileConfiguration fileConfig;
        private File workDir;

        public void activateService() throws IOException {
            File tmp = this.fileConfig == null ? new File("qi4j", this.app.name() + "-" + this.app.version()) : this.fileConfig.temporaryDirectory();
            this.workDir = new File(tmp, "uowfile-" + (String)this.me.identity().get());
            if (!this.workDir.exists() && !this.workDir.mkdirs()) {
                throw new IOException("Unable to create temporary directory: " + this.workDir);
            }
        }

        public void passivateService() throws Exception {
        }

        @Override
        public UoWFile createCurrentUoWFile(File file) {
            return Mixin.createUoWFile(this.module.currentUnitOfWork(), file, this.workDir);
        }

        private static synchronized UoWFile createUoWFile(UnitOfWork uow, File file, File workDir) {
            String absolutePath;
            UoWFilesMetaInfo uowMeta = Mixin.ensureUoWMeta(uow);
            UoWFile uowFile = (UoWFile)uowMeta.get(absolutePath = file.getAbsolutePath());
            if (uowFile == null) {
                uowFile = new UoWFile(file, workDir);
                uowFile.copyOriginalToCurrent();
                uowMeta.put(absolutePath, uowFile);
                LOGGER.trace("Registered {} in UoW", (Object)uowFile);
            }
            return uowFile;
        }

        private static UoWFilesMetaInfo ensureUoWMeta(final UnitOfWork uow) {
            UoWFilesMetaInfo uowMeta = (UoWFilesMetaInfo)uow.metaInfo(UoWFilesMetaInfo.class);
            if (uowMeta != null) {
                return uowMeta;
            }
            uowMeta = new UoWFilesMetaInfo();
            uow.setMetaInfo((Object)uowMeta);
            uow.addUnitOfWorkCallback(new UnitOfWorkCallback(){

                public void beforeCompletion() throws UnitOfWorkCompletionException {
                    UoWFilesMetaInfo uowMeta = (UoWFilesMetaInfo)uow.metaInfo(UoWFilesMetaInfo.class);
                    if (uowMeta != null && !uowMeta.isEmpty()) {
                        ArrayList<UoWFile> concurrentlyModified = new ArrayList<UoWFile>();
                        for (UoWFile eachUoWFile : uowMeta.values()) {
                            try {
                                eachUoWFile.apply();
                            }
                            catch (ConcurrentUoWFileStateModificationException ex) {
                                concurrentlyModified.add(ex.getUoWFile());
                            }
                        }
                        if (!concurrentlyModified.isEmpty()) {
                            throw new ConcurrentUoWFileModificationException(concurrentlyModified);
                        }
                    }
                }

                public void afterCompletion(UnitOfWorkCallback.UnitOfWorkStatus status) {
                    UoWFilesMetaInfo uowMeta = (UoWFilesMetaInfo)uow.metaInfo(UoWFilesMetaInfo.class);
                    if (uowMeta != null && !uowMeta.isEmpty()) {
                        for (UoWFile eachUoWFile : uowMeta.values()) {
                            if (status == UnitOfWorkCallback.UnitOfWorkStatus.DISCARDED) {
                                eachUoWFile.rollback();
                            }
                            eachUoWFile.cleanup();
                        }
                        ((UoWFilesMetaInfo)uow.metaInfo(UoWFilesMetaInfo.class)).clear();
                    }
                }
            });
            return uowMeta;
        }

        private static class UoWFilesMetaInfo
        extends HashMap<String, UoWFile> {
            private UoWFilesMetaInfo() {
            }
        }
    }
}

