/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.uowfile.plural;

import java.io.File;
import java.util.ArrayList;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.library.uowfile.internal.UoWFileFactory;
import org.qi4j.library.uowfile.plural.UoWFilesLocator;

@Mixins(value={Mixin.class})
public interface HasUoWFiles<T extends Enum<T>> {
    public File attachedFile(T var1);

    public Iterable<File> attachedFiles();

    public File managedFile(T var1);

    public Iterable<File> managedFiles();

    public static abstract class Mixin<R extends Enum<R>>
    implements HasUoWFiles<R> {
        @Service
        private UoWFileFactory uowFileFactory;
        @This
        private UoWFilesLocator<R> locator;

        @Override
        public File attachedFile(R key) {
            return this.locator.locateAttachedFile(key);
        }

        @Override
        public Iterable<File> attachedFiles() {
            return this.locator.locateAttachedFiles();
        }

        @Override
        public File managedFile(R key) {
            return this.uowFileFactory.createCurrentUoWFile(this.locator.locateAttachedFile(key)).asFile();
        }

        @Override
        public Iterable<File> managedFiles() {
            ArrayList<File> managedFiles = new ArrayList<File>();
            for (File eachAttachedFile : this.locator.locateAttachedFiles()) {
                managedFiles.add(this.uowFileFactory.createCurrentUoWFile(eachAttachedFile).asFile());
            }
            return managedFiles;
        }
    }
}

