/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.fileconfig;

import java.io.File;
import java.util.ArrayList;
import org.qi4j.api.activation.ActivationEvent;
import org.qi4j.api.activation.ActivationEventListener;
import org.qi4j.api.structure.Application;
import org.qi4j.library.fileconfig.FileConfiguration;

public final class FileConfigurationDataWiper {
    public static void registerApplicationPassivationDataWiper(FileConfiguration fileConfig, Application application) {
        final ArrayList<File> dataDirectories = new ArrayList<File>();
        dataDirectories.add(fileConfig.configurationDirectory());
        dataDirectories.add(fileConfig.cacheDirectory());
        dataDirectories.add(fileConfig.dataDirectory());
        dataDirectories.add(fileConfig.logDirectory());
        dataDirectories.add(fileConfig.temporaryDirectory());
        application.registerActivationEventListener(new ActivationEventListener(){

            public void onEvent(ActivationEvent event) {
                if (event.type() == ActivationEvent.EventType.PASSIVATED && Application.class.isAssignableFrom(event.source().getClass())) {
                    for (File dataDir : dataDirectories) {
                        if (FileConfigurationDataWiper.delete(dataDir)) continue;
                        System.err.println("Unable to delete " + dataDir);
                    }
                }
            }
        });
    }

    private static boolean delete(File file) {
        if (!file.exists()) {
            return true;
        }
        if (file.isFile()) {
            return file.delete();
        }
        for (File childFile : file.listFiles()) {
            if (FileConfigurationDataWiper.delete(childFile)) continue;
            return false;
        }
        return file.delete();
    }

    private FileConfigurationDataWiper() {
    }
}

