/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.fileconfig;

import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qi4j.api.activation.ActivatorAdapter;
import org.qi4j.api.activation.Activators;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.property.Property;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.service.ServiceDescriptor;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.structure.Application;
import org.qi4j.library.fileconfig.FileConfiguration;
import org.qi4j.library.fileconfig.FileConfigurationOverride;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mixins(value={Mixin.class})
@Activators(value={Activator.class})
public interface FileConfigurationService
extends FileConfiguration,
ServiceComposite {
    public void resolveFileConfiguration();

    public static abstract class Mixin
    implements FileConfigurationService {
        final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
        @This
        Data data;
        @Uses
        ServiceDescriptor descriptor;
        @Structure
        Application app;

        @Override
        public void resolveFileConfiguration() {
            FileConfiguration.OS os = this.detectOS();
            this.data.os().set((Object)os);
            this.logger.info("Operating system : " + os.name());
            ResourceBundle bundle = ResourceBundle.getBundle(FileConfiguration.class.getName(), new Locale(os.name()));
            Map arguments = this.getArguments(os);
            this.data.configuration().set((Object)new File(this.format(bundle.getString("configuration"), arguments)));
            this.data.data().set((Object)new File(this.format(bundle.getString("data"), arguments)));
            this.data.temporary().set((Object)new File(this.format(bundle.getString("temporary"), arguments)));
            this.data.cache().set((Object)new File(this.format(bundle.getString("cache"), arguments)));
            this.data.log().set((Object)new File(this.format(bundle.getString("log"), arguments)));
            this.applyOverride();
            this.autoCreateDirectories();
        }

        private Map getArguments(FileConfiguration.OS os) {
            String user = System.getenv("USERPROFILE");
            if (user == null) {
                user = System.getProperty("user.home");
            }
            this.data.user().set((Object)new File(user));
            String application = System.getProperty("application", this.app.name());
            if (!this.app.mode().equals((Object)Application.Mode.production)) {
                application = application + "-" + this.app.mode().name();
            }
            this.data.application().set((Object)application);
            String temp = System.getProperty("java.io.tmpdir");
            if (temp.endsWith("/")) {
                temp = temp.substring(0, temp.length() - 1);
            }
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.put("application", application);
            arguments.put("user", user);
            arguments.put("os", os.name());
            arguments.put("temp", temp);
            for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
                arguments.put("environment." + entry.getKey(), entry.getValue());
            }
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                arguments.put("system." + entry.getKey(), entry.getValue().toString());
            }
            return arguments;
        }

        private void applyOverride() {
            FileConfigurationOverride override = (FileConfigurationOverride)this.descriptor.metaInfo(FileConfigurationOverride.class);
            if (override != null) {
                if (override.configuration() != null) {
                    this.data.configuration().set((Object)override.configuration());
                }
                if (override.data() != null) {
                    this.data.data().set((Object)override.data());
                }
                if (override.temporary() != null) {
                    this.data.temporary().set((Object)override.temporary());
                }
                if (override.cache() != null) {
                    this.data.cache().set((Object)override.cache());
                }
                if (override.log() != null) {
                    this.data.log().set((Object)override.log());
                }
            }
        }

        @Override
        public FileConfiguration.OS os() {
            return (FileConfiguration.OS)((Object)this.data.os().get());
        }

        @Override
        public File user() {
            return (File)this.data.user().get();
        }

        @Override
        public File configurationDirectory() {
            return (File)this.data.configuration().get();
        }

        @Override
        public File dataDirectory() {
            return (File)this.data.data().get();
        }

        @Override
        public File temporaryDirectory() {
            return (File)this.data.temporary().get();
        }

        @Override
        public File cacheDirectory() {
            return (File)this.data.cache().get();
        }

        @Override
        public File logDirectory() {
            return (File)this.data.log().get();
        }

        private FileConfiguration.OS detectOS() {
            String osName = System.getProperty("os.name").toLowerCase();
            FileConfiguration.OS os = osName.indexOf("win") != -1 ? FileConfiguration.OS.windows : (osName.indexOf("mac") != -1 ? FileConfiguration.OS.mac : FileConfiguration.OS.unix);
            return os;
        }

        private void autoCreateDirectories() {
            if (!this.configurationDirectory().exists() && !this.configurationDirectory().mkdirs()) {
                throw new IllegalStateException("Could not create configuration directory(" + this.configurationDirectory() + ")");
            }
            if (!this.dataDirectory().exists() && !this.dataDirectory().mkdirs()) {
                throw new IllegalStateException("Could not create data directory(" + this.dataDirectory() + ")");
            }
            if (!this.temporaryDirectory().exists() && !this.temporaryDirectory().mkdirs()) {
                throw new IllegalStateException("Could not create temporary directory(" + this.temporaryDirectory() + ")");
            }
            if (!this.cacheDirectory().exists() && !this.cacheDirectory().mkdirs()) {
                throw new IllegalStateException("Could not create cache directory(" + this.cacheDirectory() + ")");
            }
            if (!this.logDirectory().exists() && !this.logDirectory().mkdirs()) {
                throw new IllegalStateException("Could not create log directory(" + this.logDirectory() + ")");
            }
        }

        private String format(String configuration, Map arguments) {
            Pattern paramPattern = Pattern.compile("\\{(.*?)\\}");
            Matcher matcher = paramPattern.matcher(configuration);
            StringBuilder buffer = new StringBuilder();
            int lastEnd = 0;
            while (matcher.find()) {
                buffer.append(configuration.substring(lastEnd, matcher.start()));
                lastEnd = matcher.end();
                String var = matcher.group(1);
                Object value = arguments.get(var);
                if (value != null) {
                    buffer.append(this.format(value.toString(), arguments));
                    continue;
                }
                throw new IllegalArgumentException("Illegal file configuration parameter:" + var);
            }
            buffer.append(configuration.substring(lastEnd));
            return buffer.toString();
        }
    }

    public static interface Data {
        public Property<FileConfiguration.OS> os();

        public Property<String> application();

        public Property<File> user();

        public Property<File> configuration();

        public Property<File> data();

        public Property<File> temporary();

        public Property<File> cache();

        public Property<File> log();
    }

    public static class Activator
    extends ActivatorAdapter<ServiceReference<FileConfigurationService>> {
        public void afterActivation(ServiceReference<FileConfigurationService> activated) throws Exception {
            ((FileConfigurationService)activated.get()).resolveFileConfiguration();
        }
    }
}

