/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.entitystore.sql.internal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.qi4j.api.injection.scope.This;
import org.qi4j.entitystore.sql.internal.DatabaseSQLServiceState;
import org.qi4j.library.sql.common.SQLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DatabaseSQLServiceSpi {
    public boolean schemaExists(Connection var1) throws SQLException;

    public String getCurrentSchemaName();

    public boolean tableExists(Connection var1) throws SQLException;

    public static abstract class CommonMixin
    implements DatabaseSQLServiceSpi {
        private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseSQLServiceSpi.class);
        @This
        private DatabaseSQLServiceState state;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean schemaExists(Connection connection) throws SQLException {
            boolean bl;
            ResultSet rs = null;
            try {
                Boolean schemaFound = false;
                rs = connection.getMetaData().getSchemas();
                String schemaName = this.getCurrentSchemaName();
                while (rs.next() && !schemaFound.booleanValue()) {
                    String eachResult = rs.getString(1);
                    LOGGER.trace("Schema candidate: {}", (Object)eachResult);
                    schemaFound = eachResult.equalsIgnoreCase(schemaName);
                }
                LOGGER.trace("Schema {} found? {}", (Object)schemaName, (Object)schemaFound);
                bl = schemaFound;
            }
            catch (Throwable throwable) {
                SQLUtil.closeQuietly(rs);
                throw throwable;
            }
            SQLUtil.closeQuietly((ResultSet)rs);
            return bl;
        }

        @Override
        public String getCurrentSchemaName() {
            return (String)this.state.schemaName().get();
        }
    }
}

