/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.entitystore.sql.internal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.This;
import org.qi4j.entitystore.sql.internal.DatabaseSQLService;
import org.qi4j.entitystore.sql.internal.DatabaseSQLStringsBuilder;

public abstract class DatabaseSQLServiceStatementsMixin
implements DatabaseSQLService {
    @This
    private DatabaseSQLStringsBuilder sqlStrings;

    @Override
    public PreparedStatement prepareGetAllEntitiesStatement(Connection connection) throws SQLException {
        return connection.prepareStatement(this.sqlStrings.buildSQLForSelectAllEntitiesStatement());
    }

    @Override
    public PreparedStatement prepareGetEntityStatement(Connection connection) throws SQLException {
        return connection.prepareStatement(this.sqlStrings.buildSQLForSelectEntityStatement());
    }

    @Override
    public PreparedStatement prepareInsertEntityStatement(Connection connection) throws SQLException {
        return connection.prepareStatement(this.sqlStrings.buildSQLForInsertEntityStatement());
    }

    @Override
    public PreparedStatement prepareRemoveEntityStatement(Connection connection) throws SQLException {
        return connection.prepareStatement(this.sqlStrings.buildSQLForRemoveEntityStatement());
    }

    @Override
    public PreparedStatement prepareUpdateEntityStatement(Connection connection) throws SQLException {
        return connection.prepareStatement(this.sqlStrings.buildSQLForUpdateEntityStatement());
    }

    @Override
    public void populateGetAllEntitiesStatement(PreparedStatement ps) throws SQLException {
    }

    @Override
    public void populateGetEntityStatement(PreparedStatement ps, EntityReference ref) throws SQLException {
        ps.setString(1, ref.identity());
    }

    @Override
    public void populateInsertEntityStatement(PreparedStatement ps, EntityReference ref, String entity, Long lastModified) throws SQLException {
        ps.setString(1, ref.identity());
        ps.setString(2, entity);
        ps.setLong(3, lastModified);
    }

    @Override
    public void populateRemoveEntityStatement(PreparedStatement ps, Long entityPK, EntityReference ref) throws SQLException {
        ps.setLong(1, entityPK);
    }

    @Override
    public void populateUpdateEntityStatement(PreparedStatement ps, Long entityPK, Long entityOptimisticLock, EntityReference ref, String entity, Long lastModified) throws SQLException {
        ps.setLong(1, entityOptimisticLock + 1L);
        ps.setString(2, entity);
        ps.setLong(3, lastModified);
        ps.setLong(4, entityPK);
        ps.setLong(5, entityOptimisticLock);
    }
}

