/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.entitystore.sql.internal;

import java.util.ArrayList;
import org.qi4j.api.injection.scope.This;
import org.qi4j.entitystore.sql.internal.DatabaseSQLServiceState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sql.generation.api.grammar.booleans.BooleanExpression;
import org.sql.generation.api.grammar.builders.modification.DeleteBySearchBuilder;
import org.sql.generation.api.grammar.builders.modification.UpdateBySearchBuilder;
import org.sql.generation.api.grammar.common.NonBooleanExpression;
import org.sql.generation.api.grammar.common.SQLStatement;
import org.sql.generation.api.grammar.common.TableName;
import org.sql.generation.api.grammar.common.ValueExpression;
import org.sql.generation.api.grammar.common.datatypes.SQLDataType;
import org.sql.generation.api.grammar.definition.table.AutoGenerationPolicy;
import org.sql.generation.api.grammar.definition.table.TableConstraint;
import org.sql.generation.api.grammar.definition.table.TableContentsSource;
import org.sql.generation.api.grammar.definition.table.TableElement;
import org.sql.generation.api.grammar.definition.table.UniqueSpecification;
import org.sql.generation.api.grammar.factories.BooleanFactory;
import org.sql.generation.api.grammar.factories.ColumnsFactory;
import org.sql.generation.api.grammar.factories.DefinitionFactory;
import org.sql.generation.api.grammar.factories.LiteralFactory;
import org.sql.generation.api.grammar.factories.ModificationFactory;
import org.sql.generation.api.grammar.factories.QueryFactory;
import org.sql.generation.api.grammar.factories.TableReferenceFactory;
import org.sql.generation.api.grammar.modification.ColumnSource;
import org.sql.generation.api.grammar.modification.SetClause;
import org.sql.generation.api.grammar.modification.UpdateSource;
import org.sql.generation.api.vendor.SQLVendor;

public interface DatabaseSQLStringsBuilder {
    public void init();

    public String[] buildSQLForSchemaCreation();

    public String[] buildSQLForIndexCreation();

    public String[] buildSQLForTableCreation();

    public String buildSQLForSelectAllEntitiesStatement();

    public String buildSQLForSelectEntityStatement();

    public String buildSQLForInsertEntityStatement();

    public String buildSQLForUpdateEntityStatement();

    public String buildSQLForRemoveEntityStatement();

    public static abstract class CommonMixin
    implements DatabaseSQLStringsBuilder {
        private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseSQLStringsBuilder.class);
        @This
        private DatabaseSQLServiceState _state;
        private SQLVendor vendor;
        private String schemaName;
        private String[] schemaCreationSQLs;
        private String[] indexCreationSQLs;
        private String[] tableCreationSQLs;
        private String selectAllEntitiesSQL;
        private String selectEntitySQL;
        private String insertEntitySQL;
        private String updateEntitySQL;
        private String removeEntitySQL;

        @Override
        public void init() {
            this.vendor = (SQLVendor)this._state.vendor().get();
            this.schemaName = (String)this._state.schemaName().get();
            this.schemaCreationSQLs = this.toString(this.createSchemaStatements(this.vendor));
            LOGGER.trace("SQL for schema creation: {}", (Object[])this.schemaCreationSQLs);
            this.indexCreationSQLs = this.toString(this.createIndicesStatements(this.vendor));
            LOGGER.trace("SQL for index creation: {}", (Object[])this.indexCreationSQLs);
            this.tableCreationSQLs = this.toString(this.createTableStatements(this.vendor));
            LOGGER.trace("SQL for table creation: {}", (Object[])this.tableCreationSQLs);
            this.selectAllEntitiesSQL = this.vendor.toString(this.createSelectAllEntitiesStatement(this.vendor));
            LOGGER.trace("SQL for select all entities: {}", (Object)this.selectAllEntitiesSQL);
            this.selectEntitySQL = this.vendor.toString(this.createSelectEntityStatement(this.vendor));
            LOGGER.trace("SQL for select entity: {}", (Object)this.selectEntitySQL);
            this.insertEntitySQL = this.vendor.toString(this.createInsertEntityStatement(this.vendor));
            LOGGER.trace("SQL for insert entity: {}", (Object)this.insertEntitySQL);
            this.updateEntitySQL = this.vendor.toString(this.createUpdateEntityStatement(this.vendor));
            LOGGER.trace("SQL for update entity: {}", (Object)this.updateEntitySQL);
            this.removeEntitySQL = this.vendor.toString(this.createRemoveEntityStatement(this.vendor));
            LOGGER.trace("SQL for remove entity: {}", (Object)this.removeEntitySQL);
        }

        protected String[] toString(SQLStatement[] stmts) {
            ArrayList<String> result = new ArrayList<String>();
            if (stmts != null) {
                Integer idx = 0;
                while (idx < stmts.length) {
                    String stringStatement;
                    SQLStatement statement = stmts[idx];
                    if (statement != null && (stringStatement = this.vendor.toString(statement)) != null && stringStatement.length() > 0) {
                        result.add(this.vendor.toString(statement));
                    }
                    idx = idx + 1;
                }
            }
            return result.toArray(new String[result.size()]);
        }

        protected SQLVendor getVendor() {
            return this.vendor;
        }

        protected String getSchemaName() {
            return this.schemaName;
        }

        protected SQLStatement[] createSchemaStatements(SQLVendor vendor) {
            return new SQLStatement[]{(SQLStatement)vendor.getDefinitionFactory().createSchemaDefinitionBuilder().setSchemaName(this.schemaName).createExpression()};
        }

        protected SQLStatement[] createIndicesStatements(SQLVendor vendor) {
            return new SQLStatement[0];
        }

        protected SQLStatement[] createTableStatements(SQLVendor vendor) {
            DefinitionFactory d = vendor.getDefinitionFactory();
            TableReferenceFactory t = vendor.getTableReferenceFactory();
            return new SQLStatement[]{(SQLStatement)d.createTableDefinitionBuilder().setTableName(t.tableName(this.getSchemaName(), "qi4j_entities")).setTableContentsSource((TableContentsSource)d.createTableElementListBuilder().addTableElement((TableElement)d.createColumnDefinition("entity_pk", this.getPKType(), Boolean.valueOf(false), AutoGenerationPolicy.BY_DEFAULT)).addTableElement((TableElement)d.createColumnDefinition("entity_optimistic_lock", this.getOptimisticLockType(), Boolean.valueOf(false))).addTableElement((TableElement)d.createColumnDefinition("entity_id", this.getIDType(), Boolean.valueOf(false))).addTableElement((TableElement)d.createColumnDefinition("entity_state", this.getStateType(), Boolean.valueOf(false))).addTableElement((TableElement)d.createColumnDefinition("entity_last_modified", this.getLastModifiedType(), Boolean.valueOf(false))).addTableElement((TableElement)d.createTableConstraintDefinition((TableConstraint)d.createUniqueConstraintBuilder().setUniqueness(UniqueSpecification.PRIMARY_KEY).addColumns(new String[]{"entity_pk"}).createExpression())).addTableElement((TableElement)d.createTableConstraintDefinition((TableConstraint)d.createUniqueConstraintBuilder().setUniqueness(UniqueSpecification.UNIQUE).addColumns(new String[]{"entity_id"}).createExpression())).createExpression()).createExpression()};
        }

        protected SQLStatement createSelectAllEntitiesStatement(SQLVendor vendor) {
            QueryFactory q = vendor.getQueryFactory();
            TableReferenceFactory t = vendor.getTableReferenceFactory();
            return (SQLStatement)q.simpleQueryBuilder().select(new String[]{"entity_pk", "entity_optimistic_lock", "entity_state"}).from(new TableName[]{t.tableName(this.schemaName, "qi4j_entities")}).createExpression();
        }

        protected SQLStatement createSelectEntityStatement(SQLVendor vendor) {
            QueryFactory q = vendor.getQueryFactory();
            TableReferenceFactory t = vendor.getTableReferenceFactory();
            BooleanFactory b = vendor.getBooleanFactory();
            ColumnsFactory c = vendor.getColumnsFactory();
            LiteralFactory l = vendor.getLiteralFactory();
            return (SQLStatement)q.simpleQueryBuilder().select(new String[]{"entity_pk", "entity_optimistic_lock", "entity_state"}).from(new TableName[]{t.tableName(this.schemaName, "qi4j_entities")}).where((BooleanExpression)b.eq((NonBooleanExpression)c.colName("entity_id"), (NonBooleanExpression)l.param())).createExpression();
        }

        protected SQLStatement createInsertEntityStatement(SQLVendor vendor) {
            ModificationFactory m = vendor.getModificationFactory();
            TableReferenceFactory t = vendor.getTableReferenceFactory();
            LiteralFactory l = vendor.getLiteralFactory();
            return (SQLStatement)m.insert().setTableName(t.tableName(this.schemaName, "qi4j_entities")).setColumnSource((ColumnSource)m.columnSourceByValues().addColumnNames(new String[]{"entity_optimistic_lock", "entity_id", "entity_state", "entity_last_modified"}).addValues(new ValueExpression[]{l.n((Number)0), l.param(), l.param(), l.param()}).createExpression()).createExpression();
        }

        protected SQLStatement createUpdateEntityStatement(SQLVendor vendor) {
            ModificationFactory m = vendor.getModificationFactory();
            TableReferenceFactory t = vendor.getTableReferenceFactory();
            LiteralFactory l = vendor.getLiteralFactory();
            BooleanFactory b = vendor.getBooleanFactory();
            ColumnsFactory c = vendor.getColumnsFactory();
            UpdateBySearchBuilder builder = m.updateBySearch().setTargetTable(m.createTargetTable(t.tableName(this.schemaName, "qi4j_entities"))).addSetClauses(new SetClause[]{m.setClause("entity_optimistic_lock", (UpdateSource)m.updateSourceByExp((ValueExpression)l.param())), m.setClause("entity_state", (UpdateSource)m.updateSourceByExp((ValueExpression)l.param())), m.setClause("entity_last_modified", (UpdateSource)m.updateSourceByExp((ValueExpression)l.param()))});
            builder.getWhereBuilder().reset((BooleanExpression)b.eq((NonBooleanExpression)c.colName("entity_pk"), (NonBooleanExpression)l.param())).and((BooleanExpression)b.eq((NonBooleanExpression)c.colName("entity_optimistic_lock"), (NonBooleanExpression)l.param()));
            return (SQLStatement)builder.createExpression();
        }

        protected SQLStatement createRemoveEntityStatement(SQLVendor vendor) {
            ModificationFactory m = vendor.getModificationFactory();
            TableReferenceFactory t = vendor.getTableReferenceFactory();
            LiteralFactory l = vendor.getLiteralFactory();
            BooleanFactory b = vendor.getBooleanFactory();
            ColumnsFactory c = vendor.getColumnsFactory();
            DeleteBySearchBuilder builder = m.deleteBySearch().setTargetTable(m.createTargetTable(t.tableName(this.schemaName, "qi4j_entities")));
            builder.getWhere().reset((BooleanExpression)b.eq((NonBooleanExpression)c.colName("entity_pk"), (NonBooleanExpression)l.param()));
            return (SQLStatement)builder.createExpression();
        }

        protected SQLDataType getPKType() {
            return this.vendor.getDataTypeFactory().bigInt();
        }

        protected SQLDataType getOptimisticLockType() {
            return this.vendor.getDataTypeFactory().bigInt();
        }

        protected SQLDataType getIDType() {
            return this.vendor.getDataTypeFactory().sqlVarChar(Integer.valueOf(64));
        }

        protected SQLDataType getStateType() {
            return this.vendor.getDataTypeFactory().sqlVarChar(Integer.valueOf(10000));
        }

        protected SQLDataType getLastModifiedType() {
            return this.vendor.getDataTypeFactory().bigInt();
        }

        @Override
        public String[] buildSQLForSchemaCreation() {
            return this.schemaCreationSQLs;
        }

        @Override
        public String[] buildSQLForIndexCreation() {
            return this.indexCreationSQLs;
        }

        @Override
        public String buildSQLForSelectAllEntitiesStatement() {
            return this.selectAllEntitiesSQL;
        }

        @Override
        public String buildSQLForSelectEntityStatement() {
            return this.selectEntitySQL;
        }

        @Override
        public String buildSQLForInsertEntityStatement() {
            return this.insertEntitySQL;
        }

        @Override
        public String buildSQLForUpdateEntityStatement() {
            return this.updateEntitySQL;
        }

        @Override
        public String buildSQLForRemoveEntityStatement() {
            return this.removeEntitySQL;
        }

        @Override
        public String[] buildSQLForTableCreation() {
            return this.tableCreationSQLs;
        }
    }
}

