/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.circuitbreaker;

import org.qi4j.functional.Specification;
import org.qi4j.io.Output;
import org.qi4j.io.Receiver;
import org.qi4j.io.Sender;
import org.qi4j.library.circuitbreaker.CircuitBreaker;

public class CircuitBreakers {
    public static <Item, ReceiverThrowable extends Throwable> Output<Item, ReceiverThrowable> withBreaker(final CircuitBreaker breaker, final Output<Item, ReceiverThrowable> output) {
        return new Output<Item, ReceiverThrowable>(){

            public <SenderThrowableType extends Throwable> void receiveFrom(final Sender<? extends Item, SenderThrowableType> sender) throws Throwable, Throwable {
                output.receiveFrom(new Sender<Item, SenderThrowableType>(){

                    public <ReceiverThrowableType extends Throwable> void sendTo(final Receiver<? super Item, ReceiverThrowableType> receiver) throws Throwable, Throwable {
                        if (!breaker.isOn()) {
                            throw breaker.lastThrowable();
                        }
                        sender.sendTo(new Receiver<Item, ReceiverThrowableType>(){

                            public void receive(Item item) throws Throwable {
                                try {
                                    receiver.receive(item);
                                    breaker.success();
                                }
                                catch (Throwable receiverThrowableType) {
                                    breaker.throwable(receiverThrowableType);
                                    throw receiverThrowableType;
                                }
                            }
                        });
                    }
                });
            }
        };
    }

    public static Specification<Throwable> in(final Class<? extends Throwable> ... throwables) {
        return new Specification<Throwable>(){

            public boolean satisfiedBy(Throwable item) {
                Class<?> throwableClass = item.getClass();
                for (Class throwable : throwables) {
                    if (!throwable.isAssignableFrom(throwableClass)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Specification<Throwable> rootCause(final Specification<Throwable> specification) {
        return new Specification<Throwable>(){

            public boolean satisfiedBy(Throwable item) {
                return specification.satisfiedBy((Object)this.unwrap(item));
            }

            private Throwable unwrap(Throwable item) {
                if (item.getCause() != null) {
                    return item.getCause();
                }
                return item;
            }
        };
    }
}

