/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.circuitbreaker.jmx;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.qi4j.api.activation.ActivatorAdapter;
import org.qi4j.api.activation.Activators;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.structure.Application;
import org.qi4j.library.circuitbreaker.CircuitBreaker;
import org.qi4j.library.circuitbreaker.jmx.CircuitBreakerJMX;
import org.qi4j.library.circuitbreaker.service.ServiceCircuitBreaker;
import org.qi4j.library.jmx.Qi4jMBeans;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mixins(value={Mixin.class})
@Activators(value={Activator.class})
public interface CircuitBreakerManagement
extends ServiceComposite {
    public void registerCircuitBreakers() throws JMException;

    public void unregisterCircuitBreakers() throws JMException;

    public static abstract class Mixin
    implements CircuitBreakerManagement {
        private static final Logger LOGGER = LoggerFactory.getLogger(CircuitBreakerManagement.class);
        private final Map<CircuitBreaker, ObjectName> registeredCircuitBreakers = new HashMap<CircuitBreaker, ObjectName>();
        @Structure
        private Application application;
        @Service
        private MBeanServer server;
        @Service
        Iterable<ServiceReference<ServiceCircuitBreaker>> circuitBreakers;

        @Override
        public void registerCircuitBreakers() throws JMException {
            for (ServiceReference<ServiceCircuitBreaker> circuitBreaker : this.circuitBreakers) {
                this.registerCircuitBreaker(((ServiceCircuitBreaker)circuitBreaker.get()).circuitBreaker(), circuitBreaker.identity());
            }
        }

        @Override
        public void unregisterCircuitBreakers() throws JMException {
            for (ObjectName objectName : this.registeredCircuitBreakers.values()) {
                this.server.unregisterMBean(objectName);
            }
            this.registeredCircuitBreakers.clear();
        }

        private void registerCircuitBreaker(CircuitBreaker circuitBreaker, final String name) throws JMException {
            ObjectName mbeanObjectName = null;
            ObjectName serviceName = Qi4jMBeans.findServiceName((MBeanServer)this.server, (String)this.application.name(), (String)name);
            if (serviceName != null) {
                mbeanObjectName = new ObjectName(serviceName.toString() + ",name=Circuit breaker");
            } else {
                try {
                    mbeanObjectName = new ObjectName("CircuitBreaker:name=" + name);
                }
                catch (MalformedObjectNameException e) {
                    throw new IllegalArgumentException("Illegal name:" + name);
                }
            }
            CircuitBreakerJMX bean = new CircuitBreakerJMX(circuitBreaker, mbeanObjectName);
            this.server.registerMBean(bean, mbeanObjectName);
            this.registeredCircuitBreakers.put(circuitBreaker, mbeanObjectName);
            circuitBreaker.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("status".equals(evt.getPropertyName())) {
                        if (CircuitBreaker.Status.on.equals(evt.getNewValue())) {
                            LOGGER.info("Circuit breaker " + name + " is now on");
                        } else {
                            LOGGER.error("Circuit breaker " + name + " is now off");
                        }
                    }
                }
            });
        }
    }

    public static class Activator
    extends ActivatorAdapter<ServiceReference<CircuitBreakerManagement>> {
        public void afterActivation(ServiceReference<CircuitBreakerManagement> activated) throws Exception {
            ((CircuitBreakerManagement)activated.get()).registerCircuitBreakers();
        }

        public void beforePassivation(ServiceReference<CircuitBreakerManagement> passivating) throws Exception {
            ((CircuitBreakerManagement)passivating.get()).unregisterCircuitBreakers();
        }
    }
}

