/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.entitystore.prefs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.cache.CacheOptions;
import org.qi4j.api.common.QualifiedName;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.property.PropertyDescriptor;
import org.qi4j.api.service.ServiceActivation;
import org.qi4j.api.service.ServiceDescriptor;
import org.qi4j.api.service.qualifier.Tagged;
import org.qi4j.api.structure.Application;
import org.qi4j.api.structure.Module;
import org.qi4j.api.type.CollectionType;
import org.qi4j.api.type.EnumType;
import org.qi4j.api.type.MapType;
import org.qi4j.api.type.ValueCompositeType;
import org.qi4j.api.type.ValueType;
import org.qi4j.api.unitofwork.EntityTypeNotFoundException;
import org.qi4j.api.unitofwork.NoSuchEntityException;
import org.qi4j.api.usecase.Usecase;
import org.qi4j.api.usecase.UsecaseBuilder;
import org.qi4j.api.value.ValueSerialization;
import org.qi4j.api.value.ValueSerializationException;
import org.qi4j.entitystore.prefs.PreferencesEntityStoreInfo;
import org.qi4j.entitystore.prefs.PreferencesEntityStoreService;
import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;
import org.qi4j.io.Input;
import org.qi4j.io.Output;
import org.qi4j.io.Receiver;
import org.qi4j.io.Sender;
import org.qi4j.spi.Qi4jSPI;
import org.qi4j.spi.entity.EntityState;
import org.qi4j.spi.entity.EntityStatus;
import org.qi4j.spi.entitystore.DefaultEntityStoreUnitOfWork;
import org.qi4j.spi.entitystore.EntityStore;
import org.qi4j.spi.entitystore.EntityStoreException;
import org.qi4j.spi.entitystore.EntityStoreSPI;
import org.qi4j.spi.entitystore.EntityStoreUnitOfWork;
import org.qi4j.spi.entitystore.ModuleEntityStoreUnitOfWork;
import org.qi4j.spi.entitystore.StateCommitter;
import org.qi4j.spi.entitystore.helpers.DefaultEntityState;
import org.qi4j.spi.module.ModelModule;
import org.qi4j.spi.module.ModuleSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencesEntityStoreMixin
implements ServiceActivation,
EntityStore,
EntityStoreSPI {
    @Structure
    private Qi4jSPI spi;
    @This
    private EntityStoreSPI entityStoreSpi;
    @Uses
    private ServiceDescriptor descriptor;
    @Structure
    private Application application;
    @Service
    @Tagged(value={"json"})
    private ValueSerialization valueSerialization;
    private Preferences root;
    protected String uuid;
    private int count;
    public Logger logger;
    public ScheduledThreadPoolExecutor reloadExecutor;
    private static final NumberParser<Long> LONG_PARSER = new NumberParser<Long>(){

        @Override
        public Long parse(String str) {
            return Long.parseLong(str);
        }
    };
    private static final NumberParser<Integer> INT_PARSER = new NumberParser<Integer>(){

        @Override
        public Integer parse(String str) {
            return Integer.parseInt(str);
        }
    };
    private static final NumberParser<Double> DOUBLE_PARSER = new NumberParser<Double>(){

        @Override
        public Double parse(String str) {
            return Double.parseDouble(str);
        }
    };
    private static final NumberParser<Float> FLOAT_PARSER = new NumberParser<Float>(){

        @Override
        public Float parse(String str) {
            return Float.valueOf(Float.parseFloat(str));
        }
    };

    public void activateService() throws Exception {
        this.root = this.getApplicationRoot();
        this.logger = LoggerFactory.getLogger((String)PreferencesEntityStoreService.class.getName());
        this.logger.info("Preferences store:" + this.root.absolutePath());
        this.uuid = UUID.randomUUID().toString() + "-";
        this.reloadExecutor = new ScheduledThreadPoolExecutor(1);
        this.reloadExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.reloadExecutor.scheduleAtFixedRate(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Preferences preferences = PreferencesEntityStoreMixin.this.root;
                    synchronized (preferences) {
                        PreferencesEntityStoreMixin.this.root.sync();
                    }
                }
                catch (BackingStoreException e) {
                    PreferencesEntityStoreMixin.this.logger.warn("Could not reload preferences", (Throwable)e);
                }
            }
        }, 0L, 60L, TimeUnit.SECONDS);
    }

    private Preferences getApplicationRoot() {
        Preferences preferences;
        PreferencesEntityStoreInfo storeInfo = (PreferencesEntityStoreInfo)this.descriptor.metaInfo(PreferencesEntityStoreInfo.class);
        if (storeInfo == null) {
            preferences = Preferences.systemRoot();
            String name = this.application.name();
            preferences = preferences.node(name);
        } else {
            preferences = storeInfo.rootNode();
        }
        return preferences;
    }

    public void passivateService() throws Exception {
        this.reloadExecutor.shutdown();
        this.reloadExecutor.awaitTermination(10L, TimeUnit.SECONDS);
    }

    public EntityStoreUnitOfWork newUnitOfWork(Usecase usecase, ModuleSpi module, long currentTime) {
        DefaultEntityStoreUnitOfWork storeUnitOfWork = new DefaultEntityStoreUnitOfWork(this.entityStoreSpi, this.newUnitOfWorkId(), usecase, currentTime);
        storeUnitOfWork = new ModuleEntityStoreUnitOfWork(module, (EntityStoreUnitOfWork)storeUnitOfWork);
        return storeUnitOfWork;
    }

    public Input<EntityState, EntityStoreException> entityStates(final ModuleSpi module) {
        return new Input<EntityState, EntityStoreException>(){

            public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super EntityState, ReceiverThrowableType> output) throws EntityStoreException, ReceiverThrowableType {
                output.receiveFrom((Sender)new Sender<EntityState, EntityStoreException>(){

                    public <ReceiverThrowableType extends Throwable> void sendTo(Receiver<? super EntityState, ReceiverThrowableType> receiver) throws ReceiverThrowableType, EntityStoreException {
                        UsecaseBuilder builder = UsecaseBuilder.buildUsecase((String)"qi4j.entitystore.preferences.visit");
                        Usecase visitUsecase = builder.withMetaInfo((Object)CacheOptions.NEVER).newUsecase();
                        EntityStoreUnitOfWork uow = PreferencesEntityStoreMixin.this.newUnitOfWork(visitUsecase, module, System.currentTimeMillis());
                        try {
                            String[] identities;
                            for (String identity : identities = PreferencesEntityStoreMixin.this.root.childrenNames()) {
                                EntityReference reference = EntityReference.parseEntityReference((String)identity);
                                EntityState entityState = uow.entityStateOf(module, reference);
                                receiver.receive((Object)entityState);
                            }
                        }
                        catch (BackingStoreException e) {
                            throw new EntityStoreException((Throwable)e);
                        }
                    }
                });
            }
        };
    }

    public EntityState newEntityState(EntityStoreUnitOfWork unitOfWork, ModuleSpi module, EntityReference identity, EntityDescriptor entityDescriptor) {
        return new DefaultEntityState(unitOfWork.currentTime(), identity, entityDescriptor);
    }

    public EntityState entityStateOf(EntityStoreUnitOfWork unitOfWork, ModuleSpi module, EntityReference identity) {
        try {
            Object value;
            if (!this.root.nodeExists(identity.identity())) {
                throw new NoSuchEntityException(identity, UnknownType.class, unitOfWork.usecase());
            }
            Preferences entityPrefs = this.root.node(identity.identity());
            String type = entityPrefs.get("type", null);
            EntityStatus status = EntityStatus.LOADED;
            EntityDescriptor entityDescriptor = module.entityDescriptor(type);
            if (entityDescriptor == null) {
                throw new EntityTypeNotFoundException(type, module.name(), Iterables.map((Function)ModelModule.toStringFunction, (Iterable)module.findVisibleEntityTypes()));
            }
            HashMap<QualifiedName, Object> properties = new HashMap<QualifiedName, Object>();
            Preferences propsPrefs = null;
            for (PropertyDescriptor persistentPropertyDescriptor : entityDescriptor.state().properties()) {
                String json;
                ValueType propertyType;
                Class mainType;
                if (persistentPropertyDescriptor.qualifiedName().name().equals("identity")) {
                    properties.put(persistentPropertyDescriptor.qualifiedName(), identity.identity());
                    continue;
                }
                if (propsPrefs == null) {
                    propsPrefs = entityPrefs.node("properties");
                }
                if (Number.class.isAssignableFrom(mainType = (propertyType = persistentPropertyDescriptor.valueType()).mainType())) {
                    if (mainType.equals(Long.class)) {
                        properties.put(persistentPropertyDescriptor.qualifiedName(), this.getNumber(propsPrefs, persistentPropertyDescriptor, LONG_PARSER));
                        continue;
                    }
                    if (mainType.equals(Integer.class)) {
                        properties.put(persistentPropertyDescriptor.qualifiedName(), this.getNumber(propsPrefs, persistentPropertyDescriptor, INT_PARSER));
                        continue;
                    }
                    if (mainType.equals(Double.class)) {
                        properties.put(persistentPropertyDescriptor.qualifiedName(), this.getNumber(propsPrefs, persistentPropertyDescriptor, DOUBLE_PARSER));
                        continue;
                    }
                    if (mainType.equals(Float.class)) {
                        properties.put(persistentPropertyDescriptor.qualifiedName(), this.getNumber(propsPrefs, persistentPropertyDescriptor, FLOAT_PARSER));
                        continue;
                    }
                    json = propsPrefs.get(persistentPropertyDescriptor.qualifiedName().name(), null);
                    value = json == null ? null : this.valueSerialization.deserialize(persistentPropertyDescriptor.valueType(), json);
                    properties.put(persistentPropertyDescriptor.qualifiedName(), value);
                    continue;
                }
                if (mainType.equals(Boolean.class)) {
                    Boolean initialValue = (Boolean)persistentPropertyDescriptor.initialValue((Module)module);
                    properties.put(persistentPropertyDescriptor.qualifiedName(), propsPrefs.getBoolean(persistentPropertyDescriptor.qualifiedName().name(), initialValue == null ? false : initialValue));
                    continue;
                }
                if (propertyType instanceof ValueCompositeType || propertyType instanceof MapType || propertyType instanceof CollectionType || propertyType instanceof EnumType) {
                    json = propsPrefs.get(persistentPropertyDescriptor.qualifiedName().name(), null);
                    value = json == null ? null : this.valueSerialization.deserialize(persistentPropertyDescriptor.valueType(), json);
                    properties.put(persistentPropertyDescriptor.qualifiedName(), value);
                    continue;
                }
                json = propsPrefs.get(persistentPropertyDescriptor.qualifiedName().name(), null);
                if (json == null) {
                    if (persistentPropertyDescriptor.initialValue((Module)module) != null) {
                        properties.put(persistentPropertyDescriptor.qualifiedName(), persistentPropertyDescriptor.initialValue((Module)module));
                        continue;
                    }
                    properties.put(persistentPropertyDescriptor.qualifiedName(), null);
                    continue;
                }
                value = this.valueSerialization.deserialize(propertyType, json);
                properties.put(persistentPropertyDescriptor.qualifiedName(), value);
            }
            HashMap<QualifiedName, EntityReference> associations = new HashMap<QualifiedName, EntityReference>();
            Preferences assocs = null;
            for (AssociationDescriptor associationType : entityDescriptor.state().associations()) {
                String associatedEntity;
                if (assocs == null) {
                    assocs = entityPrefs.node("associations");
                }
                value = (associatedEntity = assocs.get(associationType.qualifiedName().name(), null)) == null ? null : EntityReference.parseEntityReference((String)associatedEntity);
                associations.put(associationType.qualifiedName(), (EntityReference)value);
            }
            HashMap manyAssociations = new HashMap();
            Preferences manyAssocs = null;
            for (AssociationDescriptor manyAssociationType : entityDescriptor.state().manyAssociations()) {
                String[] refs;
                if (manyAssocs == null) {
                    manyAssocs = entityPrefs.node("manyassociations");
                }
                ArrayList<EntityReference> references = new ArrayList<EntityReference>();
                String entityReferences = manyAssocs.get(manyAssociationType.qualifiedName().name(), null);
                if (entityReferences == null) {
                    manyAssociations.put(manyAssociationType.qualifiedName(), references);
                    continue;
                }
                for (String ref : refs = entityReferences.split("\n")) {
                    EntityReference value2 = ref == null ? null : EntityReference.parseEntityReference((String)ref);
                    references.add(value2);
                }
                manyAssociations.put(manyAssociationType.qualifiedName(), references);
            }
            HashMap namedAssociations = new HashMap();
            Preferences namedAssocs = null;
            for (AssociationDescriptor namedAssociationType : entityDescriptor.state().namedAssociations()) {
                if (namedAssocs == null) {
                    namedAssocs = entityPrefs.node("namedassociations");
                }
                LinkedHashMap<String, EntityReference> references = new LinkedHashMap<String, EntityReference>();
                String entityReferences = namedAssocs.get(namedAssociationType.qualifiedName().name(), null);
                if (entityReferences == null) {
                    namedAssociations.put(namedAssociationType.qualifiedName(), references);
                    continue;
                }
                String[] namedRefs = entityReferences.split("\n");
                if (namedRefs.length % 2 != 0) {
                    throw new EntityStoreException("Invalid NamedAssociation storage format");
                }
                for (int idx = 0; idx < namedRefs.length; idx += 2) {
                    String name = namedRefs[idx];
                    String ref = namedRefs[idx + 1];
                    references.put(name, EntityReference.parseEntityReference((String)ref));
                }
                namedAssociations.put(namedAssociationType.qualifiedName(), references);
            }
            return new DefaultEntityState(entityPrefs.get("version", ""), entityPrefs.getLong("modified", unitOfWork.currentTime()), identity, status, entityDescriptor, properties, associations, manyAssociations, namedAssociations);
        }
        catch (BackingStoreException | ValueSerializationException e) {
            throw new EntityStoreException(e);
        }
    }

    public StateCommitter applyChanges(final EntityStoreUnitOfWork unitofwork, final Iterable<EntityState> state) {
        return new StateCommitter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void commit() {
                try {
                    Preferences preferences = PreferencesEntityStoreMixin.this.root;
                    synchronized (preferences) {
                        for (EntityState entityState : state) {
                            Preferences entityPrefs;
                            DefaultEntityState state2 = (DefaultEntityState)entityState;
                            if (state2.status().equals((Object)EntityStatus.NEW)) {
                                entityPrefs = PreferencesEntityStoreMixin.this.root.node(state2.identity().identity());
                                PreferencesEntityStoreMixin.this.writeEntityState(state2, entityPrefs, unitofwork.identity(), unitofwork.currentTime());
                                continue;
                            }
                            if (state2.status().equals((Object)EntityStatus.UPDATED)) {
                                entityPrefs = PreferencesEntityStoreMixin.this.root.node(state2.identity().identity());
                                PreferencesEntityStoreMixin.this.writeEntityState(state2, entityPrefs, unitofwork.identity(), unitofwork.currentTime());
                                continue;
                            }
                            if (!state2.status().equals((Object)EntityStatus.REMOVED)) continue;
                            PreferencesEntityStoreMixin.this.root.node(state2.identity().identity()).removeNode();
                        }
                        PreferencesEntityStoreMixin.this.root.flush();
                    }
                }
                catch (BackingStoreException e) {
                    throw new EntityStoreException((Throwable)e);
                }
            }

            public void cancel() {
            }
        };
    }

    protected void writeEntityState(DefaultEntityState state, Preferences entityPrefs, String identity, long lastModified) throws EntityStoreException {
        try {
            entityPrefs.put("type", ((Class)Iterables.first((Iterable)state.entityDescriptor().types())).getName());
            entityPrefs.put("version", identity);
            entityPrefs.putLong("modified", lastModified);
            Preferences propsPrefs = entityPrefs.node("properties");
            for (PropertyDescriptor persistentProperty : state.entityDescriptor().state().properties()) {
                if (persistentProperty.qualifiedName().name().equals("identity")) continue;
                Object value = state.properties().get(persistentProperty.qualifiedName());
                if (value == null) {
                    propsPrefs.remove(persistentProperty.qualifiedName().name());
                    continue;
                }
                ValueType valueType = persistentProperty.valueType();
                Class mainType = valueType.mainType();
                if (Number.class.isAssignableFrom(mainType)) {
                    if (mainType.equals(Long.class)) {
                        propsPrefs.putLong(persistentProperty.qualifiedName().name(), (Long)value);
                        continue;
                    }
                    if (mainType.equals(Integer.class)) {
                        propsPrefs.putInt(persistentProperty.qualifiedName().name(), (Integer)value);
                        continue;
                    }
                    if (mainType.equals(Double.class)) {
                        propsPrefs.putDouble(persistentProperty.qualifiedName().name(), (Double)value);
                        continue;
                    }
                    if (mainType.equals(Float.class)) {
                        propsPrefs.putFloat(persistentProperty.qualifiedName().name(), ((Float)value).floatValue());
                        continue;
                    }
                    String string = this.valueSerialization.serialize(value);
                    propsPrefs.put(persistentProperty.qualifiedName().name(), string);
                    continue;
                }
                if (mainType.equals(Boolean.class)) {
                    propsPrefs.putBoolean(persistentProperty.qualifiedName().name(), (Boolean)value);
                    continue;
                }
                if (valueType instanceof ValueCompositeType || valueType instanceof MapType || valueType instanceof CollectionType || valueType instanceof EnumType) {
                    String string = this.valueSerialization.serialize(value);
                    propsPrefs.put(persistentProperty.qualifiedName().name(), string);
                    continue;
                }
                String string = this.valueSerialization.serialize(value);
                propsPrefs.put(persistentProperty.qualifiedName().name(), string);
            }
            if (!state.associations().isEmpty()) {
                Preferences assocsPrefs = entityPrefs.node("associations");
                for (Map.Entry association : state.associations().entrySet()) {
                    if (association.getValue() == null) {
                        assocsPrefs.remove(((QualifiedName)association.getKey()).name());
                        continue;
                    }
                    assocsPrefs.put(((QualifiedName)association.getKey()).name(), ((EntityReference)association.getValue()).identity());
                }
            }
            if (!state.manyAssociations().isEmpty()) {
                Preferences manyAssocsPrefs = entityPrefs.node("manyassociations");
                for (Map.Entry manyAssociation : state.manyAssociations().entrySet()) {
                    StringBuilder manyAssocs = new StringBuilder();
                    for (EntityReference entityReference : (List)manyAssociation.getValue()) {
                        if (manyAssocs.length() > 0) {
                            manyAssocs.append("\n");
                        }
                        manyAssocs.append(entityReference.identity());
                    }
                    if (manyAssocs.length() <= 0) continue;
                    manyAssocsPrefs.put(((QualifiedName)manyAssociation.getKey()).name(), manyAssocs.toString());
                }
            }
            if (!state.namedAssociations().isEmpty()) {
                Preferences namedAssocsPrefs = entityPrefs.node("namedassociations");
                for (Map.Entry namedAssociation : state.namedAssociations().entrySet()) {
                    StringBuilder namedAssocs = new StringBuilder();
                    for (Map.Entry entry : ((Map)namedAssociation.getValue()).entrySet()) {
                        if (namedAssocs.length() > 0) {
                            namedAssocs.append("\n");
                        }
                        namedAssocs.append((String)entry.getKey()).append("\n").append(((EntityReference)entry.getValue()).identity());
                    }
                    if (namedAssocs.length() <= 0) continue;
                    namedAssocsPrefs.put(((QualifiedName)namedAssociation.getKey()).name(), namedAssocs.toString());
                }
            }
        }
        catch (ValueSerializationException e) {
            throw new EntityStoreException("Could not store EntityState", (Throwable)e);
        }
    }

    protected String newUnitOfWorkId() {
        return this.uuid + Integer.toHexString(this.count++);
    }

    private <T> T getNumber(Preferences prefs, PropertyDescriptor pDesc, NumberParser<T> parser) {
        Object initialValue = pDesc.initialValue(null);
        String str = prefs.get(pDesc.qualifiedName().name(), initialValue == null ? null : initialValue.toString());
        T result = null;
        if (str != null) {
            result = parser.parse(str);
        }
        return result;
    }

    private static class UnknownType {
        private UnknownType() {
        }
    }

    private static interface NumberParser<T> {
        public T parse(String var1);
    }
}

