/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.server.assembler;

import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import java.util.Properties;
import org.apache.velocity.app.VelocityEngine;
import org.qi4j.api.common.Visibility;
import org.qi4j.api.service.importer.NewObjectImporter;
import org.qi4j.api.util.Classes;
import org.qi4j.bootstrap.Assembler;
import org.qi4j.bootstrap.AssemblyException;
import org.qi4j.bootstrap.ClassScanner;
import org.qi4j.bootstrap.ImportedServiceDeclaration;
import org.qi4j.bootstrap.ModuleAssembly;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.functional.Specifications;
import org.qi4j.library.rest.server.restlet.InteractionConstraintsService;
import org.qi4j.library.rest.server.restlet.RequestReaderDelegator;
import org.qi4j.library.rest.server.restlet.ResponseWriterDelegator;
import org.qi4j.library.rest.server.restlet.freemarker.ValueCompositeObjectWrapper;
import org.qi4j.library.rest.server.restlet.requestreader.DefaultRequestReader;
import org.qi4j.library.rest.server.restlet.responsewriter.AbstractResponseWriter;
import org.qi4j.library.rest.server.restlet.responsewriter.DefaultResponseWriter;
import org.qi4j.library.rest.server.spi.ResponseWriter;
import org.restlet.service.MetadataService;

public class RestServerAssembler
implements Assembler {
    public void assemble(ModuleAssembly module) throws AssemblyException {
        Properties props = new Properties();
        try {
            props.load(this.getClass().getResourceAsStream("/velocity.properties"));
            VelocityEngine velocity = new VelocityEngine(props);
            module.importedServices(new Class[]{VelocityEngine.class}).importedBy(ImportedServiceDeclaration.INSTANCE).setMetaInfo((Object)velocity);
        }
        catch (Exception e) {
            throw new AssemblyException("Could not load velocity properties", (Throwable)e);
        }
        Configuration cfg = new Configuration();
        cfg.setClassForTemplateLoading(AbstractResponseWriter.class, "");
        cfg.setObjectWrapper((ObjectWrapper)new ValueCompositeObjectWrapper());
        module.importedServices(new Class[]{Configuration.class}).setMetaInfo((Object)cfg);
        module.importedServices(new Class[]{MetadataService.class});
        module.importedServices(new Class[]{ResponseWriterDelegator.class}).identifiedBy("responsewriterdelegator").importedBy(ImportedServiceDeclaration.NEW_OBJECT).visibleIn(Visibility.layer);
        module.objects(new Class[]{ResponseWriterDelegator.class});
        module.importedServices(new Class[]{RequestReaderDelegator.class}).identifiedBy("requestreaderdelegator").importedBy(ImportedServiceDeclaration.NEW_OBJECT).visibleIn(Visibility.layer);
        module.objects(new Class[]{RequestReaderDelegator.class});
        module.importedServices(new Class[]{InteractionConstraintsService.class}).importedBy(NewObjectImporter.class).visibleIn(Visibility.application);
        module.objects(new Class[]{InteractionConstraintsService.class});
        Iterable writers = ClassScanner.findClasses(DefaultResponseWriter.class);
        Specification responseWriterClass = Classes.isAssignableFrom(ResponseWriter.class);
        Specification isNotAnAbstract = Specifications.not((Specification)Classes.hasModifier((int)1024));
        Iterable candidates = Iterables.filter((Specification)Specifications.and((Specification[])new Specification[]{isNotAnAbstract, responseWriterClass}), (Iterable)writers);
        for (Class responseWriter : candidates) {
            module.objects(new Class[]{responseWriter});
        }
        module.objects(new Class[]{DefaultRequestReader.class});
    }
}

