/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.server.restlet.responsewriter;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.library.rest.server.restlet.responsewriter.AbstractResponseWriter;
import org.restlet.Response;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Parameter;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.WriterRepresentation;
import org.restlet.resource.ResourceException;

public class FormResponseWriter
extends AbstractResponseWriter {
    private static final List<MediaType> supportedMediaTypes = Arrays.asList(MediaType.TEXT_HTML, MediaType.APPLICATION_JSON);
    @Service
    private Configuration cfg;

    @Override
    public boolean writeResponse(final Object result, final Response response) throws ResourceException {
        if (result instanceof Form) {
            MediaType type = this.getVariant(response.getRequest(), ENGLISH, supportedMediaTypes).getMediaType();
            if (MediaType.APPLICATION_JSON.equals((Object)type)) {
                JSONObject json = new JSONObject();
                Form form = (Form)result;
                try {
                    for (Parameter parameter : form) {
                        String value = parameter.getValue();
                        if (value == null) {
                            json.put(parameter.getName(), JSONObject.NULL);
                            continue;
                        }
                        json.put(parameter.getName(), (Object)value);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                StringRepresentation representation = new StringRepresentation((CharSequence)json.toString(), MediaType.APPLICATION_JSON);
                response.setEntity((Representation)representation);
                return true;
            }
            if (MediaType.TEXT_HTML.equals((Object)type)) {
                WriterRepresentation rep = new WriterRepresentation(MediaType.TEXT_HTML){

                    public void write(Writer writer) throws IOException {
                        HashMap<String, Object> root = new HashMap<String, Object>();
                        root.put("request", response.getRequest());
                        root.put("response", response);
                        root.put("result", result);
                        try {
                            Template formHtmlTemplate = FormResponseWriter.this.cfg.getTemplate("form.htm");
                            formHtmlTemplate.process(root, writer);
                        }
                        catch (TemplateException e) {
                            throw new IOException(e);
                        }
                    }
                };
                response.setEntity((Representation)rep);
                return true;
            }
        }
        return false;
    }
}

