/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.server.restlet.responsewriter;

import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.library.rest.common.Resource;
import org.qi4j.library.rest.common.link.LinksUtil;
import org.qi4j.library.rest.server.restlet.responsewriter.AbstractResponseWriter;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.WriterRepresentation;
import org.restlet.resource.ResourceException;

public class ResourceResponseWriter
extends AbstractResponseWriter {
    private static final List<MediaType> supportedMediaTypes = Arrays.asList(MediaType.TEXT_HTML, MediaType.APPLICATION_JSON, MediaType.APPLICATION_ATOM);
    @Service
    private Configuration cfg;

    @Override
    public boolean writeResponse(final Object result, final Response response) throws ResourceException {
        if (result instanceof Resource) {
            MediaType type;
            Resource resourceValue = (Resource)result;
            response.getAllowedMethods().add(Method.GET);
            if (Iterables.matchesAny((Specification)LinksUtil.withRel((String)"delete"), (Iterable)((Iterable)resourceValue.commands().get()))) {
                response.getAllowedMethods().add(Method.DELETE);
            }
            if (Iterables.matchesAny((Specification)LinksUtil.withRel((String)"update"), (Iterable)((Iterable)resourceValue.commands().get()))) {
                response.getAllowedMethods().add(Method.PUT);
            }
            if (MediaType.APPLICATION_JSON.equals((Object)(type = this.getVariant(response.getRequest(), ENGLISH, supportedMediaTypes).getMediaType()))) {
                response.setEntity((Representation)new StringRepresentation((CharSequence)resourceValue.toString(), MediaType.APPLICATION_JSON));
                return true;
            }
            if (MediaType.TEXT_HTML.equals((Object)type)) {
                WriterRepresentation rep = new WriterRepresentation(MediaType.TEXT_HTML){

                    public void write(Writer writer) throws IOException {
                        HashMap<String, Object> context = new HashMap<String, Object>();
                        context.put("request", response.getRequest());
                        context.put("response", response);
                        context.put("result", result);
                        try {
                            ResourceResponseWriter.this.cfg.getTemplate("resource.htm").process(context, writer);
                        }
                        catch (TemplateException e) {
                            throw new IOException(e);
                        }
                    }
                };
                response.setEntity((Representation)rep);
                return true;
            }
        }
        return false;
    }
}

