/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.server.restlet.responsewriter;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.service.qualifier.Tagged;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.api.value.ValueSerializer;
import org.qi4j.library.rest.server.restlet.responsewriter.AbstractResponseWriter;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.WriterRepresentation;
import org.restlet.resource.ResourceException;

public class ValueCompositeResponseWriter
extends AbstractResponseWriter {
    private static final List<MediaType> supportedMediaTypes = Arrays.asList(MediaType.TEXT_HTML, MediaType.APPLICATION_JSON);
    @Service
    private Configuration cfg;
    @Service
    @Tagged(value={"json"})
    private ValueSerializer valueSerializer;

    @Override
    public boolean writeResponse(final Object result, final Response response) throws ResourceException {
        if (result instanceof ValueComposite) {
            MediaType type = this.getVariant(response.getRequest(), ENGLISH, supportedMediaTypes).getMediaType();
            if (MediaType.APPLICATION_JSON.equals((Object)type)) {
                StringRepresentation representation = new StringRepresentation((CharSequence)this.valueSerializer.serialize(result), MediaType.APPLICATION_JSON);
                response.setEntity((Representation)representation);
                return true;
            }
            if (MediaType.TEXT_HTML.equals((Object)type)) {
                WriterRepresentation rep = new WriterRepresentation(MediaType.TEXT_HTML){

                    public void write(Writer writer) throws IOException {
                        Template template;
                        try {
                            template = ValueCompositeResponseWriter.this.cfg.getTemplate("/rest/template/" + result.getClass().getInterfaces()[0].getSimpleName() + ".htm");
                        }
                        catch (Exception e) {
                            template = ValueCompositeResponseWriter.this.cfg.getTemplate("value.htm");
                        }
                        HashMap<String, Object> context = new HashMap<String, Object>();
                        context.put("request", response.getRequest());
                        context.put("response", response);
                        context.put("result", result);
                        context.put("util", (Object)this);
                        try {
                            template.process(context, writer);
                        }
                        catch (TemplateException e) {
                            throw new IOException(e);
                        }
                    }

                    public boolean isSequence(Object obj) {
                        return obj instanceof Collection;
                    }
                };
                response.setEntity((Representation)rep);
                return true;
            }
        }
        return false;
    }
}

