/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.io;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.zip.GZIPOutputStream;
import org.qi4j.io.Files;
import org.qi4j.io.Output;
import org.qi4j.io.Receiver;
import org.qi4j.io.Sender;

public class Outputs {
    public static Output<String, IOException> text(File file) {
        return Outputs.text(file, "UTF-8");
    }

    public static Output<String, IOException> text(final File file, final String encoding) {
        return new Output<String, IOException>(){

            @Override
            public <SenderThrowableType extends Throwable> void receiveFrom(Sender<? extends String, SenderThrowableType> sender) throws IOException, SenderThrowableType {
                File tmpFile = Files.createTemporayFileOf(file);
                OutputStream stream = new FileOutputStream(tmpFile);
                if (file.getName().endsWith(".gz")) {
                    stream = new GZIPOutputStream(stream);
                }
                final BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream, encoding));
                try {
                    sender.sendTo(new Receiver<String, IOException>(){

                        @Override
                        public void receive(String item) throws IOException {
                            writer.append(item).append('\n');
                        }
                    });
                    writer.close();
                    if (!(file.exists() && !file.delete() || tmpFile.renameTo(file))) {
                        System.err.println("Unable to rename file: " + tmpFile + " to " + file);
                    }
                }
                catch (IOException e) {
                }
                finally {
                    writer.close();
                    if (!tmpFile.delete()) {
                        System.err.println("Unable to delete temporary file.");
                        tmpFile.deleteOnExit();
                    }
                }
            }
        };
    }

    public static Output<String, IOException> text(final Writer writer) {
        return new Output<String, IOException>(){

            @Override
            public <SenderThrowableType extends Throwable> void receiveFrom(Sender<? extends String, SenderThrowableType> sender) throws IOException, SenderThrowableType {
                sender.sendTo(new Receiver<String, IOException>(){

                    @Override
                    public void receive(String item) throws IOException {
                        writer.append(item).append("\n");
                    }
                });
            }
        };
    }

    public static Output<String, IOException> text(final StringBuilder builder) {
        return new Output<String, IOException>(){

            @Override
            public <SenderThrowableType extends Throwable> void receiveFrom(Sender<? extends String, SenderThrowableType> sender) throws IOException, SenderThrowableType {
                sender.sendTo(new Receiver<String, IOException>(){

                    @Override
                    public void receive(String item) throws IOException {
                        builder.append(item).append("\n");
                    }
                });
            }
        };
    }

    public static Output<ByteBuffer, IOException> byteBuffer(final File file) {
        return new Output<ByteBuffer, IOException>(){

            @Override
            public <SenderThrowableType extends Throwable> void receiveFrom(Sender<? extends ByteBuffer, SenderThrowableType> sender) throws IOException, SenderThrowableType {
                File tmpFile = Files.createTemporayFileOf(file);
                FileOutputStream stream = new FileOutputStream(tmpFile);
                final FileChannel fco = stream.getChannel();
                try {
                    sender.sendTo(new Receiver<ByteBuffer, IOException>(){

                        @Override
                        public void receive(ByteBuffer item) throws IOException {
                            fco.write(item);
                        }
                    });
                    stream.close();
                    if (!(file.exists() && !file.delete() || tmpFile.renameTo(file))) {
                        System.err.println("Unable to rename file: " + tmpFile + " to " + file);
                    }
                }
                catch (IOException e) {
                }
                finally {
                    stream.close();
                    if (!tmpFile.delete()) {
                        System.err.println("Unable to delete temporary file.");
                        tmpFile.deleteOnExit();
                    }
                }
            }
        };
    }

    public static Output<ByteBuffer, IOException> byteBuffer(final OutputStream stream) {
        return new Output<ByteBuffer, IOException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <SenderThrowableType extends Throwable> void receiveFrom(Sender<? extends ByteBuffer, SenderThrowableType> sender) throws IOException, SenderThrowableType {
                try {
                    sender.sendTo(new Receiver<ByteBuffer, IOException>(){

                        @Override
                        public void receive(ByteBuffer item) throws IOException {
                            if (item.hasArray()) {
                                stream.write(item.array(), item.arrayOffset(), item.limit());
                            } else {
                                for (int i = 0; i < item.limit(); ++i) {
                                    stream.write(item.get(i));
                                }
                            }
                        }
                    });
                }
                finally {
                    stream.close();
                }
            }
        };
    }

    public static Output<byte[], IOException> bytes(final File file, final int bufferSize) {
        return new Output<byte[], IOException>(){

            @Override
            public <SenderThrowableType extends Throwable> void receiveFrom(Sender<? extends byte[], SenderThrowableType> sender) throws IOException, SenderThrowableType {
                File tmpFile = Files.createTemporayFileOf(file);
                final BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(tmpFile), bufferSize);
                try {
                    sender.sendTo(new Receiver<byte[], IOException>(){

                        @Override
                        public void receive(byte[] item) throws IOException {
                            stream.write(item);
                        }
                    });
                    ((OutputStream)stream).close();
                    if (!(file.exists() && !file.delete() || tmpFile.renameTo(file))) {
                        System.err.println("Unable to rename " + tmpFile + " to " + file);
                    }
                }
                catch (IOException e) {
                }
                finally {
                    ((OutputStream)stream).close();
                    if (!tmpFile.delete()) {
                        System.err.println("Unable to delete temporary file.");
                        tmpFile.deleteOnExit();
                    }
                }
            }
        };
    }

    public static <T> Output<T, RuntimeException> noop() {
        return Outputs.withReceiver(new Receiver<T, RuntimeException>(){

            @Override
            public void receive(T item) throws RuntimeException {
            }
        });
    }

    public static <T, ReceiverThrowableType extends Throwable> Output<T, ReceiverThrowableType> withReceiver(final Receiver<T, ReceiverThrowableType> receiver) {
        return new Output<T, ReceiverThrowableType>(){

            @Override
            public <SenderThrowableType extends Throwable> void receiveFrom(Sender<? extends T, SenderThrowableType> sender) throws Throwable, Throwable {
                sender.sendTo(receiver);
            }
        };
    }

    public static Output<Object, RuntimeException> systemOut() {
        return new Output<Object, RuntimeException>(){

            @Override
            public <SenderThrowableType extends Throwable> void receiveFrom(Sender<?, SenderThrowableType> sender) throws RuntimeException, SenderThrowableType {
                sender.sendTo(new Receiver<Object, RuntimeException>(){

                    @Override
                    public void receive(Object item) {
                        System.out.println(item);
                    }
                });
            }
        };
    }

    public static Output<Object, RuntimeException> systemErr() {
        return new Output<Object, RuntimeException>(){

            @Override
            public <SenderThrowableType extends Throwable> void receiveFrom(Sender<?, SenderThrowableType> sender) throws RuntimeException, SenderThrowableType {
                sender.sendTo(new Receiver<Object, RuntimeException>(){

                    @Override
                    public void receive(Object item) {
                        System.err.println(item);
                    }
                });
            }
        };
    }

    public static <T> Output<T, RuntimeException> collection(final Collection<T> collection) {
        return new Output<T, RuntimeException>(){

            @Override
            public <SenderThrowableType extends Throwable> void receiveFrom(Sender<? extends T, SenderThrowableType> sender) throws RuntimeException, SenderThrowableType {
                sender.sendTo(new Receiver<T, RuntimeException>(){

                    @Override
                    public void receive(T item) throws RuntimeException {
                        collection.add(item);
                    }
                });
            }
        };
    }

    private Outputs() {
    }
}

