/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.io;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.logging.Logger;
import org.qi4j.functional.Function;
import org.qi4j.functional.Specification;
import org.qi4j.io.Input;
import org.qi4j.io.Output;
import org.qi4j.io.Receiver;
import org.qi4j.io.Sender;

public class Transforms {
    public static <T, Receiver2ThrowableType extends Throwable> Output<T, Receiver2ThrowableType> filter(final Specification<? super T> specification, final Output<T, Receiver2ThrowableType> output) {
        return new Output<T, Receiver2ThrowableType>(){

            @Override
            public <SenderThrowableType extends Throwable> void receiveFrom(final Sender<? extends T, SenderThrowableType> sender) throws Throwable, Throwable {
                output.receiveFrom(new Sender<T, SenderThrowableType>(){

                    @Override
                    public <ReceiverThrowableType extends Throwable> void sendTo(final Receiver<? super T, ReceiverThrowableType> receiver) throws Throwable, Throwable {
                        sender.sendTo(new Receiver<T, ReceiverThrowableType>(){

                            @Override
                            public void receive(T item) throws Throwable {
                                if (specification.satisfiedBy(item)) {
                                    receiver.receive(item);
                                }
                            }
                        });
                    }
                });
            }
        };
    }

    public static <From, To, Receiver2ThrowableType extends Throwable> Output<From, Receiver2ThrowableType> map(final Function<? super From, ? extends To> function, final Output<To, Receiver2ThrowableType> output) {
        return new Output<From, Receiver2ThrowableType>(){

            @Override
            public <SenderThrowableType extends Throwable> void receiveFrom(final Sender<? extends From, SenderThrowableType> sender) throws Throwable, Throwable {
                output.receiveFrom(new Sender<To, SenderThrowableType>(){

                    @Override
                    public <ReceiverThrowableType extends Throwable> void sendTo(final Receiver<? super To, ReceiverThrowableType> receiver) throws Throwable, Throwable {
                        sender.sendTo(new Receiver<From, ReceiverThrowableType>(){

                            @Override
                            public void receive(From item) throws Throwable {
                                receiver.receive(function.map(item));
                            }
                        });
                    }
                });
            }
        };
    }

    public static <T, Receiver2ThrowableType extends Throwable> Output<T, Receiver2ThrowableType> filteredMap(final Specification<? super T> specification, final Function<? super T, ? extends T> function, final Output<T, Receiver2ThrowableType> output) {
        return new Output<T, Receiver2ThrowableType>(){

            @Override
            public <SenderThrowableType extends Throwable> void receiveFrom(final Sender<? extends T, SenderThrowableType> sender) throws Throwable, Throwable {
                output.receiveFrom(new Sender<T, SenderThrowableType>(){

                    @Override
                    public <ReceiverThrowableType extends Throwable> void sendTo(final Receiver<? super T, ReceiverThrowableType> receiver) throws Throwable, Throwable {
                        sender.sendTo(new Receiver<T, ReceiverThrowableType>(){

                            @Override
                            public void receive(T item) throws Throwable {
                                if (specification.satisfiedBy(item)) {
                                    receiver.receive(function.map(item));
                                } else {
                                    receiver.receive(item);
                                }
                            }
                        });
                    }
                });
            }
        };
    }

    public static <T, Receiver2ThrowableType extends Throwable> Output<T, Receiver2ThrowableType> lock(final Lock lock, final Output<T, Receiver2ThrowableType> output) {
        return new Output<T, Receiver2ThrowableType>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <SenderThrowableType extends Throwable> void receiveFrom(Sender<? extends T, SenderThrowableType> sender) throws Throwable, Throwable {
                while (true) {
                    try {
                        while (!lock.tryLock(1000L, TimeUnit.MILLISECONDS)) {
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                try {
                    output.receiveFrom(sender);
                }
                finally {
                    lock.unlock();
                }
            }
        };
    }

    public static <T, SenderThrowableType extends Throwable> Input<T, SenderThrowableType> lock(final Lock lock, final Input<T, SenderThrowableType> input) {
        return new Input<T, SenderThrowableType>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super T, ReceiverThrowableType> output) throws Throwable, Throwable {
                while (true) {
                    try {
                        while (!lock.tryLock() && !lock.tryLock(1000L, TimeUnit.MILLISECONDS)) {
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                try {
                    input.transferTo(output);
                }
                finally {
                    lock.unlock();
                }
            }
        };
    }

    public static class ProgressLog<T>
    implements Function<T, T> {
        private Counter<T> counter;
        private Log<String> log;
        private final long interval;

        public ProgressLog(Logger logger, String format, long interval) {
            this.interval = interval;
            if (logger != null && format != null) {
                this.log = new Log(logger, format);
            }
            this.counter = new Counter();
        }

        public ProgressLog(long interval) {
            this.interval = interval;
            this.counter = new Counter();
        }

        public T map(T t) {
            this.counter.map(t);
            if (((Counter)this.counter).count % this.interval == 0L) {
                this.logProgress();
            }
            return t;
        }

        protected void logProgress() {
            if (this.log != null) {
                this.log.map(((Counter)this.counter).count + "");
            }
        }
    }

    public static class Log<T>
    implements Function<T, T> {
        private Logger logger;
        private MessageFormat format;

        public Log(Logger logger, String format) {
            this.logger = logger;
            this.format = new MessageFormat(format);
        }

        public T map(T item) {
            this.logger.info(this.format.format(new String[]{item.toString()}));
            return item;
        }
    }

    public static class ObjectToString
    implements Function<Object, String> {
        public String map(Object o) {
            return o.toString();
        }
    }

    public static class ByteBuffer2String
    implements Function<ByteBuffer, String> {
        private Charset charSet;

        public ByteBuffer2String(Charset charSet) {
            this.charSet = charSet;
        }

        public String map(ByteBuffer buffer) {
            return new String(buffer.array(), this.charSet);
        }
    }

    public static class String2Bytes
    implements Function<String, byte[]> {
        private Charset charSet;

        public String2Bytes(Charset charSet) {
            this.charSet = charSet;
        }

        public byte[] map(String s) {
            return s.getBytes(this.charSet);
        }
    }

    public static class Counter<T>
    implements Function<T, T> {
        private volatile long count = 0L;

        public long count() {
            return this.count;
        }

        public T map(T t) {
            ++this.count;
            return t;
        }
    }
}

