/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.rdf.indexing;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.openrdf.model.Resource;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.Rio;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.spi.query.IndexExporter;

@Mixins(value={RdfExporterMixin.class})
public interface RdfExporter
extends IndexExporter {

    public static class RdfExporterMixin
    implements IndexExporter {
        @Service
        private Repository repository;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exportReadableToStream(PrintStream out) throws IOException {
            RDFWriter rdfWriter = Rio.createWriter((RDFFormat)RDFFormat.TRIG, (OutputStream)out);
            try (RepositoryConnection connection = this.repository.getConnection();){
                connection.export((RDFHandler)rdfWriter, new Resource[0]);
            }
            catch (RepositoryException e) {
                throw new IOException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exportFormalToWriter(PrintWriter out) throws IOException {
            RDFWriter rdfWriter = Rio.createWriter((RDFFormat)RDFFormat.RDFXML, (Writer)out);
            try (RepositoryConnection connection = this.repository.getConnection();){
                connection.export((RDFHandler)rdfWriter, new Resource[0]);
            }
            catch (RepositoryException e) {
                throw new IOException(e);
            }
        }
    }
}

