/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.rdf.query;

import java.util.Map;
import org.openrdf.query.QueryLanguage;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.query.grammar.OrderBy;
import org.qi4j.api.query.grammar.QuerySpecification;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.functional.Specification;
import org.qi4j.index.rdf.query.CollectingQualifiedIdentityResultCallback;
import org.qi4j.index.rdf.query.RdfQueryParser;
import org.qi4j.index.rdf.query.RdfQueryParserFactory;
import org.qi4j.index.rdf.query.SingleQualifiedIdentityResultCallback;
import org.qi4j.index.rdf.query.TupleQueryExecutor;
import org.qi4j.spi.query.EntityFinder;
import org.qi4j.spi.query.EntityFinderException;

@Mixins(value={RdfEntityFinderMixin.class})
public interface RdfQueryService
extends EntityFinder,
RdfQueryParserFactory,
ServiceComposite {

    public static class RdfEntityFinderMixin
    implements EntityFinder {
        private static final QueryLanguage language = QueryLanguage.SPARQL;
        @Service
        private RdfQueryParserFactory queryParserFactory;
        @This
        TupleQueryExecutor tupleExecutor;

        public Iterable<EntityReference> findEntities(Class<?> resultType, Specification<Composite> whereClause, OrderBy[] orderBySegments, Integer firstResult, Integer maxResults, Map<String, Object> variables) throws EntityFinderException {
            CollectingQualifiedIdentityResultCallback collectingCallback = new CollectingQualifiedIdentityResultCallback();
            if (QuerySpecification.isQueryLanguage((String)"SERQL", whereClause)) {
                String query = ((QuerySpecification)whereClause).query();
                this.tupleExecutor.performTupleQuery(QueryLanguage.SERQL, query, variables, collectingCallback);
                return collectingCallback.entities();
            }
            RdfQueryParser rdfQueryParser = this.queryParserFactory.newQueryParser(language);
            String query = rdfQueryParser.constructQuery(resultType, whereClause, orderBySegments, firstResult, maxResults, variables);
            this.tupleExecutor.performTupleQuery(language, query, variables, collectingCallback);
            return collectingCallback.entities();
        }

        public EntityReference findEntity(Class<?> resultType, Specification<Composite> whereClause, Map<String, Object> variables) throws EntityFinderException {
            SingleQualifiedIdentityResultCallback singleCallback = new SingleQualifiedIdentityResultCallback();
            if (QuerySpecification.isQueryLanguage((String)"SERQL", whereClause)) {
                String query = ((QuerySpecification)whereClause).query();
                this.tupleExecutor.performTupleQuery(QueryLanguage.SERQL, query, variables, singleCallback);
                return singleCallback.qualifiedIdentity();
            }
            RdfQueryParser rdfQueryParser = this.queryParserFactory.newQueryParser(language);
            String query = rdfQueryParser.constructQuery(resultType, whereClause, null, null, null, variables);
            this.tupleExecutor.performTupleQuery(QueryLanguage.SPARQL, query, variables, singleCallback);
            return singleCallback.qualifiedIdentity();
        }

        public long countEntities(Class<?> resultType, Specification<Composite> whereClause, Map<String, Object> variables) throws EntityFinderException {
            if (QuerySpecification.isQueryLanguage((String)"SERQL", whereClause)) {
                String query = ((QuerySpecification)whereClause).query();
                return this.tupleExecutor.performTupleQuery(QueryLanguage.SERQL, query, variables, null);
            }
            RdfQueryParser rdfQueryParser = this.queryParserFactory.newQueryParser(language);
            String query = rdfQueryParser.constructQuery(resultType, whereClause, null, null, null, variables);
            return this.tupleExecutor.performTupleQuery(language, query, variables, null);
        }
    }
}

