/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.rdf.query.internal;

import java.util.HashMap;
import java.util.Map;

public class Namespaces {
    private int namespaceCounter = 0;
    private final Map<String, String> namespaces = new HashMap<String, String>();

    public Namespaces() {
        this.addDefaultNamespaces();
    }

    private void addDefaultNamespaces() {
        this.addNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.addNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
    }

    public Iterable<? extends String> namespaces() {
        return this.namespaces.keySet();
    }

    public String addNamespace(String namespace) {
        String prefix = this.namespacePrefix(namespace);
        if (prefix != null) {
            return prefix;
        }
        prefix = "ns" + this.namespaceCounter++;
        return this.addNamespace(prefix, namespace);
    }

    public String namespacePrefix(String namespace) {
        return this.namespaces.get(namespace);
    }

    public String addNamespace(String prefix, String namespace) {
        this.namespaces.put(namespace, prefix);
        return prefix;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String string : this.namespaces()) {
            sb.append(String.format("%s:%s%n", this.namespacePrefix(string), string));
        }
        return sb.toString();
    }
}

