/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.rdf.query.internal;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang.StringEscapeUtils;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.entity.EntityComposite;
import org.qi4j.api.query.grammar.AndSpecification;
import org.qi4j.api.query.grammar.AssociationNotNullSpecification;
import org.qi4j.api.query.grammar.AssociationNullSpecification;
import org.qi4j.api.query.grammar.ComparisonSpecification;
import org.qi4j.api.query.grammar.ContainsAllSpecification;
import org.qi4j.api.query.grammar.ContainsSpecification;
import org.qi4j.api.query.grammar.EqSpecification;
import org.qi4j.api.query.grammar.GeSpecification;
import org.qi4j.api.query.grammar.GtSpecification;
import org.qi4j.api.query.grammar.LeSpecification;
import org.qi4j.api.query.grammar.LtSpecification;
import org.qi4j.api.query.grammar.ManyAssociationContainsSpecification;
import org.qi4j.api.query.grammar.MatchesSpecification;
import org.qi4j.api.query.grammar.NeSpecification;
import org.qi4j.api.query.grammar.NotSpecification;
import org.qi4j.api.query.grammar.OrSpecification;
import org.qi4j.api.query.grammar.OrderBy;
import org.qi4j.api.query.grammar.PropertyNotNullSpecification;
import org.qi4j.api.query.grammar.PropertyNullSpecification;
import org.qi4j.api.query.grammar.QuerySpecification;
import org.qi4j.api.query.grammar.Variable;
import org.qi4j.api.value.ValueSerializer;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.index.rdf.query.RdfQueryParser;
import org.qi4j.index.rdf.query.internal.Namespaces;
import org.qi4j.index.rdf.query.internal.Triples;
import org.qi4j.spi.Qi4jSPI;
import org.slf4j.LoggerFactory;

public class RdfQueryParserImpl
implements RdfQueryParser {
    private static final ThreadLocal<DateFormat> ISO8601_UTC = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dateFormat;
        }
    };
    private static final Map<Class<? extends ComparisonSpecification>, String> OPERATORS = new HashMap<Class<? extends ComparisonSpecification>, String>(6);
    private static final Set<Character> RESERVED_CHARS;
    private final Namespaces namespaces = new Namespaces();
    private final Triples triples = new Triples(this.namespaces);
    private final Qi4jSPI spi;
    private final ValueSerializer valueSerializer;
    private Map<String, Object> variables;

    public RdfQueryParserImpl(Qi4jSPI spi, ValueSerializer valueSerializer) {
        this.spi = spi;
        this.valueSerializer = valueSerializer;
    }

    @Override
    public String constructQuery(Class<?> resultType, Specification<Composite> specification, OrderBy[] orderBySegments, Integer firstResult, Integer maxResults, Map<String, Object> variables) {
        this.variables = variables;
        if (QuerySpecification.isQueryLanguage((String)"SPARQL", specification)) {
            StringBuilder queryBuilder = new StringBuilder();
            String query = ((QuerySpecification)specification).query();
            queryBuilder.append(query);
            if (orderBySegments != null) {
                queryBuilder.append("\nORDER BY ");
                this.processOrderBy(orderBySegments, queryBuilder);
            }
            if (firstResult != null) {
                queryBuilder.append("\nOFFSET ").append(firstResult);
            }
            if (maxResults != null) {
                queryBuilder.append("\nLIMIT ").append(maxResults);
            }
            return queryBuilder.toString();
        }
        this.triples.addDefaultTriples(resultType.getName());
        StringBuilder filter = new StringBuilder();
        this.processFilter(specification, true, filter);
        StringBuilder orderBy = new StringBuilder();
        this.processOrderBy(orderBySegments, orderBy);
        StringBuilder query = new StringBuilder();
        for (String string : this.namespaces.namespaces()) {
            query.append(String.format("PREFIX %s: <%s> %n", this.namespaces.namespacePrefix(string), string));
        }
        query.append("SELECT DISTINCT ?identity\n");
        if (this.triples.hasTriples()) {
            query.append("WHERE {\n");
            StringBuilder optional = new StringBuilder();
            for (Triples.Triple triple : this.triples) {
                String subject = triple.subject();
                String predicate = triple.predicate();
                String value = triple.value();
                if (triple.isOptional()) {
                    optional.append(String.format("OPTIONAL {%s %s %s}. ", subject, predicate, value));
                    optional.append('\n');
                    continue;
                }
                query.append(String.format("%s %s %s. ", subject, predicate, value));
                query.append('\n');
            }
            if (optional.length() > 0) {
                query.append(optional.toString());
            }
            if (filter.length() > 0) {
                query.append("FILTER ").append((CharSequence)filter);
            }
            query.append("\n}");
        }
        if (orderBy.length() > 0) {
            query.append("\nORDER BY ").append((CharSequence)orderBy);
        }
        if (firstResult != null) {
            query.append("\nOFFSET ").append(firstResult);
        }
        if (maxResults != null) {
            query.append("\nLIMIT ").append(maxResults);
        }
        LoggerFactory.getLogger(this.getClass()).debug("Query:\n" + query);
        return query.toString();
    }

    private void processFilter(Specification<Composite> expression, boolean allowInline, StringBuilder builder) {
        if (expression == null) {
            return;
        }
        if (expression instanceof AndSpecification) {
            AndSpecification conjunction = (AndSpecification)expression;
            int start = builder.length();
            boolean first = true;
            for (Specification operand : conjunction.operands()) {
                int size = builder.length();
                this.processFilter((Specification<Composite>)operand, allowInline, builder);
                if (builder.length() <= size) continue;
                if (first) {
                    first = false;
                    continue;
                }
                builder.insert(size, " && ");
            }
            if (builder.length() > start) {
                builder.insert(start, '(');
                builder.append(')');
            }
        } else if (expression instanceof OrSpecification) {
            OrSpecification disjunction = (OrSpecification)expression;
            int start = builder.length();
            boolean first = true;
            for (Specification operand : disjunction.operands()) {
                int size = builder.length();
                this.processFilter((Specification<Composite>)operand, false, builder);
                if (builder.length() <= size) continue;
                if (first) {
                    first = false;
                    continue;
                }
                builder.insert(size, "||");
            }
            if (builder.length() > start) {
                builder.insert(start, '(');
                builder.append(')');
            }
        } else if (expression instanceof NotSpecification) {
            builder.insert(0, "(!");
            this.processFilter((Specification<Composite>)((NotSpecification)expression).operand(), false, builder);
            builder.append(")");
        } else if (expression instanceof ComparisonSpecification) {
            this.processComparisonPredicate(expression, allowInline, builder);
        } else if (expression instanceof ContainsAllSpecification) {
            this.processContainsAllPredicate((ContainsAllSpecification)expression, builder);
        } else if (expression instanceof ContainsSpecification) {
            this.processContainsPredicate((ContainsSpecification)expression, builder);
        } else if (expression instanceof MatchesSpecification) {
            this.processMatchesPredicate((MatchesSpecification)expression, builder);
        } else if (expression instanceof PropertyNotNullSpecification) {
            this.processNotNullPredicate((PropertyNotNullSpecification)expression, builder);
        } else if (expression instanceof PropertyNullSpecification) {
            this.processNullPredicate((PropertyNullSpecification)expression, builder);
        } else if (expression instanceof AssociationNotNullSpecification) {
            this.processNotNullPredicate((AssociationNotNullSpecification)expression, builder);
        } else if (expression instanceof AssociationNullSpecification) {
            this.processNullPredicate((AssociationNullSpecification)expression, builder);
        } else if (expression instanceof ManyAssociationContainsSpecification) {
            this.processManyAssociationContainsPredicate((ManyAssociationContainsSpecification)expression, allowInline, builder);
        } else {
            throw new UnsupportedOperationException("Expression " + expression + " is not supported");
        }
    }

    private static void join(String[] strings, String delimiter, StringBuilder builder) {
        Integer x = 0;
        while (x < strings.length) {
            builder.append(strings[x]);
            if (x + 1 < strings.length) {
                builder.append(delimiter);
            }
            x = x + 1;
        }
    }

    private String createAndEscapeJSONString(Object value) {
        return this.escapeJSONString(this.valueSerializer.serialize(new ValueSerializer.Options().withoutTypeInfo(), value));
    }

    private String createRegexStringForContaining(String valueVariable, String containedString) {
        return String.format("regex(str(%s), \"^\\\\u005B.*%s.*\\\\u005D$\", \"s\")", valueVariable, containedString);
    }

    private String escapeJSONString(String jsonStr) {
        StringBuilder builder = new StringBuilder();
        char[] chars = jsonStr.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (RESERVED_CHARS.contains(Character.valueOf(c))) {
                builder.append("\\\\u").append(String.format("%04X", c));
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private void processContainsAllPredicate(ContainsAllSpecification<?> predicate, StringBuilder builder) {
        Iterable values = predicate.containedValues();
        String valueVariable = this.triples.addTriple(predicate.collectionProperty(), false).value();
        String[] strings = values instanceof Collection ? new String[((Collection)values).size()] : new String[(int)Iterables.count((Iterable)values)];
        Integer x = 0;
        for (Object item : (Collection)values) {
            String jsonStr = "";
            if (item != null) {
                String serialized = this.valueSerializer.serialize(item, false);
                if (item instanceof String) {
                    serialized = "\"" + StringEscapeUtils.escapeJava((String)serialized) + "\"";
                }
                jsonStr = this.escapeJSONString(serialized);
            }
            strings[x.intValue()] = this.createRegexStringForContaining(valueVariable, jsonStr);
            Integer n = x;
            Integer n2 = x = Integer.valueOf(x + 1);
        }
        if (strings.length > 0) {
            builder.append("(");
            RdfQueryParserImpl.join(strings, " && ", builder);
            builder.append(")");
        } else {
            builder.append(this.createRegexStringForContaining(valueVariable, ""));
        }
    }

    private void processContainsPredicate(ContainsSpecification<?> predicate, StringBuilder builder) {
        Object value = predicate.value();
        String valueVariable = this.triples.addTriple(predicate.collectionProperty(), false).value();
        builder.append(this.createRegexStringForContaining(valueVariable, this.createAndEscapeJSONString(value)));
    }

    private void processMatchesPredicate(MatchesSpecification predicate, StringBuilder builder) {
        String valueVariable = this.triples.addTriple(predicate.property(), false).value();
        builder.append(String.format("regex(%s,\"%s\")", valueVariable, predicate.regexp()));
    }

    private void processComparisonPredicate(Specification<Composite> predicate, boolean allowInline, StringBuilder builder) {
        if (predicate instanceof ComparisonSpecification) {
            ComparisonSpecification comparisonSpecification = (ComparisonSpecification)predicate;
            Triples.Triple triple = this.triples.addTriple(comparisonSpecification.property(), false);
            if (predicate instanceof EqSpecification && allowInline) {
                triple.setValue("\"" + this.toString(comparisonSpecification.value()) + "\"");
            } else {
                String valueVariable = triple.value();
                builder.append(String.format("(%s %s \"%s\")", valueVariable, this.getOperator(comparisonSpecification.getClass()), this.toString(comparisonSpecification.value())));
            }
        } else {
            throw new UnsupportedOperationException("Operator " + predicate.getClass().getName() + " is not supported");
        }
    }

    private void processNullPredicate(PropertyNullSpecification<?> predicate, StringBuilder builder) {
        String value = this.triples.addTriple(predicate.property(), true).value();
        builder.append(String.format("(! bound(%s))", value));
    }

    private void processNotNullPredicate(PropertyNotNullSpecification<?> predicate, StringBuilder builder) {
        String value = this.triples.addTriple(predicate.property(), true).value();
        builder.append(String.format("(bound(%s))", value));
    }

    private void processNullPredicate(AssociationNullSpecification<?> predicate, StringBuilder builder) {
        String value = this.triples.addTripleAssociation(predicate.association(), true).value();
        builder.append(String.format("(! bound(%s))", value));
    }

    private void processNotNullPredicate(AssociationNotNullSpecification<?> predicate, StringBuilder builder) {
        String value = this.triples.addTripleAssociation(predicate.association(), true).value();
        builder.append(String.format("(bound(%s))", value));
    }

    private void processManyAssociationContainsPredicate(ManyAssociationContainsSpecification<?> predicate, boolean allowInline, StringBuilder builder) {
        Triples.Triple triple = this.triples.addTripleManyAssociation(predicate.manyAssociation(), false);
        if (allowInline) {
            triple.setValue("<" + this.toString(predicate.value()) + ">");
        } else {
            String valueVariable = triple.value();
            builder.append(String.format("(%s %s <%s>)", valueVariable, "=", this.toString(predicate.value())));
        }
    }

    private void processOrderBy(OrderBy[] orderBySegments, StringBuilder builder) {
        if (orderBySegments != null && orderBySegments.length > 0) {
            for (OrderBy orderBySegment : orderBySegments) {
                this.processOrderBy(builder, orderBySegment);
            }
        }
    }

    private void processOrderBy(StringBuilder builder, OrderBy orderBySegment) {
        if (orderBySegment != null) {
            String valueVariable = this.triples.addTriple(orderBySegment.property(), false).value();
            if (orderBySegment.order() == OrderBy.Order.ASCENDING) {
                builder.append(String.format("ASC(%s)", valueVariable));
            } else {
                builder.append(String.format("DESC(%s)", valueVariable));
            }
        }
    }

    private String getOperator(Class<? extends ComparisonSpecification> predicateClass) {
        String operator = OPERATORS.get(predicateClass);
        if (operator == null) {
            throw new UnsupportedOperationException("Predicate [" + predicateClass.getName() + "] is not supported");
        }
        return operator;
    }

    private String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return ISO8601_UTC.get().format((Date)value);
        }
        if (value instanceof EntityComposite) {
            return "urn:qi4j:entity:" + value.toString();
        }
        if (value instanceof Variable) {
            Object realValue = this.variables.get(((Variable)value).variableName());
            if (realValue == null) {
                throw new IllegalArgumentException("Variable " + ((Variable)value).variableName() + " not bound");
            }
            return this.toString(realValue);
        }
        return value.toString();
    }

    static {
        OPERATORS.put(EqSpecification.class, "=");
        OPERATORS.put(GeSpecification.class, ">=");
        OPERATORS.put(GtSpecification.class, ">");
        OPERATORS.put(LeSpecification.class, "<=");
        OPERATORS.put(LtSpecification.class, "<");
        OPERATORS.put(NeSpecification.class, "!=");
        RESERVED_CHARS = new HashSet<Character>(Arrays.asList(Character.valueOf('\"'), Character.valueOf('^'), Character.valueOf('.'), Character.valueOf('\\'), Character.valueOf('?'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('|'), Character.valueOf('$'), Character.valueOf('['), Character.valueOf(']')));
    }
}

