/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.invocationcache;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.qi4j.api.common.AppliesTo;
import org.qi4j.api.common.Optional;
import org.qi4j.api.concern.ConcernOf;
import org.qi4j.api.injection.scope.This;
import org.qi4j.library.invocationcache.Cached;
import org.qi4j.library.invocationcache.InvocationCache;

@AppliesTo(value={Cached.class})
public class ReturnCachedValueConcern
extends ConcernOf<InvocationHandler>
implements InvocationHandler {
    @This
    @Optional
    private InvocationCache cache;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean voidReturnType = method.getReturnType().equals(Void.TYPE);
        if (this.cache != null || voidReturnType) {
            Object result;
            String cacheName = method.getName();
            if (args != null) {
                cacheName = cacheName + Arrays.asList(args);
            }
            if ((result = this.cache.cachedValue(cacheName)) != null) {
                return result;
            }
        }
        return ((InvocationHandler)this.next).invoke(proxy, method, args);
    }
}

