/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.uid.uuid;

import java.util.UUID;
import org.qi4j.library.uid.uuid.UuidService;

public class UuidGenerationMixin
implements UuidService {
    private String uuid = UUID.randomUUID().toString() + "-";
    private int count;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generateUuid(int hashLength) {
        UuidGenerationMixin uuidGenerationMixin = this;
        synchronized (uuidGenerationMixin) {
            String uid = this.uuid + Integer.toHexString(this.count++);
            if (hashLength > 0) {
                byte[] result = new byte[hashLength];
                byte[] bytes = uid.getBytes();
                for (int i = 0; i < bytes.length; ++i) {
                    int pos = i % hashLength;
                    result[pos] = (byte)(result[pos] * 31 + 19 + bytes[i]);
                }
                StringBuffer buf = new StringBuffer();
                for (int n : result) {
                    String hex;
                    if (n < 0) {
                        n = 256 + n;
                    }
                    if ((hex = Integer.toHexString(n)).length() == 1) {
                        hex = "0" + hex;
                    }
                    buf = buf.append(hex);
                }
                uid = buf.toString();
            }
            return uid.toUpperCase();
        }
    }
}

