/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.sql.assembly;

import java.io.IOException;
import org.qi4j.api.common.Visibility;
import org.qi4j.bootstrap.Assemblers;
import org.qi4j.bootstrap.AssemblyException;
import org.qi4j.bootstrap.ModuleAssembly;
import org.qi4j.index.reindexer.ReindexerConfiguration;
import org.qi4j.index.reindexer.ReindexerService;
import org.qi4j.index.sql.support.common.ReindexingStrategy;
import org.qi4j.library.sql.common.SQLConfiguration;
import org.sql.generation.api.vendor.SQLVendor;
import org.sql.generation.api.vendor.SQLVendorProvider;

public abstract class AbstractSQLIndexQueryAssembler<AssemblerType>
extends Assemblers.VisibilityIdentityConfig<AssemblerType> {
    public static final String DEFAULT_IDENTITY = "indexing-sql";
    private Class<? extends ReindexingStrategy> reindexingStrategy = ReindexingStrategy.NeverNeed.class;

    public AbstractSQLIndexQueryAssembler() {
        this.identifiedBy(DEFAULT_IDENTITY);
    }

    public AssemblerType withReindexingStrategy(Class<? extends ReindexingStrategy> reindexingStrategy) {
        this.reindexingStrategy = reindexingStrategy;
        return (AssemblerType)((Object)this);
    }

    protected SQLVendor getSQLVendor() throws IOException {
        return SQLVendorProvider.createVendor(SQLVendor.class);
    }

    protected abstract Class<?> getIndexQueryServiceType();

    public final void assemble(ModuleAssembly module) throws AssemblyException {
        try {
            SQLVendor sqlVendor = this.getSQLVendor();
            if (sqlVendor == null) {
                throw new AssemblyException("SQL Vendor could not be determined.");
            }
            module.services(new Class[]{this.getIndexQueryServiceType()}).identifiedBy(this.identity()).setMetaInfo((Object)sqlVendor).visibleIn(this.visibility()).instantiateOnStartup();
        }
        catch (IOException ex) {
            throw new AssemblyException("SQL Vendor could not be created", (Throwable)ex);
        }
        module.services(new Class[]{ReindexerService.class}).visibleIn(Visibility.module);
        module.services(new Class[]{ReindexingStrategy.class}).withMixins(new Class[]{this.reindexingStrategy}).visibleIn(Visibility.module);
        if (this.hasConfig()) {
            this.configModule().entities(new Class[]{SQLConfiguration.class, ReindexerConfiguration.class}).visibleIn(this.configVisibility());
        }
    }
}

