/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.sql.internal;

import java.sql.SQLException;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.unitofwork.UnitOfWorkException;
import org.qi4j.index.sql.support.api.SQLIndexing;
import org.qi4j.spi.entity.EntityState;
import org.qi4j.spi.entitystore.StateChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLStateChangeListener
implements StateChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLStateChangeListener.class);
    @Service
    private SQLIndexing _indexing;

    public void notifyChanges(Iterable<EntityState> changedStates) {
        try {
            this._indexing.indexEntities(changedStates);
        }
        catch (SQLException sqle) {
            SQLException lastException = sqle;
            while (sqle.getNextException() != null) {
                sqle = sqle.getNextException();
            }
            LOGGER.error("Error when indexing entities", (Throwable)sqle);
            throw new UnitOfWorkException((Throwable)lastException);
        }
    }
}

