/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.sql.support.common;

public interface RebuildingStrategy {
    public boolean rebuildingRequired(String var1, String var2);

    public static class NeedOnChange
    implements RebuildingStrategy {
        @Override
        public boolean rebuildingRequired(String dbAppVersion, String currentAppVersion) {
            return !dbAppVersion.equals(currentAppVersion);
        }
    }

    public static class NeverNeed
    implements RebuildingStrategy {
        @Override
        public boolean rebuildingRequired(String dbAppVersion, String currentAppVersion) {
            return false;
        }
    }

    public static class AlwaysNeed
    implements RebuildingStrategy {
        @Override
        public boolean rebuildingRequired(String dbAppVersion, String currentAppVersion) {
            return true;
        }
    }
}

