/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.sql.support.postgresql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.service.ServiceDescriptor;
import org.qi4j.index.sql.support.skeletons.AbstractSQLStartup;
import org.qi4j.library.sql.common.SQLUtil;
import org.sql.generation.api.grammar.common.SQLStatement;
import org.sql.generation.api.grammar.common.datatypes.SQLDataType;
import org.sql.generation.api.grammar.definition.table.TableContentsSource;
import org.sql.generation.api.grammar.definition.table.TableElement;
import org.sql.generation.api.grammar.definition.table.TableScope;
import org.sql.generation.api.grammar.definition.table.pgsql.PgSQLTableCommitAction;
import org.sql.generation.api.grammar.factories.DefinitionFactory;
import org.sql.generation.api.grammar.factories.TableReferenceFactory;
import org.sql.generation.api.grammar.factories.pgsql.PgSQLDataTypeFactory;
import org.sql.generation.api.vendor.PostgreSQLVendor;

public class PostgreSQLAppStartup
extends AbstractSQLStartup {
    private final PostgreSQLVendor _vendor;

    public PostgreSQLAppStartup(@Uses ServiceDescriptor descriptor) {
        super(descriptor);
        this._vendor = (PostgreSQLVendor)descriptor.metaInfo(PostgreSQLVendor.class);
    }

    @Override
    protected void modifyPrimitiveTypes(Map<Class<?>, SQLDataType> primitiveTypes, Map<Class<?>, Integer> jdbcTypes) {
        primitiveTypes.put(String.class, (SQLDataType)this._vendor.getDataTypeFactory().text());
    }

    @Override
    protected void testRequiredCapabilities(Connection connection) throws SQLException {
        Statement stmt = connection.createStatement();
        try {
            DefinitionFactory d = this._vendor.getDefinitionFactory();
            TableReferenceFactory t = this._vendor.getTableReferenceFactory();
            PgSQLDataTypeFactory dt = this._vendor.getDataTypeFactory();
            stmt.execute(this._vendor.toString((SQLStatement)d.createTableDefinitionBuilder().setTableScope(TableScope.LOCAL_TEMPORARY).setTableName(t.tableName("ltree_test")).setCommitAction(PgSQLTableCommitAction.DROP).setTableContentsSource((TableContentsSource)d.createTableElementListBuilder().addTableElement((TableElement)d.createColumnDefinition("test_column", (SQLDataType)dt.userDefined("ltree"))).createExpression()).createExpression()));
        }
        catch (SQLException sqle) {
            throw new InternalError("It seems that your database doesn't have ltree as type. It is needed to store collections. Please refer to hopefully supplied instructions on how to add ltree type (hint: run <pg_install_dir>/share/contrib/ltree.sql script or command 'CREATE EXTENSION ltree;').");
        }
        finally {
            SQLUtil.closeQuietly((Statement)stmt);
        }
    }

    @Override
    protected SQLDataType getCollectionPathDataType() {
        return this._vendor.getDataTypeFactory().userDefined("ltree");
    }
}

