/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.sql.support.postgresql;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.qi4j.api.common.Optional;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.index.sql.support.skeletons.SQLDBState;

@Mixins(value={SQLTypeHelperMixin.class})
public interface PostgreSQLTypeHelper {
    public void addPrimitiveToPS(PreparedStatement var1, Integer var2, @Optional Object var3, Type var4) throws SQLException;

    public Integer getSQLType(Object var1);

    public static class SQLTypeHelperMixin
    implements PostgreSQLTypeHelper {
        @This
        private SQLDBState _state;

        public Object processJavaPrimitiveBeforeUsingInStatement(Object primitive) {
            if (primitive != null) {
                if (primitive instanceof Character) {
                    primitive = Character.codePointAt(new char[]{((Character)primitive).charValue()}, 0);
                } else if (primitive instanceof Date) {
                    primitive = new Timestamp(((Date)primitive).getTime());
                } else if (primitive instanceof Byte) {
                    primitive = (short)((Byte)primitive).byteValue();
                } else if (primitive instanceof Short) {
                    primitive = (int)((Short)primitive).shortValue();
                }
            }
            return primitive;
        }

        @Override
        public void addPrimitiveToPS(PreparedStatement ps, Integer index, Object primitive, Type primitiveType) throws SQLException {
            primitive = this.processJavaPrimitiveBeforeUsingInStatement(primitive);
            Integer sqlType = this.getSQLType(primitiveType);
            ps.setObject((int)index, primitive, sqlType);
        }

        @Override
        public Integer getSQLType(Object primitive) {
            primitive = this.processJavaPrimitiveBeforeUsingInStatement(primitive);
            return this.getSQLType(primitive.getClass());
        }

        private Integer getSQLType(Type primitiveType) {
            Integer sqlType;
            Class<Enum> primitiveClass;
            if (primitiveType instanceof ParameterizedType) {
                primitiveType = ((ParameterizedType)primitiveType).getRawType();
            }
            if (Enum.class.isAssignableFrom(primitiveClass = (Class<Enum>)((Object)primitiveType))) {
                primitiveClass = Enum.class;
            }
            if ((sqlType = (Integer)((Map)this._state.javaTypes2SQLTypes().get()).get(primitiveClass)) == null) {
                throw new InternalError("Could not find mapping from " + primitiveClass + " to SQL type.");
            }
            return sqlType;
        }
    }
}

