/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.sql.support.skeletons;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.common.Optional;
import org.qi4j.api.common.QualifiedName;
import org.qi4j.api.composite.CompositeDescriptor;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.property.PropertyDescriptor;
import org.qi4j.api.service.ServiceDescriptor;
import org.qi4j.api.structure.Application;
import org.qi4j.api.structure.ApplicationDescriptor;
import org.qi4j.api.structure.LayerDescriptor;
import org.qi4j.api.structure.ModuleDescriptor;
import org.qi4j.api.value.ValueDescriptor;
import org.qi4j.functional.Function;
import org.qi4j.functional.HierarchicalVisitor;
import org.qi4j.functional.HierarchicalVisitorAdapter;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.index.reindexer.Reindexer;
import org.qi4j.index.sql.support.api.SQLAppStartup;
import org.qi4j.index.sql.support.api.SQLTypeInfo;
import org.qi4j.index.sql.support.common.QNameInfo;
import org.qi4j.index.sql.support.common.RebuildingStrategy;
import org.qi4j.index.sql.support.common.ReindexingStrategy;
import org.qi4j.index.sql.support.skeletons.SQLDBState;
import org.qi4j.index.sql.support.skeletons.SQLSkeletonUtil;
import org.qi4j.library.sql.common.SQLConfiguration;
import org.qi4j.library.sql.common.SQLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sql.generation.api.grammar.builders.definition.TableElementListBuilder;
import org.sql.generation.api.grammar.common.SQLStatement;
import org.sql.generation.api.grammar.common.TableName;
import org.sql.generation.api.grammar.common.ValueExpression;
import org.sql.generation.api.grammar.common.datatypes.SQLDataType;
import org.sql.generation.api.grammar.definition.table.AutoGenerationPolicy;
import org.sql.generation.api.grammar.definition.table.ConstraintCharacteristics;
import org.sql.generation.api.grammar.definition.table.ReferentialAction;
import org.sql.generation.api.grammar.definition.table.TableConstraint;
import org.sql.generation.api.grammar.definition.table.TableContentsSource;
import org.sql.generation.api.grammar.definition.table.TableDefinition;
import org.sql.generation.api.grammar.definition.table.TableElement;
import org.sql.generation.api.grammar.definition.table.UniqueSpecification;
import org.sql.generation.api.grammar.factories.DataTypeFactory;
import org.sql.generation.api.grammar.factories.DefinitionFactory;
import org.sql.generation.api.grammar.factories.LiteralFactory;
import org.sql.generation.api.grammar.factories.ModificationFactory;
import org.sql.generation.api.grammar.factories.QueryFactory;
import org.sql.generation.api.grammar.factories.TableReferenceFactory;
import org.sql.generation.api.grammar.manipulation.DropBehaviour;
import org.sql.generation.api.grammar.manipulation.ObjectType;
import org.sql.generation.api.grammar.modification.ColumnSource;
import org.sql.generation.api.grammar.modification.DeleteBySearch;
import org.sql.generation.api.grammar.modification.InsertStatement;
import org.sql.generation.api.grammar.query.QueryExpression;
import org.sql.generation.api.vendor.SQLVendor;

public abstract class AbstractSQLStartup
implements SQLAppStartup {
    public static final String DEFAULT_SCHEMA_NAME = "qi4j";
    private static final Class<?> ENTITY_PK_TYPE = Long.class;
    private static final Class<?> ENTITY_TYPE_PK_TYPE = Integer.class;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AbstractSQLStartup.class.getName());
    static final ThreadLocal<Connection> CONNECTION_FOR_REINDEXING = new ThreadLocal<Connection>(){

        @Override
        protected Connection initialValue() {
            return null;
        }
    };
    @This
    private SQLDBState _state;
    @This
    private Configuration<SQLConfiguration> _configuration;
    @Service
    @Optional
    private ReindexingStrategy _reindexingStrategy;
    @Service
    @Optional
    private RebuildingStrategy _rebuildingStrategy;
    @Service
    private DataSource _dataSource;
    @Service
    private Reindexer _reindexer;
    @Structure
    private Application _app;
    private final SQLVendor _vendor;
    private Map<Class<?>, SQLTypeCustomizer> _customizableTypes;
    private Map<Class<?>, SQLDataType> _primitiveTypes;
    private static final String DESCRIPTOR_COMPONENT_SEPARATOR_START = "{";
    private static final String DESCRIPTOR_COMPONENT_SEPARATOR_END = "}";
    private static final String DESCRIPTOR_TYPE_SEPARATOR = ",";
    private static final Pattern DESCRIPTOR_TYPES_REGEXP = Pattern.compile("[^" + Pattern.quote(",") + "]+");
    private static final Pattern DESCRIPTOR_TEXTUAL_REGEXP = Pattern.compile("^" + Pattern.quote("{") + "(.*)" + Pattern.quote("}") + Pattern.quote("{") + "(.*)" + Pattern.quote("}") + Pattern.quote("{") + "(" + "[^" + Pattern.quote("},") + "]+)" + Pattern.quote("}") + "$");

    public AbstractSQLStartup(@Uses ServiceDescriptor descriptor) {
        this._vendor = (SQLVendor)descriptor.metaInfo(SQLVendor.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initConnection() throws SQLException {
        this._configuration.refresh();
        this.initTypes();
        this.modifyPrimitiveTypes(this._primitiveTypes, (Map)this._state.javaTypes2SQLTypes().get());
        String schemaName = (String)((SQLConfiguration)this._configuration.get()).schemaName().get();
        if (schemaName == null) {
            schemaName = DEFAULT_SCHEMA_NAME;
        } else {
            this.checkSchemaName(schemaName);
        }
        LOGGER.debug("Will use '{}' as schema name", (Object)schemaName);
        this._state.schemaName().set((Object)schemaName);
        this._state.entityTypePKs().set(new HashMap());
        this._state.usedClassesPKs().set(new HashMap());
        this._state.entityUsedQNames().set(new HashMap());
        this._state.qNameInfos().set(new HashMap());
        this._state.enumPKs().set(new HashMap());
        Connection connection = this._dataSource.getConnection();
        try {
            connection.setAutoCommit(true);
            connection.setReadOnly(false);
            this.syncDB(connection);
        }
        finally {
            SQLUtil.closeQuietly((Connection)connection);
        }
        if (LOGGER.isDebugEnabled()) {
            String newline = "\n";
            String tab = "\t";
            String colonspace = ": ";
            StringBuilder report = new StringBuilder();
            report.append("schemaName: ").append((String)this._state.schemaName().get()).append(newline);
            report.append("qNameInfos: ").append(newline);
            for (Map.Entry entry : ((Map)this._state.qNameInfos().get()).entrySet()) {
                report.append(tab).append(entry.getKey()).append(colonspace).append(entry.getValue()).append(newline);
            }
            report.append("entityUsedQNames:").append(newline);
            for (Map.Entry entry : ((Map)this._state.entityUsedQNames().get()).entrySet()) {
                report.append(tab).append(entry.getKey()).append(colonspace).append(entry.getValue()).append(newline);
            }
            report.append("usedClassesPKs:").append(newline);
            for (Map.Entry entry : ((Map)this._state.usedClassesPKs().get()).entrySet()) {
                report.append(tab).append(entry.getKey()).append(colonspace).append(entry.getValue()).append(newline);
            }
            report.append("javaTypes2SQLTypes:").append(newline);
            for (Map.Entry entry : ((Map)this._state.javaTypes2SQLTypes().get()).entrySet()) {
                report.append(tab).append(entry.getKey()).append(colonspace).append(entry.getValue()).append(newline);
            }
            report.append("entityTypePKs:").append(newline);
            for (Map.Entry entry : ((Map)this._state.entityTypePKs().get()).entrySet()) {
                report.append(tab).append((String)entry.getKey()).append(colonspace).append(entry.getValue()).append(newline);
            }
            report.append("enumPKs:").append(newline);
            for (Map.Entry entry : ((Map)this._state.enumPKs().get()).entrySet()) {
                report.append(tab).append((String)entry.getKey()).append(colonspace).append(entry.getValue()).append(newline);
            }
            LOGGER.debug("SQLDBState after initConnection:\n{}", (Object)report.toString());
        }
    }

    private void initTypes() {
        DataTypeFactory dt = this._vendor.getDataTypeFactory();
        this._primitiveTypes = new HashMap();
        this._primitiveTypes.put(Boolean.class, (SQLDataType)dt.sqlBoolean());
        this._primitiveTypes.put(Byte.class, (SQLDataType)dt.smallInt());
        this._primitiveTypes.put(Short.class, (SQLDataType)dt.smallInt());
        this._primitiveTypes.put(Integer.class, (SQLDataType)dt.integer());
        this._primitiveTypes.put(Long.class, (SQLDataType)dt.bigInt());
        this._primitiveTypes.put(Float.class, (SQLDataType)dt.real());
        this._primitiveTypes.put(Double.class, (SQLDataType)dt.doublePrecision());
        this._primitiveTypes.put(Date.class, (SQLDataType)dt.timeStamp(Boolean.valueOf(true)));
        this._primitiveTypes.put(Character.class, (SQLDataType)dt.integer());
        this._primitiveTypes.put(String.class, (SQLDataType)dt.sqlVarChar(Integer.valueOf(5000)));
        this._primitiveTypes.put(BigInteger.class, (SQLDataType)dt.decimal());
        this._primitiveTypes.put(BigDecimal.class, (SQLDataType)dt.decimal());
        HashMap<Class, Integer> jdbcTypes = new HashMap<Class, Integer>();
        jdbcTypes.put(Boolean.class, 16);
        jdbcTypes.put(Byte.class, 5);
        jdbcTypes.put(Short.class, 5);
        jdbcTypes.put(Integer.class, 4);
        jdbcTypes.put(Long.class, -5);
        jdbcTypes.put(Float.class, 7);
        jdbcTypes.put(Double.class, 8);
        jdbcTypes.put(Date.class, 93);
        jdbcTypes.put(Character.class, 4);
        jdbcTypes.put(String.class, 12);
        jdbcTypes.put(BigInteger.class, 2);
        jdbcTypes.put(BigDecimal.class, 2);
        this._state.javaTypes2SQLTypes().set(jdbcTypes);
        this._customizableTypes = new HashMap();
        this._customizableTypes.put(String.class, new SQLTypeCustomizer(){

            @Override
            public SQLDataType customizeType(Type propertyType, SQLTypeInfo sqlTypeInfo) {
                return AbstractSQLStartup.this._vendor.getDataTypeFactory().sqlVarChar(Integer.valueOf(sqlTypeInfo.maxLength()));
            }
        });
        this._customizableTypes.put(BigInteger.class, new SQLTypeCustomizer(){

            @Override
            public SQLDataType customizeType(Type propertyType, SQLTypeInfo sqlTypeInfo) {
                return AbstractSQLStartup.this._vendor.getDataTypeFactory().decimal(Integer.valueOf(sqlTypeInfo.maxLength()));
            }
        });
        this._customizableTypes.put(BigDecimal.class, new SQLTypeCustomizer(){

            @Override
            public SQLDataType customizeType(Type propertyType, SQLTypeInfo sqlTypeInfo) {
                return AbstractSQLStartup.this._vendor.getDataTypeFactory().decimal(Integer.valueOf(sqlTypeInfo.maxLength()));
            }
        });
    }

    protected void checkSchemaName(String schemaName) {
        if (!Pattern.matches("^\\p{L}(\\_|\\p{L}|\\p{N})*$", schemaName)) {
            throw new IllegalStateException("Illegal schema name: " + schemaName + ".");
        }
    }

    private void syncDB(Connection connection) throws SQLException {
        boolean reindexingNeeded;
        boolean rebuildingNeeded;
        String schemaName = (String)this._state.schemaName().get();
        String appVersion = this._app.version();
        String dbAppVersion = this.readAppVersionFromDB(connection, schemaName);
        boolean bl = rebuildingNeeded = dbAppVersion == null;
        if (!rebuildingNeeded && this._rebuildingStrategy != null) {
            rebuildingNeeded = this._rebuildingStrategy.rebuildingRequired(dbAppVersion, appVersion);
        }
        ApplicationInfo appInfo = this.constructApplicationInfo(!rebuildingNeeded);
        if (rebuildingNeeded) {
            LOGGER.debug("(Re)building schema " + schemaName);
            this.destroyNeededSchemaTables(connection, schemaName, ((Map)this._state.qNameInfos().get()).size());
            HashMap<String, Long> tablePKs = new HashMap<String, Long>();
            this.createSchemaAndRequiredTables(connection, schemaName, tablePKs);
            this.writeAppMetadataToDB(connection, appInfo, tablePKs);
        } else {
            this.testRequiredCapabilities(connection);
            this.readAppMetadataFromDB(connection, appInfo.entityDescriptors);
            LOGGER.debug("Application metadata loaded from database");
        }
        boolean bl2 = reindexingNeeded = dbAppVersion == null;
        if (!reindexingNeeded && this._reindexingStrategy != null) {
            reindexingNeeded = this._reindexingStrategy.reindexingNeeded(dbAppVersion, appVersion);
        }
        if (reindexingNeeded) {
            LOGGER.debug("(Re)indexing entitystore, using schema " + schemaName);
            this.performReindex(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSchemaAndRequiredTables(Connection connection, String schemaName, Map<String, Long> tablePKs) throws SQLException {
        boolean schemaFound = false;
        ResultSet rs = connection.getMetaData().getSchemas();
        try {
            while (rs.next() && !schemaFound) {
                schemaFound = rs.getString(1).equals(schemaName);
            }
        }
        finally {
            SQLUtil.closeQuietly((ResultSet)rs);
        }
        SQLVendor vendor = this._vendor;
        DefinitionFactory d = vendor.getDefinitionFactory();
        TableReferenceFactory t = vendor.getTableReferenceFactory();
        Statement stmt = connection.createStatement();
        try {
            if (!schemaFound) {
                stmt.execute(vendor.toString((SQLStatement)d.createSchemaDefinitionBuilder().setSchemaName(schemaName).createExpression()));
                LOGGER.debug("Database schema created");
            }
            this.testRequiredCapabilities(connection);
            LOGGER.debug("Underlying database fullfill required capabilities");
            stmt.execute(vendor.toString((SQLStatement)d.createTableDefinitionBuilder().setTableName(t.tableName(schemaName, "used_classes")).setTableContentsSource((TableContentsSource)d.createTableElementListBuilder().addTableElement((TableElement)d.createColumnDefinition("used_class_id", this._primitiveTypes.get(Integer.class), Boolean.valueOf(false))).addTableElement((TableElement)d.createColumnDefinition("class_name", this._primitiveTypes.get(String.class), Boolean.valueOf(false))).addTableElement((TableElement)d.createTableConstraintDefinition((TableConstraint)d.createUniqueConstraintBuilder().setUniqueness(UniqueSpecification.PRIMARY_KEY).addColumns(new String[]{"used_class_id"}).createExpression())).addTableElement((TableElement)d.createTableConstraintDefinition((TableConstraint)d.createUniqueConstraintBuilder().setUniqueness(UniqueSpecification.UNIQUE).addColumns(new String[]{"class_name"}).createExpression())).createExpression()).createExpression()));
            tablePKs.put("used_classes", 0L);
            stmt.execute(vendor.toString((SQLStatement)d.createTableDefinitionBuilder().setTableName(t.tableName(schemaName, "entity_types")).setTableContentsSource((TableContentsSource)d.createTableElementListBuilder().addTableElement((TableElement)d.createColumnDefinition("entity_type_id", this._primitiveTypes.get(ENTITY_TYPE_PK_TYPE), Boolean.valueOf(false))).addTableElement((TableElement)d.createColumnDefinition("entity_type_name", this._primitiveTypes.get(String.class), Boolean.valueOf(false))).addTableElement((TableElement)d.createTableConstraintDefinition((TableConstraint)d.createUniqueConstraintBuilder().setUniqueness(UniqueSpecification.PRIMARY_KEY).addColumns(new String[]{"entity_type_id"}).createExpression())).addTableElement((TableElement)d.createTableConstraintDefinition((TableConstraint)d.createUniqueConstraintBuilder().setUniqueness(UniqueSpecification.UNIQUE).addColumns(new String[]{"entity_type_name"}).createExpression())).createExpression()).createExpression()));
            tablePKs.put("entity_types", 0L);
            stmt.execute(vendor.toString((SQLStatement)d.createTableDefinitionBuilder().setTableName(t.tableName(schemaName, "indexing_entities")).setTableContentsSource((TableContentsSource)d.createTableElementListBuilder().addTableElement((TableElement)d.createColumnDefinition("entity_pk", this._primitiveTypes.get(ENTITY_PK_TYPE), Boolean.valueOf(false), AutoGenerationPolicy.BY_DEFAULT)).addTableElement((TableElement)d.createColumnDefinition("entity_identity", this._primitiveTypes.get(String.class), Boolean.valueOf(false))).addTableElement((TableElement)d.createColumnDefinition("modified", this._primitiveTypes.get(Date.class), Boolean.valueOf(false))).addTableElement((TableElement)d.createColumnDefinition("entity_version", this._primitiveTypes.get(String.class), Boolean.valueOf(false))).addTableElement((TableElement)d.createColumnDefinition("application_version", this._primitiveTypes.get(String.class), Boolean.valueOf(false))).addTableElement((TableElement)d.createTableConstraintDefinition((TableConstraint)d.createUniqueConstraintBuilder().setUniqueness(UniqueSpecification.PRIMARY_KEY).addColumns(new String[]{"entity_pk"}).createExpression())).addTableElement((TableElement)d.createTableConstraintDefinition((TableConstraint)d.createUniqueConstraintBuilder().setUniqueness(UniqueSpecification.UNIQUE).addColumns(new String[]{"entity_identity"}).createExpression())).createExpression()).createExpression()));
            tablePKs.put("indexing_entities", 0L);
            stmt.execute(((TableDefinition)d.createTableDefinitionBuilder().setTableName(t.tableName(schemaName, "indexing_entities_entity_types")).setTableContentsSource((TableContentsSource)d.createTableElementListBuilder().addTableElement((TableElement)d.createColumnDefinition("entity_pk", this._primitiveTypes.get(ENTITY_PK_TYPE), Boolean.valueOf(false))).addTableElement((TableElement)d.createColumnDefinition("entity_type_id", this._primitiveTypes.get(ENTITY_TYPE_PK_TYPE), Boolean.valueOf(false))).addTableElement((TableElement)d.createTableConstraintDefinition((TableConstraint)d.createUniqueConstraintBuilder().setUniqueness(UniqueSpecification.PRIMARY_KEY).addColumns(new String[]{"entity_pk", "entity_type_id"}).createExpression())).addTableElement((TableElement)d.createTableConstraintDefinition((TableConstraint)d.createForeignKeyConstraintBuilder().addSourceColumns(new String[]{"entity_pk"}).setTargetTableName(t.tableName(schemaName, "indexing_entities")).addTargetColumns(new String[]{"entity_pk"}).setOnDelete(ReferentialAction.CASCADE).setOnUpdate(ReferentialAction.CASCADE).createExpression(), ConstraintCharacteristics.INITIALLY_DEFERRED_DEFERRABLE)).addTableElement((TableElement)d.createTableConstraintDefinition((TableConstraint)d.createForeignKeyConstraintBuilder().addSourceColumns(new String[]{"entity_type_id"}).setTargetTableName(t.tableName(schemaName, "entity_types")).addTargetColumns(new String[]{"entity_type_id"}).setOnDelete(ReferentialAction.RESTRICT).setOnDelete(ReferentialAction.CASCADE).createExpression(), ConstraintCharacteristics.NOT_DEFERRABLE)).createExpression()).createExpression()).toString());
            stmt.execute(vendor.toString((SQLStatement)d.createTableDefinitionBuilder().setTableName(t.tableName(schemaName, "enum_lookup")).setTableContentsSource((TableContentsSource)d.createTableElementListBuilder().addTableElement((TableElement)d.createColumnDefinition("enum_id", this._primitiveTypes.get(Integer.class), Boolean.valueOf(false))).addTableElement((TableElement)d.createColumnDefinition("enum_value", this._primitiveTypes.get(String.class), Boolean.valueOf(false))).addTableElement((TableElement)d.createTableConstraintDefinition((TableConstraint)d.createUniqueConstraintBuilder().setUniqueness(UniqueSpecification.PRIMARY_KEY).addColumns(new String[]{"enum_id"}).createExpression())).createExpression()).createExpression()));
            tablePKs.put("enum_lookup", 0L);
            stmt.execute(vendor.toString((SQLStatement)d.createTableDefinitionBuilder().setTableName(t.tableName(schemaName, "used_qnames")).setTableContentsSource((TableContentsSource)d.createTableElementListBuilder().addTableElement((TableElement)d.createColumnDefinition("qname", this._primitiveTypes.get(String.class), Boolean.valueOf(false))).addTableElement((TableElement)d.createColumnDefinition("table_name", this._primitiveTypes.get(String.class), Boolean.valueOf(false))).addTableElement((TableElement)d.createTableConstraintDefinition((TableConstraint)d.createUniqueConstraintBuilder().setUniqueness(UniqueSpecification.PRIMARY_KEY).addColumns(new String[]{"qname", "table_name"}).createExpression())).createExpression()).createExpression()));
            stmt.execute(vendor.toString((SQLStatement)d.createTableDefinitionBuilder().setTableName(t.tableName(schemaName, "all_qnames")).setTableContentsSource((TableContentsSource)d.createTableElementListBuilder().addTableElement((TableElement)d.createColumnDefinition("qname_id", this._primitiveTypes.get(Integer.class), Boolean.valueOf(false))).addTableElement((TableElement)d.createColumnDefinition("entity_pk", this._primitiveTypes.get(ENTITY_PK_TYPE), Boolean.valueOf(false))).addTableElement((TableElement)d.createTableConstraintDefinition((TableConstraint)d.createUniqueConstraintBuilder().setUniqueness(UniqueSpecification.PRIMARY_KEY).addColumns(new String[]{"qname_id", "entity_pk"}).createExpression())).addTableElement((TableElement)d.createTableConstraintDefinition((TableConstraint)d.createForeignKeyConstraintBuilder().addSourceColumns(new String[]{"entity_pk"}).setTargetTableName(t.tableName(schemaName, "indexing_entities")).addTargetColumns(new String[]{"entity_pk"}).setOnUpdate(ReferentialAction.CASCADE).setOnDelete(ReferentialAction.CASCADE).createExpression(), ConstraintCharacteristics.INITIALLY_DEFERRED_DEFERRABLE)).createExpression()).createExpression()));
            tablePKs.put("all_qnames", 0L);
            stmt.execute(vendor.toString((SQLStatement)d.createTableDefinitionBuilder().setTableName(t.tableName(schemaName, "app_version")).setTableContentsSource((TableContentsSource)d.createTableElementListBuilder().addTableElement((TableElement)d.createColumnDefinition("app_version", this._primitiveTypes.get(String.class), Boolean.valueOf(false))).addTableElement((TableElement)d.createTableConstraintDefinition((TableConstraint)d.createUniqueConstraintBuilder().setUniqueness(UniqueSpecification.PRIMARY_KEY).addColumns(new String[]{"app_version"}).createExpression())).createExpression()).createExpression()));
            ModificationFactory m = vendor.getModificationFactory();
            PreparedStatement ps = connection.prepareStatement(vendor.toString((SQLStatement)m.insert().setTableName(t.tableName(schemaName, "app_version")).setColumnSource((ColumnSource)m.columnSourceByValues().addValues(new ValueExpression[]{vendor.getLiteralFactory().param()}).createExpression()).createExpression()));
            ps.setString(1, this._app.version());
            ps.execute();
        }
        finally {
            SQLUtil.closeQuietly((Statement)stmt);
        }
        LOGGER.debug("Indexing SQL database tables created");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performReindex(Connection connection) throws SQLException {
        LOGGER.info("Performing reindexing...");
        DeleteBySearch clearEntityData = (DeleteBySearch)this._vendor.getModificationFactory().deleteBySearch().setTargetTable(this._vendor.getModificationFactory().createTargetTable(this._vendor.getTableReferenceFactory().tableName((String)this._state.schemaName().get(), "indexing_entities"))).createExpression();
        connection.prepareStatement(this._vendor.toString((SQLStatement)clearEntityData)).execute();
        CONNECTION_FOR_REINDEXING.set(connection);
        try {
            this._reindexer.reindex();
        }
        finally {
            CONNECTION_FOR_REINDEXING.set(null);
        }
        LOGGER.info("Reindexing complete.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAppMetadataFromDB(Connection connection, Map<String, EntityDescriptor> entityDescriptors) throws SQLException {
        String schemaName = (String)this._state.schemaName().get();
        Statement stmt = connection.createStatement();
        SQLVendor vendor = this._vendor;
        QueryFactory q = vendor.getQueryFactory();
        TableReferenceFactory t = vendor.getTableReferenceFactory();
        try {
            long pk;
            q.simpleQueryBuilder().select(new String[]{"entity_type_id", "entity_type_name"}).from(new TableName[]{t.tableName(schemaName, "entity_types")}).createExpression();
            ResultSet rs = stmt.executeQuery(vendor.toString((SQLStatement)q.simpleQueryBuilder().select(new String[]{"entity_type_id", "entity_type_name"}).from(new TableName[]{t.tableName(schemaName, "entity_types")}).createExpression()));
            try {
                while (rs.next()) {
                    pk = rs.getInt(1);
                    String entityTypeName = rs.getString(2);
                    ((Map)this._state.entityTypePKs().get()).put(entityTypeName, (int)pk);
                }
            }
            finally {
                SQLUtil.closeQuietly((ResultSet)rs);
            }
            rs = stmt.executeQuery(vendor.toString((SQLStatement)q.simpleQueryBuilder().select(new String[]{"used_class_id", "class_name"}).from(new TableName[]{t.tableName(schemaName, "used_classes")}).createExpression()));
            try {
                while (rs.next()) {
                    pk = rs.getInt(1);
                    String descriptorTextualFormat = rs.getString(2);
                    ((Map)this._state.usedClassesPKs().get()).put(AbstractSQLStartup.stringToCompositeDescriptor(ValueDescriptor.class, this._app.descriptor(), descriptorTextualFormat), (int)pk);
                }
            }
            finally {
                SQLUtil.closeQuietly((ResultSet)rs);
            }
            rs = stmt.executeQuery(vendor.toString((SQLStatement)q.simpleQueryBuilder().select(new String[]{"enum_id", "enum_value"}).from(new TableName[]{t.tableName(schemaName, "enum_lookup")}).createExpression()));
            try {
                while (rs.next()) {
                    pk = rs.getInt(1);
                    String enumName = rs.getString(2);
                    ((Map)this._state.enumPKs().get()).put(enumName, (int)pk);
                }
            }
            finally {
                SQLUtil.closeQuietly((ResultSet)rs);
            }
            rs = stmt.executeQuery(((QueryExpression)q.simpleQueryBuilder().select(new String[]{"qname", "table_name"}).from(new TableName[]{t.tableName(schemaName, "used_qnames")}).createExpression()).toString());
            try {
                while (rs.next()) {
                    String qName = rs.getString(1);
                    String tableName = rs.getString(2);
                    ((QNameInfo)((Map)this._state.qNameInfos().get()).get(QualifiedName.fromFQN((String)qName))).setTableName(tableName);
                }
            }
            finally {
                SQLUtil.closeQuietly((ResultSet)rs);
            }
        }
        finally {
            SQLUtil.closeQuietly((Statement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAppMetadataToDB(Connection connection, ApplicationInfo appInfo, Map<String, Long> tablePKs) throws SQLException {
        String schemaName = (String)this._state.schemaName().get();
        SQLVendor vendor = this._vendor;
        ModificationFactory m = vendor.getModificationFactory();
        TableReferenceFactory t = vendor.getTableReferenceFactory();
        LiteralFactory l = vendor.getLiteralFactory();
        PreparedStatement ps = connection.prepareStatement(vendor.toString((SQLStatement)m.insert().setTableName(t.tableName(schemaName, "entity_types")).setColumnSource((ColumnSource)m.columnSourceByValues().addValues(new ValueExpression[]{l.param(), l.param()}).createExpression()).createExpression()));
        try {
            HashSet insertedTypeNames = new HashSet();
            for (EntityDescriptor descriptor : appInfo.entityDescriptors.values()) {
                for (Class entityType : descriptor.types()) {
                    String entityTypeName = entityType.getName();
                    if (insertedTypeNames.contains(entityTypeName)) continue;
                    long pk = tablePKs.get("entity_types");
                    ps.setInt(1, (int)pk);
                    ps.setString(2, entityTypeName);
                    ps.executeUpdate();
                    ((Map)this._state.entityTypePKs().get()).put(entityTypeName, (int)pk);
                    tablePKs.put("entity_types", pk + 1L);
                }
            }
        }
        finally {
            SQLUtil.closeQuietly((Statement)ps);
        }
        ps = connection.prepareStatement(vendor.toString((SQLStatement)m.insert().setTableName(t.tableName(schemaName, "used_classes")).setColumnSource((ColumnSource)m.columnSourceByValues().addValues(new ValueExpression[]{l.param(), l.param()}).createExpression()).createExpression()));
        try {
            for (CompositeDescriptorInfo descInfo : appInfo.usedValueComposites) {
                String vDescStr = AbstractSQLStartup.compositeDescriptorToString(descInfo.layer, descInfo.module, descInfo.composite);
                long pk = tablePKs.get("used_classes");
                ps.setInt(1, (int)pk);
                ps.setString(2, vDescStr);
                ps.executeUpdate();
                ((Map)this._state.usedClassesPKs().get()).put(descInfo.composite, (int)pk);
                tablePKs.put("used_classes", pk + 1L);
            }
        }
        finally {
            SQLUtil.closeQuietly((Statement)ps);
        }
        ps = connection.prepareStatement(vendor.toString((SQLStatement)m.insert().setTableName(t.tableName(schemaName, "enum_lookup")).setColumnSource((ColumnSource)m.columnSourceByValues().addValues(new ValueExpression[]{l.param(), l.param()}).createExpression()).createExpression()));
        try {
            for (String enumValue : appInfo.enumValues) {
                long pk = tablePKs.get("enum_lookup");
                ps.setInt(1, (int)pk);
                ps.setString(2, enumValue);
                ps.executeUpdate();
                ((Map)this._state.enumPKs().get()).put(enumValue, (int)pk);
                tablePKs.put("enum_lookup", pk + 1L);
            }
        }
        finally {
            SQLUtil.closeQuietly((Statement)ps);
        }
        Statement stmt = connection.createStatement();
        ps = connection.prepareStatement(this.createInsertStatementForQNameInfo(connection, schemaName, vendor).toString());
        try {
            DefinitionFactory d = vendor.getDefinitionFactory();
            for (QNameInfo qNameInfo : ((Map)this._state.qNameInfos().get()).values()) {
                QNameInfo.QNameType type = qNameInfo.getQNameType();
                TableElementListBuilder builder = d.createTableElementListBuilder();
                builder.addTableElement((TableElement)d.createColumnDefinition("qname_id", this._primitiveTypes.get(Integer.class), Boolean.valueOf(false))).addTableElement((TableElement)d.createColumnDefinition("entity_pk", this._primitiveTypes.get(ENTITY_PK_TYPE), Boolean.valueOf(false)));
                if (type.equals((Object)QNameInfo.QNameType.PROPERTY)) {
                    builder.addTableElement((TableElement)d.createColumnDefinition("parent_qname", this._primitiveTypes.get(Integer.class), Boolean.valueOf(true)));
                    if (qNameInfo.getCollectionDepth() > 0) {
                        builder.addTableElement((TableElement)d.createColumnDefinition("collection_path", this.getCollectionPathDataType(), Boolean.valueOf(false)));
                    }
                    this.appendColumnDefinitionsForProperty(builder, qNameInfo);
                    builder.addTableElement((TableElement)d.createTableConstraintDefinition((TableConstraint)d.createForeignKeyConstraintBuilder().addSourceColumns(new String[]{"parent_qname", "entity_pk"}).setTargetTableName(t.tableName(schemaName, "all_qnames")).addTargetColumns(new String[]{"qname_id", "entity_pk"}).setOnUpdate(ReferentialAction.CASCADE).setOnDelete(ReferentialAction.CASCADE).createExpression(), ConstraintCharacteristics.INITIALLY_DEFERRED_DEFERRABLE));
                } else {
                    if (type.equals((Object)QNameInfo.QNameType.ASSOCIATION)) {
                        builder.addTableElement((TableElement)d.createColumnDefinition("qname_value", this._primitiveTypes.get(ENTITY_PK_TYPE), Boolean.valueOf(false))).addTableElement((TableElement)d.createTableConstraintDefinition((TableConstraint)d.createUniqueConstraintBuilder().setUniqueness(UniqueSpecification.PRIMARY_KEY).addColumns(new String[]{"qname_id", "entity_pk"}).createExpression()));
                    } else if (type.equals((Object)QNameInfo.QNameType.MANY_ASSOCIATION)) {
                        builder.addTableElement((TableElement)d.createColumnDefinition("asso_index", this._primitiveTypes.get(Integer.class), Boolean.valueOf(false))).addTableElement((TableElement)d.createColumnDefinition("qname_value", this._primitiveTypes.get(ENTITY_PK_TYPE), Boolean.valueOf(false))).addTableElement((TableElement)d.createTableConstraintDefinition((TableConstraint)d.createUniqueConstraintBuilder().setUniqueness(UniqueSpecification.PRIMARY_KEY).addColumns(new String[]{"qname_id", "entity_pk"}).createExpression()));
                    } else {
                        throw new IllegalArgumentException("Did not how to create table for qName type: " + (Object)((Object)type) + ".");
                    }
                    builder.addTableElement((TableElement)d.createTableConstraintDefinition((TableConstraint)d.createForeignKeyConstraintBuilder().addSourceColumns(new String[]{"qname_value"}).setTargetTableName(t.tableName(schemaName, "indexing_entities")).addTargetColumns(new String[]{"entity_pk"}).setOnUpdate(ReferentialAction.CASCADE).setOnDelete(ReferentialAction.CASCADE).createExpression(), ConstraintCharacteristics.INITIALLY_DEFERRED_DEFERRABLE));
                    tablePKs.put(qNameInfo.getTableName(), 0L);
                }
                builder.addTableElement((TableElement)d.createTableConstraintDefinition((TableConstraint)d.createForeignKeyConstraintBuilder().addSourceColumns(new String[]{"qname_id", "entity_pk"}).setTargetTableName(t.tableName(schemaName, "all_qnames")).addTargetColumns(new String[]{"qname_id", "entity_pk"}).setOnUpdate(ReferentialAction.CASCADE).setOnDelete(ReferentialAction.CASCADE).createExpression(), ConstraintCharacteristics.INITIALLY_DEFERRED_DEFERRABLE));
                stmt.execute(this._vendor.toString((SQLStatement)d.createTableDefinitionBuilder().setTableName(t.tableName(schemaName, qNameInfo.getTableName())).setTableContentsSource((TableContentsSource)builder.createExpression()).createExpression()));
                ps.setString(1, qNameInfo.getQName().toString());
                ps.setString(2, qNameInfo.getTableName());
                ps.execute();
            }
        }
        finally {
            SQLUtil.closeQuietly((Statement)stmt);
            SQLUtil.closeQuietly((Statement)ps);
        }
    }

    private InsertStatement createInsertStatementForQNameInfo(Connection connection, String schemaName, SQLVendor vendor) {
        ModificationFactory m = vendor.getModificationFactory();
        TableReferenceFactory t = vendor.getTableReferenceFactory();
        LiteralFactory l = vendor.getLiteralFactory();
        return (InsertStatement)m.insert().setTableName(t.tableName(schemaName, "used_qnames")).setColumnSource((ColumnSource)m.columnSourceByValues().addValues(new ValueExpression[]{l.param(), l.param()}).createExpression()).createExpression();
    }

    private void appendColumnDefinitionsForProperty(TableElementListBuilder builder, QNameInfo qNameInfo) {
        Type finalType = qNameInfo.getFinalType();
        if (finalType instanceof ParameterizedType) {
            finalType = ((ParameterizedType)finalType).getRawType();
        }
        Class finalClass = (Class)finalType;
        SQLDataType sqlType = null;
        String valueRefTableName = null;
        String valueRefTablePKColumnName = null;
        if (qNameInfo.isFinalTypePrimitive().booleanValue()) {
            if (this._customizableTypes.keySet().contains(finalClass) && qNameInfo.getPropertyDescriptor().accessor().isAnnotationPresent(SQLTypeInfo.class)) {
                sqlType = this._customizableTypes.get(finalClass).customizeType(finalClass, qNameInfo.getPropertyDescriptor().accessor().getAnnotation(SQLTypeInfo.class));
            } else if (Enum.class.isAssignableFrom(finalClass)) {
                sqlType = this._primitiveTypes.get(Integer.class);
                valueRefTableName = "enum_lookup";
                valueRefTablePKColumnName = "enum_id";
            } else {
                sqlType = this._primitiveTypes.get(finalClass);
            }
            if (sqlType == null) {
                throw new InternalError("Could not find sql type for java type [" + finalType + "]");
            }
        } else {
            sqlType = this._primitiveTypes.get(Integer.class);
            valueRefTableName = "used_classes";
            valueRefTablePKColumnName = "used_class_id";
        }
        SQLVendor vendor = this._vendor;
        DefinitionFactory d = vendor.getDefinitionFactory();
        TableReferenceFactory t = vendor.getTableReferenceFactory();
        builder.addTableElement((TableElement)d.createColumnDefinition("qname_value", sqlType, Boolean.valueOf(qNameInfo.getCollectionDepth() > 0))).addTableElement((TableElement)d.createTableConstraintDefinition((TableConstraint)d.createUniqueConstraintBuilder().setUniqueness(UniqueSpecification.PRIMARY_KEY).addColumns(new String[]{"qname_id", "entity_pk"}).createExpression()));
        if (valueRefTableName != null && valueRefTablePKColumnName != null) {
            builder.addTableElement((TableElement)d.createTableConstraintDefinition((TableConstraint)d.createForeignKeyConstraintBuilder().addSourceColumns(new String[]{"qname_value"}).setTargetTableName(t.tableName((String)this._state.schemaName().get(), valueRefTableName)).addTargetColumns(new String[]{valueRefTablePKColumnName}).setOnUpdate(ReferentialAction.CASCADE).setOnDelete(ReferentialAction.RESTRICT).createExpression(), ConstraintCharacteristics.NOT_DEFERRABLE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long getNextPK(Statement stmt, String schemaName, String columnName, String tableName, Long defaultPK) throws SQLException {
        ResultSet rs = null;
        Long result = defaultPK;
        try {
            Long count;
            SQLVendor vendor = this._vendor;
            QueryFactory q = vendor.getQueryFactory();
            rs = stmt.executeQuery(vendor.toString((SQLStatement)q.simpleQueryBuilder().select(new String[]{"COUNT(" + columnName + ")", "MAX(" + columnName + ") + 1"}).from(new TableName[]{vendor.getTableReferenceFactory().tableName(schemaName, tableName)}).createExpression()));
            if (rs.next() && (count = Long.valueOf(rs.getLong(1))) > 0L) {
                result = rs.getLong(2);
            }
        }
        catch (Throwable throwable) {
            SQLUtil.closeQuietly(rs);
            throw throwable;
        }
        SQLUtil.closeQuietly((ResultSet)rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean isReindexingNeeded(Connection connection) throws SQLException {
        Boolean result = true;
        String schemaName = (String)this._state.schemaName().get();
        Statement stmt = connection.createStatement();
        try {
            QueryExpression getAppVersionQuery = (QueryExpression)this._vendor.getQueryFactory().simpleQueryBuilder().select(new String[]{"app_version"}).from(new TableName[]{this._vendor.getTableReferenceFactory().tableName(schemaName, "app_version")}).createExpression();
            ResultSet rs = null;
            try {
                rs = stmt.executeQuery(this._vendor.toString((SQLStatement)getAppVersionQuery));
            }
            catch (SQLException sqle) {
                // empty catch block
            }
            if (rs != null && !(result = Boolean.valueOf(!rs.next())).booleanValue()) {
                String dbAppVersion = rs.getString(1);
                if (this._reindexingStrategy != null) {
                    result = this._reindexingStrategy.reindexingNeeded(dbAppVersion, this._app.version());
                }
            }
        }
        finally {
            SQLUtil.closeQuietly((Statement)stmt);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String readAppVersionFromDB(Connection connection, String schemaName) throws SQLException {
        String result;
        block8: {
            Statement stmt = connection.createStatement();
            result = null;
            try {
                ResultSet rs;
                block7: {
                    QueryExpression getAppVersionQuery = (QueryExpression)this._vendor.getQueryFactory().simpleQueryBuilder().select(new String[]{"app_version"}).from(new TableName[]{this._vendor.getTableReferenceFactory().tableName(schemaName, "app_version")}).createExpression();
                    rs = null;
                    try {
                        rs = stmt.executeQuery(getAppVersionQuery.toString());
                        if (!rs.next()) break block7;
                        result = rs.getString(1);
                    }
                    catch (SQLException sqle) {
                        SQLUtil.closeQuietly((ResultSet)rs);
                        break block8;
                        catch (Throwable throwable) {
                            SQLUtil.closeQuietly(rs);
                            throw throwable;
                        }
                    }
                }
                SQLUtil.closeQuietly((ResultSet)rs);
            }
            finally {
                SQLUtil.closeQuietly((Statement)stmt);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearSchema(Connection connection, String schemaName, SQLVendor vendor) throws SQLException {
        ModificationFactory m = vendor.getModificationFactory();
        Statement stmt = null;
        try {
            connection.setReadOnly(false);
            stmt = connection.createStatement();
            stmt.execute(((DeleteBySearch)m.deleteBySearch().setTargetTable(m.createTargetTable(vendor.getTableReferenceFactory().tableName(schemaName, "indexing_entities"))).createExpression()).toString());
            connection.commit();
        }
        catch (Throwable throwable) {
            SQLUtil.closeQuietly(stmt);
            throw throwable;
        }
        SQLUtil.closeQuietly((Statement)stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyNeededSchemaTables(Connection connection, String schemaName, int maxQNameUsed) throws SQLException {
        Statement stmt = connection.createStatement();
        try {
            this.dropTablesIfExist(schemaName, "indexing_entities", stmt);
            this.dropTablesIfExist(schemaName, "all_qnames", stmt);
            this.dropTablesIfExist(schemaName, "app_version", stmt);
            this.dropTablesIfExist(schemaName, "entity_types", stmt);
            this.dropTablesIfExist(schemaName, "indexing_entities_entity_types", stmt);
            this.dropTablesIfExist(schemaName, "enum_lookup", stmt);
            this.dropTablesIfExist(schemaName, "used_classes", stmt);
            this.dropTablesIfExist(schemaName, "used_qnames", stmt);
            for (int x = 0; x <= maxQNameUsed; ++x) {
                this.dropTablesIfExist(schemaName, "qname_" + x, stmt);
            }
        }
        finally {
            SQLUtil.closeQuietly((Statement)stmt);
        }
    }

    private ApplicationInfo constructApplicationInfo(Boolean setQNameTableNameToNull) throws SQLException {
        final ApplicationInfo appInfo = new ApplicationInfo();
        final ArrayList<CompositeDescriptorInfo> valueDescriptors = new ArrayList<CompositeDescriptorInfo>();
        final ArrayDeque currentPath = new ArrayDeque();
        this._app.descriptor().accept((HierarchicalVisitor)new HierarchicalVisitorAdapter<Object, Object, RuntimeException>(){

            public boolean visitEnter(Object visited) throws RuntimeException {
                if (visited instanceof LayerDescriptor || visited instanceof ModuleDescriptor) {
                    currentPath.push(visited);
                }
                if (visited instanceof EntityDescriptor || visited instanceof ValueDescriptor) {
                    if (visited instanceof EntityDescriptor) {
                        EntityDescriptor entityDescriptor = (EntityDescriptor)visited;
                        if (entityDescriptor.queryable()) {
                            LOGGER.debug("THIS ONE WORKS: {}", (Object)entityDescriptor);
                            appInfo.entityDescriptors.put(((Class)Iterables.first((Iterable)entityDescriptor.types())).getName(), entityDescriptor);
                        }
                    } else {
                        valueDescriptors.add(new CompositeDescriptorInfo((LayerDescriptor)Iterables.first((Iterable)Iterables.skip((int)1, (Iterable)currentPath)), (ModuleDescriptor)Iterables.first((Iterable)currentPath), (CompositeDescriptor)visited));
                    }
                    return false;
                }
                return true;
            }

            public boolean visitLeave(Object visited) {
                if (visited instanceof LayerDescriptor || visited instanceof ModuleDescriptor) {
                    currentPath.pop();
                }
                return true;
            }
        });
        for (EntityDescriptor descriptor : appInfo.entityDescriptors.values()) {
            HashSet<QualifiedName> newQNames = new HashSet<QualifiedName>();
            this.extractPropertyQNames(descriptor, (Map)this._state.qNameInfos().get(), newQNames, valueDescriptors, appInfo.enumValues, setQNameTableNameToNull);
            this.extractAssociationQNames(descriptor, (Map)this._state.qNameInfos().get(), newQNames, setQNameTableNameToNull);
            this.extractManyAssociationQNames(descriptor, (Map)this._state.qNameInfos().get(), newQNames, setQNameTableNameToNull);
            ((Map)this._state.entityUsedQNames().get()).put(descriptor, newQNames);
        }
        appInfo.usedValueComposites.addAll(valueDescriptors);
        return appInfo;
    }

    private void processPropertyTypeForQNames(PropertyDescriptor pType, Map<QualifiedName, QNameInfo> qNameInfos, Set<QualifiedName> newQNames, List<CompositeDescriptorInfo> vDescriptors, Set<String> enumValues, Boolean setQNameTableNameToNull) {
        block9: {
            QualifiedName qName = pType.qualifiedName();
            if (newQNames.contains(qName) || qName.name().equals(Identity.class.getName())) break block9;
            newQNames.add(qName);
            QNameInfo info = qNameInfos.get(qName);
            if (info == null) {
                info = QNameInfo.fromProperty(qName, setQNameTableNameToNull != false ? null : "qname_" + qNameInfos.size(), pType);
                qNameInfos.put(qName, info);
            }
            Type vType = info.getFinalType();
            while (vType instanceof ParameterizedType) {
                vType = ((ParameterizedType)vType).getRawType();
            }
            if (vType instanceof Class) {
                final Class vTypeClass = (Class)vType;
                if (((Class)vType).isInterface()) {
                    for (CompositeDescriptorInfo descInfo : vDescriptors) {
                        ValueDescriptor vDesc;
                        CompositeDescriptor desc = descInfo.composite;
                        if (!(desc instanceof ValueDescriptor) || !Iterables.matchesAny((Specification)new Specification<Class<?>>(){

                            public boolean satisfiedBy(Class<?> item) {
                                return vTypeClass.isAssignableFrom(item);
                            }
                        }, (Iterable)(vDesc = (ValueDescriptor)desc).types())) continue;
                        for (PropertyDescriptor subPDesc : vDesc.state().properties()) {
                            this.processPropertyTypeForQNames(subPDesc, qNameInfos, newQNames, vDescriptors, enumValues, setQNameTableNameToNull);
                        }
                    }
                } else if (Enum.class.isAssignableFrom((Class)vType)) {
                    for (Object value : ((Class)vType).getEnumConstants()) {
                        enumValues.add(QualifiedName.fromClass((Class)((Class)vType), (String)value.toString()).toString());
                    }
                }
            }
        }
    }

    private void extractPropertyQNames(EntityDescriptor entityDesc, Map<QualifiedName, QNameInfo> qNameInfos, Set<QualifiedName> newQNames, List<CompositeDescriptorInfo> vDescriptors, Set<String> enumValues, Boolean setQNameTableNameToNull) {
        for (PropertyDescriptor pDesc : entityDesc.state().properties()) {
            if (!SQLSkeletonUtil.isQueryable(pDesc.accessor())) continue;
            this.processPropertyTypeForQNames(pDesc, qNameInfos, newQNames, vDescriptors, enumValues, setQNameTableNameToNull);
        }
    }

    private void extractAssociationQNames(EntityDescriptor entityDesc, Map<QualifiedName, QNameInfo> extractedQNames, Set<QualifiedName> newQNames, Boolean setQNameTableNameToNull) {
        for (AssociationDescriptor assoDesc : entityDesc.state().associations()) {
            QualifiedName qName;
            if (!SQLSkeletonUtil.isQueryable(assoDesc.accessor()) || extractedQNames.containsKey(qName = assoDesc.qualifiedName())) continue;
            extractedQNames.put(qName, QNameInfo.fromAssociation(qName, setQNameTableNameToNull != false ? null : "qname_" + extractedQNames.size(), assoDesc));
            newQNames.add(qName);
        }
    }

    private void extractManyAssociationQNames(EntityDescriptor entityDesc, Map<QualifiedName, QNameInfo> extractedQNames, Set<QualifiedName> newQNames, Boolean setQNameTableNameToNull) {
        for (AssociationDescriptor mAssoDesc : entityDesc.state().manyAssociations()) {
            QualifiedName qName = mAssoDesc.qualifiedName();
            if (!SQLSkeletonUtil.isQueryable(mAssoDesc.accessor()) || extractedQNames.containsKey(qName)) continue;
            extractedQNames.put(qName, QNameInfo.fromManyAssociation(qName, setQNameTableNameToNull != false ? null : "qname_" + extractedQNames.size(), mAssoDesc));
            newQNames.add(qName);
        }
    }

    protected abstract void testRequiredCapabilities(Connection var1) throws SQLException;

    protected boolean dropTablesIfExist(String schemaName, String tableName, Statement stmt) throws SQLException {
        boolean result = false;
        try {
            stmt.execute(this._vendor.toString((SQLStatement)this._vendor.getManipulationFactory().createDropTableOrViewStatement(this._vendor.getTableReferenceFactory().tableName(schemaName, tableName), ObjectType.TABLE, DropBehaviour.CASCADE)));
            result = true;
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        return result;
    }

    protected static String compositeDescriptorToString(LayerDescriptor layer, ModuleDescriptor module, CompositeDescriptor descriptor) {
        return DESCRIPTOR_COMPONENT_SEPARATOR_START + layer.name() + DESCRIPTOR_COMPONENT_SEPARATOR_END + DESCRIPTOR_COMPONENT_SEPARATOR_START + module.name() + DESCRIPTOR_COMPONENT_SEPARATOR_END + DESCRIPTOR_COMPONENT_SEPARATOR_START + Iterables.toString((Iterable)descriptor.types(), (Function)new Function<Class<?>, String>(){

            public String map(Class<?> item) {
                return item.getName();
            }
        }, (String)DESCRIPTOR_TYPE_SEPARATOR) + DESCRIPTOR_COMPONENT_SEPARATOR_END;
    }

    protected static <TCompositeDescriptor extends CompositeDescriptor> TCompositeDescriptor stringToCompositeDescriptor(final Class<TCompositeDescriptor> descriptorClass, ApplicationDescriptor appDesc, String str) {
        Matcher matcher = DESCRIPTOR_TEXTUAL_REGEXP.matcher(str);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Descriptor textual description " + str + " was invalid.");
        }
        final String layerName = matcher.group(1);
        final String moduleName = matcher.group(2);
        final HashSet<String> classNames = new HashSet<String>();
        Matcher typesMatcher = DESCRIPTOR_TYPES_REGEXP.matcher(matcher.group(3));
        while (typesMatcher.find()) {
            classNames.add(typesMatcher.group(0));
        }
        final CompositeDescriptor[] result = new CompositeDescriptor[1];
        appDesc.accept((HierarchicalVisitor)new HierarchicalVisitorAdapter<Object, Object, RuntimeException>(){

            public boolean visitEnter(Object visited) {
                CompositeDescriptor desc;
                boolean thisResult = true;
                if (visited instanceof LayerDescriptor) {
                    thisResult = ((LayerDescriptor)visited).name().equals(layerName);
                } else if (visited instanceof ModuleDescriptor) {
                    thisResult = ((ModuleDescriptor)visited).name().equals(moduleName);
                } else if (descriptorClass.isAssignableFrom(visited.getClass()) && classNames.equals(new HashSet(Iterables.toList((Iterable)Iterables.map((Function)new Function<Class<?>, String>(){

                    public String map(Class<?> from) {
                        return from.getName();
                    }
                }, (Iterable)(desc = (CompositeDescriptor)visited).types()))))) {
                    result[0] = desc;
                    thisResult = false;
                }
                return thisResult;
            }

            public boolean visitLeave(Object visited) {
                return result[0] == null;
            }
        });
        return (TCompositeDescriptor)result[0];
    }

    protected abstract void modifyPrimitiveTypes(Map<Class<?>, SQLDataType> var1, Map<Class<?>, Integer> var2);

    protected abstract SQLDataType getCollectionPathDataType();

    private static class CompositeDescriptorInfo {
        final LayerDescriptor layer;
        final ModuleDescriptor module;
        final CompositeDescriptor composite;

        private CompositeDescriptorInfo(LayerDescriptor theLayer, ModuleDescriptor theModule, CompositeDescriptor theComposite) {
            this.layer = theLayer;
            this.module = theModule;
            this.composite = theComposite;
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof CompositeDescriptorInfo && this.composite.equals(((CompositeDescriptorInfo)obj).composite);
        }

        public int hashCode() {
            return this.composite.hashCode();
        }
    }

    private static class ApplicationInfo {
        private final Map<String, EntityDescriptor> entityDescriptors = new HashMap<String, EntityDescriptor>();
        private final Set<CompositeDescriptorInfo> usedValueComposites = new HashSet<CompositeDescriptorInfo>();
        private final Set<String> enumValues = new HashSet<String>();

        private ApplicationInfo() {
        }
    }

    private static interface SQLTypeCustomizer {
        public SQLDataType customizeType(Type var1, SQLTypeInfo var2);
    }
}

