/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.sql.support.skeletons;

import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.association.AssociationStateDescriptor;
import org.qi4j.api.common.QualifiedName;
import org.qi4j.api.common.Visibility;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.property.PropertyDescriptor;
import org.qi4j.api.type.CollectionType;
import org.qi4j.api.type.ValueCompositeType;
import org.qi4j.api.type.ValueType;
import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.spi.entity.EntityState;
import org.qi4j.spi.entity.EntityStatus;
import org.qi4j.spi.entity.ManyAssociationState;
import org.qi4j.spi.entity.NamedAssociationState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SQLCompatEntityStateWrapper
implements EntityState {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SQLCompatEntityStateWrapper.class.getName());
    static final Function<EntityState, EntityState> WRAP = new Function<EntityState, EntityState>(){

        public EntityState map(EntityState from) {
            return new SQLCompatEntityStateWrapper(from);
        }
    };
    private static final Specification<PropertyDescriptor> PROPERTY_SPEC = new Specification<PropertyDescriptor>(){

        public boolean satisfiedBy(PropertyDescriptor propertyDescriptor) {
            boolean supported = this.isSupported(propertyDescriptor.valueType());
            if (!supported) {
                LOGGER.warn("Unsupported Property type: " + propertyDescriptor);
            }
            return supported;
        }

        private boolean isSupported(ValueType valueType) {
            if (valueType instanceof CollectionType) {
                CollectionType collectionType = (CollectionType)valueType;
                return this.isSupported(collectionType.collectedType());
            }
            Class mainType = valueType.mainType();
            return Number.class.isAssignableFrom(mainType) || Boolean.class.isAssignableFrom(mainType) || Character.class.isAssignableFrom(mainType) || Enum.class.isAssignableFrom(mainType) || String.class.isAssignableFrom(mainType) || valueType instanceof ValueCompositeType;
        }
    };
    private final EntityState wrappedEntityState;

    SQLCompatEntityStateWrapper(EntityState wrapped) {
        this.wrappedEntityState = wrapped;
    }

    public EntityReference identity() {
        return this.wrappedEntityState.identity();
    }

    public String version() {
        return this.wrappedEntityState.version();
    }

    public long lastModified() {
        return this.wrappedEntityState.lastModified();
    }

    public void remove() {
        this.wrappedEntityState.remove();
    }

    public EntityStatus status() {
        return this.wrappedEntityState.status();
    }

    public boolean isAssignableTo(Class<?> type) {
        return this.wrappedEntityState.isAssignableTo(type);
    }

    public EntityDescriptor entityDescriptor() {
        return new CompatEntityDescriptorWrapper(this.wrappedEntityState.entityDescriptor());
    }

    public Object propertyValueOf(QualifiedName stateName) {
        return this.wrappedEntityState.propertyValueOf(stateName);
    }

    public void setPropertyValue(QualifiedName stateName, Object json) {
        this.wrappedEntityState.setPropertyValue(stateName, json);
    }

    public EntityReference associationValueOf(QualifiedName stateName) {
        return this.wrappedEntityState.associationValueOf(stateName);
    }

    public void setAssociationValue(QualifiedName stateName, EntityReference newEntity) {
        this.wrappedEntityState.setAssociationValue(stateName, newEntity);
    }

    public ManyAssociationState manyAssociationValueOf(QualifiedName stateName) {
        return this.wrappedEntityState.manyAssociationValueOf(stateName);
    }

    public NamedAssociationState namedAssociationValueOf(QualifiedName stateName) {
        return this.wrappedEntityState.namedAssociationValueOf(stateName);
    }

    public boolean equals(Object obj) {
        return this.wrappedEntityState.equals(obj);
    }

    public int hashCode() {
        return this.wrappedEntityState.hashCode();
    }

    private static class CompatAssociationStateDescriptorWrapper
    implements AssociationStateDescriptor {
        private final AssociationStateDescriptor wrappedAssociationStateDescriptor;

        private CompatAssociationStateDescriptorWrapper(AssociationStateDescriptor wrappedAssociationStateDescriptor) {
            this.wrappedAssociationStateDescriptor = wrappedAssociationStateDescriptor;
        }

        public AssociationDescriptor getAssociationByName(String name) throws IllegalArgumentException {
            return this.wrappedAssociationStateDescriptor.getAssociationByName(name);
        }

        public AssociationDescriptor getAssociationByQualifiedName(QualifiedName name) throws IllegalArgumentException {
            return this.wrappedAssociationStateDescriptor.getAssociationByQualifiedName(name);
        }

        public AssociationDescriptor getManyAssociationByName(String name) throws IllegalArgumentException {
            return this.wrappedAssociationStateDescriptor.getManyAssociationByName(name);
        }

        public AssociationDescriptor getManyAssociationByQualifiedName(QualifiedName name) throws IllegalArgumentException {
            return this.wrappedAssociationStateDescriptor.getManyAssociationByQualifiedName(name);
        }

        public AssociationDescriptor getNamedAssociationByName(String name) throws IllegalArgumentException {
            return this.wrappedAssociationStateDescriptor.getNamedAssociationByName(name);
        }

        public AssociationDescriptor getNamedAssociationByQualifiedName(QualifiedName name) throws IllegalArgumentException {
            return this.wrappedAssociationStateDescriptor.getNamedAssociationByQualifiedName(name);
        }

        public Iterable<? extends AssociationDescriptor> associations() {
            return this.wrappedAssociationStateDescriptor.associations();
        }

        public Iterable<? extends AssociationDescriptor> manyAssociations() {
            return this.wrappedAssociationStateDescriptor.manyAssociations();
        }

        public Iterable<? extends AssociationDescriptor> namedAssociations() {
            return this.wrappedAssociationStateDescriptor.namedAssociations();
        }

        public PropertyDescriptor findPropertyModelByName(String name) throws IllegalArgumentException {
            return this.wrappedAssociationStateDescriptor.findPropertyModelByName(name);
        }

        public PropertyDescriptor findPropertyModelByQualifiedName(QualifiedName name) throws IllegalArgumentException {
            return this.wrappedAssociationStateDescriptor.findPropertyModelByQualifiedName(name);
        }

        public Iterable<? extends PropertyDescriptor> properties() {
            return Iterables.filter((Specification)PROPERTY_SPEC, (Iterable)this.wrappedAssociationStateDescriptor.properties());
        }

        public boolean equals(Object obj) {
            return this.wrappedAssociationStateDescriptor.equals(obj);
        }

        public int hashCode() {
            return this.wrappedAssociationStateDescriptor.hashCode();
        }
    }

    private static class CompatEntityDescriptorWrapper
    implements EntityDescriptor {
        private final EntityDescriptor wrappedEntityDescriptor;

        private CompatEntityDescriptorWrapper(EntityDescriptor wrappedEntityDescriptor) {
            this.wrappedEntityDescriptor = wrappedEntityDescriptor;
        }

        public AssociationStateDescriptor state() {
            return new CompatAssociationStateDescriptorWrapper(this.wrappedEntityDescriptor.state());
        }

        public boolean queryable() {
            return this.wrappedEntityDescriptor.queryable();
        }

        public Class<?> primaryType() {
            return this.wrappedEntityDescriptor.primaryType();
        }

        public Iterable<Class<?>> mixinTypes() {
            return this.wrappedEntityDescriptor.mixinTypes();
        }

        public Visibility visibility() {
            return this.wrappedEntityDescriptor.visibility();
        }

        public boolean isAssignableTo(Class<?> type) {
            return this.wrappedEntityDescriptor.isAssignableTo(type);
        }

        public Iterable<Class<?>> types() {
            return this.wrappedEntityDescriptor.types();
        }

        public <T> T metaInfo(Class<T> infoType) {
            return (T)this.wrappedEntityDescriptor.metaInfo(infoType);
        }

        public boolean equals(Object obj) {
            return this.wrappedEntityDescriptor.equals(obj);
        }

        public int hashCode() {
            return this.wrappedEntityDescriptor.hashCode();
        }
    }
}

