/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rdf.entity;

import org.openrdf.model.BNode;
import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.GraphImpl;
import org.qi4j.api.Qi4j;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.composite.CompositeInstance;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.property.PropertyDescriptor;
import org.qi4j.api.service.qualifier.Tagged;
import org.qi4j.api.type.ValueCompositeType;
import org.qi4j.api.type.ValueType;
import org.qi4j.api.util.Classes;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.api.value.ValueSerializer;
import org.qi4j.functional.Iterables;
import org.qi4j.library.rdf.Rdfs;
import org.qi4j.spi.entity.EntityState;
import org.qi4j.spi.entity.ManyAssociationState;

public class EntityStateSerializer {
    @Service
    @Tagged(value={"json"})
    private ValueSerializer valueSerializer;

    public URI createEntityURI(ValueFactory valueFactory, EntityReference identity) {
        return valueFactory.createURI(identity.toURI());
    }

    public Iterable<Statement> serialize(EntityState entityState) {
        return this.serialize(entityState, true);
    }

    public Iterable<Statement> serialize(EntityState entityState, boolean includeNonQueryable) {
        GraphImpl graph = new GraphImpl();
        this.serialize(entityState, includeNonQueryable, (Graph)graph);
        return graph;
    }

    public void serialize(EntityState entityState, boolean includeNonQueryable, Graph graph) {
        ValueFactory values = graph.getValueFactory();
        EntityReference identity = entityState.identity();
        URI entityUri = this.createEntityURI(values, identity);
        graph.add((Resource)entityUri, Rdfs.TYPE, (Value)values.createURI(Classes.toURI((Class)((Class)Iterables.first((Iterable)entityState.entityDescriptor().types())))), new Resource[0]);
        this.serializeProperties(entityState, graph, (Resource)entityUri, entityState.entityDescriptor(), includeNonQueryable);
        this.serializeAssociations(entityState, graph, entityUri, entityState.entityDescriptor().state().associations(), includeNonQueryable);
        this.serializeManyAssociations(entityState, graph, entityUri, entityState.entityDescriptor().state().manyAssociations(), includeNonQueryable);
    }

    private void serializeProperties(EntityState entityState, Graph graph, Resource subject, EntityDescriptor entityType, boolean includeNonQueryable) {
        for (PropertyDescriptor persistentProperty : entityType.state().properties()) {
            Object property = entityState.propertyValueOf(persistentProperty.qualifiedName());
            if (property == null) continue;
            this.serializeProperty(persistentProperty, property, subject, graph, includeNonQueryable);
        }
    }

    private void serializeProperty(PropertyDescriptor persistentProperty, Object property, Resource subject, Graph graph, boolean includeNonQueryable) {
        if (!includeNonQueryable && !persistentProperty.queryable()) {
            return;
        }
        ValueType valueType = persistentProperty.valueType();
        ValueFactory valueFactory = graph.getValueFactory();
        String propertyURI = persistentProperty.qualifiedName().toURI();
        URI predicate = valueFactory.createURI(propertyURI);
        String baseURI = propertyURI.substring(0, propertyURI.indexOf(35)) + "/";
        if (valueType instanceof ValueCompositeType) {
            this.serializeValueComposite(subject, predicate, (ValueComposite)property, valueType, graph, baseURI, includeNonQueryable);
        } else {
            String stringProperty = this.valueSerializer.serialize(new ValueSerializer.Options().withoutTypeInfo(), property);
            Literal object = valueFactory.createLiteral(stringProperty);
            graph.add(subject, predicate, (Value)object, new Resource[0]);
        }
    }

    private void serializeValueComposite(Resource subject, URI predicate, ValueComposite value, ValueType valueType, Graph graph, String baseUri, boolean includeNonQueryable) {
        ValueFactory valueFactory = graph.getValueFactory();
        BNode collection = valueFactory.createBNode();
        graph.add(subject, predicate, (Value)collection, new Resource[0]);
        for (PropertyDescriptor persistentProperty : ((ValueCompositeType)valueType).properties()) {
            Object propertyValue = ((CompositeInstance)Qi4j.FUNCTION_COMPOSITE_INSTANCE_OF.map((Object)value)).state().propertyFor(persistentProperty.accessor()).get();
            if (propertyValue == null) continue;
            ValueType type = persistentProperty.valueType();
            if (type instanceof ValueCompositeType) {
                URI pred = valueFactory.createURI(baseUri, persistentProperty.qualifiedName().name());
                this.serializeValueComposite((Resource)collection, pred, (ValueComposite)propertyValue, type, graph, baseUri + persistentProperty.qualifiedName().name() + "/", includeNonQueryable);
                continue;
            }
            this.serializeProperty(persistentProperty, propertyValue, (Resource)collection, graph, includeNonQueryable);
        }
    }

    private void serializeAssociations(EntityState entityState, Graph graph, URI entityUri, Iterable<? extends AssociationDescriptor> associations, boolean includeNonQueryable) {
        ValueFactory values = graph.getValueFactory();
        for (AssociationDescriptor associationDescriptor : associations) {
            EntityReference associatedId;
            if (!includeNonQueryable && !associationDescriptor.queryable() || (associatedId = entityState.associationValueOf(associationDescriptor.qualifiedName())) == null) continue;
            URI assocURI = values.createURI(associationDescriptor.qualifiedName().toURI());
            URI assocEntityURI = values.createURI(associatedId.toURI());
            graph.add((Resource)entityUri, assocURI, (Value)assocEntityURI, new Resource[0]);
        }
    }

    private void serializeManyAssociations(EntityState entityState, Graph graph, URI entityUri, Iterable<? extends AssociationDescriptor> associations, boolean includeNonQueryable) {
        ValueFactory values = graph.getValueFactory();
        for (AssociationDescriptor associationDescriptor : associations) {
            if (!includeNonQueryable && !associationDescriptor.queryable()) continue;
            BNode collection = values.createBNode();
            graph.add((Resource)entityUri, values.createURI(associationDescriptor.qualifiedName().toURI()), (Value)collection, new Resource[0]);
            graph.add((Resource)collection, Rdfs.TYPE, (Value)Rdfs.SEQ, new Resource[0]);
            ManyAssociationState associatedIds = entityState.manyAssociationValueOf(associationDescriptor.qualifiedName());
            for (EntityReference associatedId : associatedIds) {
                URI assocEntityURI = values.createURI(associatedId.toURI());
                graph.add((Resource)collection, Rdfs.LIST_ITEM, (Value)assocEntityURI, new Resource[0]);
            }
        }
    }
}

