/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rdf.model;

import org.qi4j.api.composite.MethodDescriptor;
import org.qi4j.api.composite.TransientDescriptor;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.object.ObjectDescriptor;
import org.qi4j.api.structure.ApplicationDescriptor;
import org.qi4j.api.structure.LayerDescriptor;
import org.qi4j.api.structure.ModuleDescriptor;
import org.qi4j.functional.HierarchicalVisitorAdapter;
import org.qi4j.functional.Iterables;
import org.qi4j.library.rdf.Qi4jRdf;
import org.qi4j.library.rdf.serializer.SerializerContext;

class ApplicationVisitor
extends HierarchicalVisitorAdapter<Object, Object, RuntimeException> {
    private SerializerContext context;
    private String appUri;
    private String layerUri;
    private String moduleUri;
    private String compositeUri;

    ApplicationVisitor(SerializerContext context) {
        this.context = context;
    }

    public boolean visitEnter(Object visited) throws RuntimeException {
        if (visited instanceof ApplicationDescriptor) {
            ApplicationDescriptor applicationDescriptor = (ApplicationDescriptor)visited;
            this.appUri = this.context.createApplicationUri(applicationDescriptor.name());
            this.context.setNameAndType(this.appUri, applicationDescriptor.name(), Qi4jRdf.TYPE_APPLICATION);
        }
        if (visited instanceof LayerDescriptor) {
            LayerDescriptor layerDescriptor = (LayerDescriptor)visited;
            this.layerUri = this.context.createLayerUri(this.appUri, layerDescriptor.name());
            this.context.setNameAndType(this.layerUri, layerDescriptor.name(), Qi4jRdf.TYPE_LAYER);
            this.context.addRelationship(this.appUri, Qi4jRdf.RELATIONSHIP_LAYER, this.layerUri);
        }
        if (visited instanceof ModuleDescriptor) {
            ModuleDescriptor moduleDescriptor = (ModuleDescriptor)visited;
            this.moduleUri = this.context.createModuleUri(this.layerUri, moduleDescriptor.name());
            this.context.setNameAndType(this.layerUri, moduleDescriptor.name(), Qi4jRdf.TYPE_MODULE);
            this.context.addRelationship(this.layerUri, Qi4jRdf.RELATIONSHIP_MODULE, this.moduleUri);
        }
        if (visited instanceof TransientDescriptor) {
            TransientDescriptor transientDescriptor = (TransientDescriptor)visited;
            this.compositeUri = this.context.createCompositeUri(this.moduleUri, (Class)Iterables.first((Iterable)transientDescriptor.types()));
            this.context.addType(this.compositeUri, Qi4jRdf.TYPE_COMPOSITE);
            this.context.addRelationship(this.moduleUri, Qi4jRdf.RELATIONSHIP_COMPOSITE, this.compositeUri);
        }
        if (visited instanceof EntityDescriptor) {
            EntityDescriptor entityDescriptor = (EntityDescriptor)visited;
            this.compositeUri = this.context.createCompositeUri(this.moduleUri, (Class)Iterables.first((Iterable)entityDescriptor.types()));
            this.context.addType(this.compositeUri, Qi4jRdf.TYPE_ENTITY);
            this.context.addRelationship(this.moduleUri, Qi4jRdf.RELATIONSHIP_ENTITY, this.compositeUri);
        }
        if (visited instanceof ObjectDescriptor) {
            ObjectDescriptor objectDescriptor = (ObjectDescriptor)visited;
            this.compositeUri = this.context.createCompositeUri(this.moduleUri, (Class)Iterables.first((Iterable)objectDescriptor.types()));
            this.context.addType(this.compositeUri, Qi4jRdf.TYPE_OBJECT);
            this.context.addRelationship(this.moduleUri, Qi4jRdf.RELATIONSHIP_OBJECT, this.compositeUri);
        }
        if (visited instanceof MethodDescriptor) {
            MethodDescriptor compositeMethodDescriptor = (MethodDescriptor)visited;
            String compositeMethodUri = this.context.createCompositeMethodUri(this.compositeUri, compositeMethodDescriptor.method());
            this.context.addType(compositeMethodUri, Qi4jRdf.TYPE_METHOD);
            this.context.addRelationship(this.compositeUri, Qi4jRdf.RELATIONSHIP_METHOD, compositeMethodUri);
        }
        return true;
    }
}

