/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rdf.repository;

import java.io.File;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;
import org.qi4j.api.activation.ActivatorAdapter;
import org.qi4j.api.activation.Activators;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.library.rdf.repository.ResetableRepository;

@Mixins(value={MemoryRepositoryMixin.class})
@Activators(value={Activator.class})
public interface MemoryRepositoryService
extends Repository,
ServiceComposite {
    public void initialize() throws RepositoryException;

    public void shutDown() throws RepositoryException;

    public static abstract class MemoryRepositoryMixin
    implements MemoryRepositoryService,
    ResetableRepository {
        SailRepository repo = new SailRepository((Sail)new MemoryStore());

        @Override
        public void initialize() throws RepositoryException {
            this.repo.initialize();
        }

        public boolean isInitialized() {
            return this.repo.isInitialized();
        }

        @Override
        public void shutDown() throws RepositoryException {
            this.repo.shutDown();
        }

        public void setDataDir(File dataDir) {
            this.repo.setDataDir(dataDir);
        }

        public File getDataDir() {
            return this.repo.getDataDir();
        }

        public boolean isWritable() throws RepositoryException {
            return this.repo.isWritable();
        }

        public RepositoryConnection getConnection() throws RepositoryException {
            return this.repo.getConnection();
        }

        public ValueFactory getValueFactory() {
            return this.repo.getValueFactory();
        }

        @Override
        public void discardEntireRepository() throws RepositoryException {
            this.repo = new SailRepository((Sail)new MemoryStore());
        }
    }

    public static class Activator
    extends ActivatorAdapter<ServiceReference<MemoryRepositoryService>> {
        public void afterActivation(ServiceReference<MemoryRepositoryService> activated) throws Exception {
            ((MemoryRepositoryService)activated.get()).initialize();
        }

        public void beforePassivation(ServiceReference<MemoryRepositoryService> passivating) throws Exception {
            ((MemoryRepositoryService)passivating.get()).shutDown();
        }
    }
}

