/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rdf.repository;

import java.io.File;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.sail.Sail;
import org.openrdf.sail.nativerdf.NativeStore;
import org.qi4j.api.activation.ActivatorAdapter;
import org.qi4j.api.activation.Activators;
import org.qi4j.api.common.Optional;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.Availability;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.library.fileconfig.FileConfiguration;
import org.qi4j.library.rdf.repository.NativeConfiguration;
import org.qi4j.library.rdf.repository.ResetableRepository;

@Mixins(value={NativeRepositoryMixin.class})
@Activators(value={Activator.class})
public interface NativeRepositoryService
extends Repository,
ServiceComposite,
Availability {
    public void initialize() throws RepositoryException;

    public void shutDown() throws RepositoryException;

    public static abstract class NativeRepositoryMixin
    implements NativeRepositoryService,
    ResetableRepository {
        @Optional
        @Service
        FileConfiguration fileConfiguration;
        @This
        private Configuration<NativeConfiguration> configuration;
        private SailRepository repo = new SailRepository((Sail)new NativeStore());
        private boolean isNotInitialized = true;

        public void setDataDir(File dataDir) {
            this.repo.setDataDir(dataDir);
        }

        public File getDataDir() {
            return this.repo.getDataDir();
        }

        @Override
        public void initialize() throws RepositoryException {
            File dataDirectory;
            String dataDir = (String)((NativeConfiguration)this.configuration.get()).dataDirectory().get();
            if (dataDir == null || "".equals(dataDir)) {
                String serviceIdentity = (String)((NativeConfiguration)this.configuration.get()).identity().get();
                dataDir = this.fileConfiguration != null ? new File(this.fileConfiguration.dataDirectory(), serviceIdentity).getAbsolutePath() : (serviceIdentity == null || "".equals(serviceIdentity) ? "./rdf/repositories/qi4j" : "./rdf/repositories/" + serviceIdentity);
                ((NativeConfiguration)this.configuration.get()).dataDirectory().set((Object)dataDir);
                this.configuration.save();
                dataDirectory = new File(dataDir);
            } else {
                dataDirectory = new File(dataDir).getAbsoluteFile();
            }
            this.initializeRepository(dataDirectory);
        }

        public boolean isInitialized() {
            return !this.isNotInitialized;
        }

        @Override
        public void shutDown() throws RepositoryException {
            this.repo.shutDown();
        }

        public boolean isWritable() throws RepositoryException {
            return this.repo.isWritable();
        }

        public RepositoryConnection getConnection() throws RepositoryException {
            if (this.isNotInitialized) {
                return null;
            }
            return this.repo.getConnection();
        }

        public ValueFactory getValueFactory() {
            return this.repo.getValueFactory();
        }

        @Override
        public void discardEntireRepository() throws RepositoryException {
            File dataDir = this.repo.getDataDir();
            this.repo.shutDown();
            this.delete(dataDir);
            this.initializeRepository(dataDir);
        }

        private void delete(File dataDir) {
            File[] children;
            for (File child : children = dataDir.listFiles()) {
                if (child.isDirectory()) {
                    this.delete(child);
                    continue;
                }
                child.delete();
            }
        }

        private void initializeRepository(File dataDir) throws RepositoryException {
            String tripleIndexes = (String)((NativeConfiguration)this.configuration.get()).tripleIndexes().get();
            if (tripleIndexes == null) {
                tripleIndexes = "";
                ((NativeConfiguration)this.configuration.get()).tripleIndexes().set((Object)tripleIndexes);
            }
            boolean forceSync = (Boolean)((NativeConfiguration)this.configuration.get()).forceSync().get();
            NativeStore store = (NativeStore)this.repo.getSail();
            store.setDataDir(dataDir);
            store.setTripleIndexes(tripleIndexes);
            store.setForceSync(forceSync);
            this.repo.initialize();
            this.isNotInitialized = false;
        }

        public boolean isAvailable() {
            return !this.isNotInitialized;
        }
    }

    public static class Activator
    extends ActivatorAdapter<ServiceReference<NativeRepositoryService>> {
        public void afterActivation(ServiceReference<NativeRepositoryService> activated) throws Exception {
            ((NativeRepositoryService)activated.get()).initialize();
        }

        public void beforePassivation(ServiceReference<NativeRepositoryService> passivating) throws Exception {
            ((NativeRepositoryService)passivating.get()).shutDown();
        }
    }
}

