/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rdf.repository;

import java.io.File;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.sail.Sail;
import org.openrdf.sail.rdbms.RdbmsStore;
import org.qi4j.api.activation.ActivatorAdapter;
import org.qi4j.api.activation.Activators;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.library.rdf.repository.RdbmsRepositoryConfiguration;

@Mixins(value={RdbmsRepositoryMixin.class})
@Activators(value={Activator.class})
public interface RdbmsRepositoryService
extends Repository,
ServiceComposite {
    public void initialize() throws RepositoryException;

    public void shutDown() throws RepositoryException;

    public static abstract class RdbmsRepositoryMixin
    implements RdbmsRepositoryService {
        @This
        private Configuration<RdbmsRepositoryConfiguration> configuration;
        private SailRepository repo;

        public void setDataDir(File file) {
            this.repo.setDataDir(file);
        }

        public File getDataDir() {
            return this.repo.getDataDir();
        }

        @Override
        public void initialize() throws RepositoryException {
            RdbmsRepositoryConfiguration conf = (RdbmsRepositoryConfiguration)this.configuration.get();
            String jdbcDriver = (String)conf.jdbcDriver().get();
            String jdbcUrl = (String)conf.jdbcUrl().get();
            String user = (String)conf.user().get();
            String password = (String)conf.password().get();
            this.repo = new SailRepository((Sail)new RdbmsStore(jdbcDriver, jdbcUrl, user, password));
            this.repo.initialize();
        }

        public boolean isInitialized() {
            return this.repo.isInitialized();
        }

        @Override
        public void shutDown() throws RepositoryException {
            this.repo.shutDown();
        }

        public boolean isWritable() throws RepositoryException {
            return this.repo.isWritable();
        }

        public RepositoryConnection getConnection() throws RepositoryException {
            return this.repo.getConnection();
        }

        public ValueFactory getValueFactory() {
            return this.repo.getValueFactory();
        }
    }

    public static class Activator
    extends ActivatorAdapter<ServiceReference<RdbmsRepositoryService>> {
        public void afterActivation(ServiceReference<RdbmsRepositoryService> activated) throws Exception {
            ((RdbmsRepositoryService)activated.get()).initialize();
        }

        public void beforePassivation(ServiceReference<RdbmsRepositoryService> passivating) throws Exception {
            ((RdbmsRepositoryService)passivating.get()).shutDown();
        }
    }
}

