/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rdf.serializer;

import java.lang.reflect.Method;
import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.qi4j.api.util.Classes;
import org.qi4j.library.rdf.Rdfs;

public final class SerializerContext {
    private final Graph graph;
    private final ValueFactory valueFactory;

    public SerializerContext(Graph graph) {
        this.valueFactory = graph.getValueFactory();
        this.graph = graph;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    public String createServiceUri(String layer, String module, Class type, String identity) {
        String serviceType = Classes.normalizeClassToURI((String)type.getName());
        String moduleUri = this.createModuleUri(layer, module);
        return moduleUri + "/" + serviceType + "/" + identity;
    }

    public String createCompositeUri(String module, Class composite) {
        String compositeName = Classes.normalizeClassToURI((String)composite.getName());
        return module + "/" + compositeName;
    }

    public String createApplicationUri(String app) {
        return "urn:qi4j:model:" + app;
    }

    public String createLayerUri(String appUri, String layer) {
        return appUri + "/" + layer;
    }

    public String createModuleUri(String layerUri, String module) {
        return layerUri + "/" + module;
    }

    public void setNameAndType(String node, String name, URI type) {
        this.addType(node, type);
        this.addName(node, name);
    }

    public void addName(String subject, String name) {
        Literal nameValue = this.valueFactory.createLiteral(name);
        URI subjectUri = this.valueFactory.createURI(subject);
        this.graph.add((Object)this.valueFactory.createStatement((Resource)subjectUri, Rdfs.LABEL, (Value)nameValue));
    }

    public void addType(String subject, URI type) {
        URI subjectUri = this.valueFactory.createURI(subject);
        Statement statement = this.valueFactory.createStatement((Resource)subjectUri, Rdfs.TYPE, (Value)type);
        this.graph.add((Object)statement);
    }

    public void addStatement(String subject, URI predicate, String literal) {
        Literal object = this.valueFactory.createLiteral(literal);
        URI subjectUri = this.valueFactory.createURI(subject);
        Statement statement = this.valueFactory.createStatement((Resource)subjectUri, predicate, (Value)object);
        this.graph.add((Object)statement);
    }

    public void addRelationship(String subject, URI relationship, String object) {
        URI subjectUri = this.valueFactory.createURI(subject);
        URI objectUri = this.valueFactory.createURI(object);
        Statement statement = this.valueFactory.createStatement((Resource)subjectUri, relationship, (Value)objectUri);
        this.graph.add((Object)statement);
    }

    public void addStatement(String subject, URI predicate, boolean literal) {
        URI subjectUri = this.valueFactory.createURI(subject);
        Literal object = this.valueFactory.createLiteral(literal);
        Statement statement = this.valueFactory.createStatement((Resource)subjectUri, predicate, (Value)object);
        this.graph.add((Object)statement);
    }

    public String createCompositeMethodUri(String compositeUri, Method method) {
        return compositeUri + "/" + method.toGenericString().replace(" ", "_");
    }
}

