/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.sql.bonecp;

import com.jolbox.bonecp.BoneCPDataSource;
import java.util.Properties;
import org.qi4j.api.activation.Activators;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.library.sql.datasource.AbstractDataSourceServiceImporterMixin;
import org.qi4j.library.sql.datasource.DataSourceConfigurationValue;
import org.qi4j.library.sql.datasource.DataSourceServiceImporterActivation;

@Mixins(value={Mixin.class})
@Activators(value={DataSourceServiceImporterActivation.Activator.class})
public class BoneCPDataSourceServiceImporter {

    public static class Mixin
    extends AbstractDataSourceServiceImporterMixin<BoneCPDataSource> {
        protected BoneCPDataSource setupDataSourcePool(DataSourceConfigurationValue config) throws Exception {
            BoneCPDataSource pool = new BoneCPDataSource();
            Class.forName((String)config.driver().get());
            pool.setDriverClass((String)config.driver().get());
            pool.setJdbcUrl((String)config.url().get());
            if (!((String)config.username().get()).equals("")) {
                pool.setUsername((String)config.username().get());
                pool.setPassword((String)config.password().get());
            }
            if (config.minPoolSize().get() != null) {
                pool.setMinConnectionsPerPartition(((Integer)config.minPoolSize().get()).intValue());
            }
            if (config.maxPoolSize().get() != null) {
                pool.setMaxConnectionsPerPartition(((Integer)config.maxPoolSize().get()).intValue());
            }
            if (config.loginTimeoutSeconds().get() != null) {
                pool.setLoginTimeout(((Integer)config.loginTimeoutSeconds().get()).intValue());
            }
            if (config.maxConnectionAgeSeconds().get() != null) {
                pool.setMaxConnectionAgeInSeconds((long)((Integer)config.maxConnectionAgeSeconds().get()).intValue());
            }
            if (config.validationQuery().get() != null) {
                pool.setConnectionTestStatement((String)config.validationQuery().get());
            }
            String props = (String)config.properties().get();
            String[] properties = props.split(",");
            Properties poolProperties = new Properties();
            for (String property : properties) {
                if (property.trim().length() <= 0) continue;
                String[] keyvalue = property.trim().split("=");
                poolProperties.setProperty(keyvalue[0], keyvalue[1]);
            }
            pool.setProperties(poolProperties);
            return pool;
        }

        protected void passivateDataSourcePool(BoneCPDataSource dataSourcePool) throws Exception {
            dataSourcePool.close();
        }
    }
}

