/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.elasticsearch;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.count.CountRequestBuilder;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.AndFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.OrFilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.SortOrder;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.query.grammar.AndSpecification;
import org.qi4j.api.query.grammar.AssociationNotNullSpecification;
import org.qi4j.api.query.grammar.AssociationNullSpecification;
import org.qi4j.api.query.grammar.BinarySpecification;
import org.qi4j.api.query.grammar.ComparisonSpecification;
import org.qi4j.api.query.grammar.ContainsAllSpecification;
import org.qi4j.api.query.grammar.ContainsSpecification;
import org.qi4j.api.query.grammar.EqSpecification;
import org.qi4j.api.query.grammar.GeSpecification;
import org.qi4j.api.query.grammar.GtSpecification;
import org.qi4j.api.query.grammar.LeSpecification;
import org.qi4j.api.query.grammar.LtSpecification;
import org.qi4j.api.query.grammar.ManyAssociationContainsSpecification;
import org.qi4j.api.query.grammar.MatchesSpecification;
import org.qi4j.api.query.grammar.NamedAssociationContainsNameSpecification;
import org.qi4j.api.query.grammar.NamedAssociationContainsSpecification;
import org.qi4j.api.query.grammar.NeSpecification;
import org.qi4j.api.query.grammar.NotSpecification;
import org.qi4j.api.query.grammar.OrSpecification;
import org.qi4j.api.query.grammar.OrderBy;
import org.qi4j.api.query.grammar.PropertyNotNullSpecification;
import org.qi4j.api.query.grammar.PropertyNullSpecification;
import org.qi4j.api.query.grammar.QuerySpecification;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.index.elasticsearch.ElasticSearchFinderSupport;
import org.qi4j.index.elasticsearch.ElasticSearchSupport;
import org.qi4j.spi.query.EntityFinder;
import org.qi4j.spi.query.EntityFinderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mixins(value={Mixin.class})
public interface ElasticSearchFinder
extends EntityFinder {

    public static class Mixin
    implements EntityFinder {
        private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchFinder.class);
        private static final Map<Class<?>, ElasticSearchFinderSupport.ComplexTypeSupport> COMPLEX_TYPE_SUPPORTS = new HashMap(0);
        @This
        private ElasticSearchSupport support;

        public Iterable<EntityReference> findEntities(Class<?> resultType, Specification<Composite> whereClause, OrderBy[] orderBySegments, Integer firstResult, Integer maxResults, Map<String, Object> variables) throws EntityFinderException {
            SearchRequestBuilder request = this.support.client().prepareSearch(new String[]{this.support.index()});
            AndFilterBuilder filterBuilder = Mixin.baseFilters(resultType);
            QueryBuilder queryBuilder = this.processWhereSpecification(filterBuilder, whereClause, variables);
            request.setQuery((QueryBuilder)QueryBuilders.filteredQuery((QueryBuilder)queryBuilder, (FilterBuilder)filterBuilder));
            if (firstResult != null) {
                request.setFrom(firstResult.intValue());
            }
            if (maxResults != null) {
                request.setSize(maxResults.intValue());
            }
            if (orderBySegments != null) {
                for (OrderBy order : orderBySegments) {
                    request.addSort(order.property().toString(), order.order() == OrderBy.Order.ASCENDING ? SortOrder.ASC : SortOrder.DESC);
                }
            }
            LOGGER.debug("Will search Entities: {}", (Object)request);
            SearchResponse response = (SearchResponse)request.execute().actionGet();
            return Iterables.map((Function)new Function<SearchHit, EntityReference>(){

                public EntityReference map(SearchHit from) {
                    return EntityReference.parseEntityReference((String)from.id());
                }
            }, (Iterable)response.getHits());
        }

        public EntityReference findEntity(Class<?> resultType, Specification<Composite> whereClause, Map<String, Object> variables) throws EntityFinderException {
            SearchRequestBuilder request = this.support.client().prepareSearch(new String[]{this.support.index()});
            AndFilterBuilder filterBuilder = Mixin.baseFilters(resultType);
            QueryBuilder queryBuilder = this.processWhereSpecification(filterBuilder, whereClause, variables);
            request.setQuery((QueryBuilder)QueryBuilders.filteredQuery((QueryBuilder)queryBuilder, (FilterBuilder)filterBuilder));
            request.setSize(1);
            LOGGER.debug("Will search Entity: {}", (Object)request);
            SearchResponse response = (SearchResponse)request.execute().actionGet();
            if (response.getHits().totalHits() == 1L) {
                return EntityReference.parseEntityReference((String)response.getHits().getAt(0).id());
            }
            return null;
        }

        public long countEntities(Class<?> resultType, Specification<Composite> whereClause, Map<String, Object> variables) throws EntityFinderException {
            CountRequestBuilder request = this.support.client().prepareCount(new String[]{this.support.index()});
            AndFilterBuilder filterBuilder = Mixin.baseFilters(resultType);
            QueryBuilder queryBuilder = this.processWhereSpecification(filterBuilder, whereClause, variables);
            request.setQuery((QueryBuilder)QueryBuilders.filteredQuery((QueryBuilder)queryBuilder, (FilterBuilder)filterBuilder));
            LOGGER.debug("Will count Entities: {}", (Object)request);
            CountResponse count = (CountResponse)request.execute().actionGet();
            return count.getCount();
        }

        private static AndFilterBuilder baseFilters(Class<?> resultType) {
            return FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.termFilter((String)"_types", (String)resultType.getName())});
        }

        private QueryBuilder processWhereSpecification(AndFilterBuilder filterBuilder, Specification<Composite> spec, Map<String, Object> variables) throws EntityFinderException {
            if (spec == null) {
                return QueryBuilders.matchAllQuery();
            }
            if (spec instanceof QuerySpecification) {
                return QueryBuilders.wrapperQuery((String)((QuerySpecification)spec).query());
            }
            this.processSpecification((FilterBuilder)filterBuilder, spec, variables);
            return QueryBuilders.matchAllQuery();
        }

        private void processSpecification(FilterBuilder filterBuilder, Specification<Composite> spec, Map<String, Object> variables) throws EntityFinderException {
            if (spec instanceof BinarySpecification) {
                BinarySpecification binSpec = (BinarySpecification)spec;
                this.processBinarySpecification(filterBuilder, binSpec, variables);
            } else if (spec instanceof NotSpecification) {
                NotSpecification notSpec = (NotSpecification)spec;
                this.processNotSpecification(filterBuilder, notSpec, variables);
            } else if (spec instanceof ComparisonSpecification) {
                ComparisonSpecification compSpec = (ComparisonSpecification)spec;
                this.processComparisonSpecification(filterBuilder, compSpec, variables);
            } else if (spec instanceof ContainsAllSpecification) {
                ContainsAllSpecification contAllSpec = (ContainsAllSpecification)spec;
                this.processContainsAllSpecification(filterBuilder, contAllSpec, variables);
            } else if (spec instanceof ContainsSpecification) {
                ContainsSpecification contSpec = (ContainsSpecification)spec;
                this.processContainsSpecification(filterBuilder, contSpec, variables);
            } else if (spec instanceof MatchesSpecification) {
                MatchesSpecification matchSpec = (MatchesSpecification)spec;
                this.processMatchesSpecification(filterBuilder, matchSpec, variables);
            } else if (spec instanceof PropertyNotNullSpecification) {
                PropertyNotNullSpecification propNotNullSpec = (PropertyNotNullSpecification)spec;
                this.processPropertyNotNullSpecification(filterBuilder, propNotNullSpec);
            } else if (spec instanceof PropertyNullSpecification) {
                PropertyNullSpecification propNullSpec = (PropertyNullSpecification)spec;
                this.processPropertyNullSpecification(filterBuilder, propNullSpec);
            } else if (spec instanceof AssociationNotNullSpecification) {
                AssociationNotNullSpecification assNotNullSpec = (AssociationNotNullSpecification)spec;
                this.processAssociationNotNullSpecification(filterBuilder, assNotNullSpec);
            } else if (spec instanceof AssociationNullSpecification) {
                AssociationNullSpecification assNullSpec = (AssociationNullSpecification)spec;
                this.processAssociationNullSpecification(filterBuilder, assNullSpec);
            } else if (spec instanceof ManyAssociationContainsSpecification) {
                ManyAssociationContainsSpecification manyAssContSpec = (ManyAssociationContainsSpecification)spec;
                this.processManyAssociationContainsSpecification(filterBuilder, manyAssContSpec, variables);
            } else if (spec instanceof NamedAssociationContainsSpecification) {
                NamedAssociationContainsSpecification namedAssContSpec = (NamedAssociationContainsSpecification)spec;
                this.processNamedAssociationContainsSpecification(filterBuilder, namedAssContSpec, variables);
            } else if (spec instanceof NamedAssociationContainsNameSpecification) {
                NamedAssociationContainsNameSpecification namedAssContNameSpec = (NamedAssociationContainsNameSpecification)spec;
                this.processNamedAssociationContainsNameSpecification(filterBuilder, namedAssContNameSpec, variables);
            } else {
                throw new UnsupportedOperationException("Query specification unsupported by Elastic Search (New Query API support missing?): " + spec.getClass() + ": " + spec);
            }
        }

        private static void addFilter(FilterBuilder filter, FilterBuilder into) {
            if (into instanceof AndFilterBuilder) {
                ((AndFilterBuilder)into).add(filter);
            } else if (into instanceof OrFilterBuilder) {
                ((OrFilterBuilder)into).add(filter);
            } else {
                throw new UnsupportedOperationException("FilterBuilder is nor an AndFB nor an OrFB, cannot continue.");
            }
        }

        private void processBinarySpecification(FilterBuilder filterBuilder, BinarySpecification spec, Map<String, Object> variables) throws EntityFinderException {
            LOGGER.trace("Processing BinarySpecification {}", (Object)spec);
            Iterable operands = spec.operands();
            if (spec instanceof AndSpecification) {
                AndFilterBuilder andFilterBuilder = new AndFilterBuilder(new FilterBuilder[0]);
                for (Specification operand : operands) {
                    this.processSpecification((FilterBuilder)andFilterBuilder, (Specification<Composite>)operand, variables);
                }
                Mixin.addFilter((FilterBuilder)andFilterBuilder, filterBuilder);
            } else if (spec instanceof OrSpecification) {
                OrFilterBuilder orFilterBuilder = new OrFilterBuilder(new FilterBuilder[0]);
                for (Specification operand : operands) {
                    this.processSpecification((FilterBuilder)orFilterBuilder, (Specification<Composite>)operand, variables);
                }
                Mixin.addFilter((FilterBuilder)orFilterBuilder, filterBuilder);
            } else {
                throw new UnsupportedOperationException("Binary Query specification is nor an AndSpecification nor an OrSpecification, cannot continue.");
            }
        }

        private void processNotSpecification(FilterBuilder filterBuilder, NotSpecification spec, Map<String, Object> variables) throws EntityFinderException {
            LOGGER.trace("Processing NotSpecification {}", (Object)spec);
            AndFilterBuilder operandFilter = new AndFilterBuilder(new FilterBuilder[0]);
            this.processSpecification((FilterBuilder)operandFilter, (Specification<Composite>)spec.operand(), variables);
            Mixin.addFilter((FilterBuilder)FilterBuilders.notFilter((FilterBuilder)operandFilter), filterBuilder);
        }

        private void processComparisonSpecification(FilterBuilder filterBuilder, ComparisonSpecification<?> spec, Map<String, Object> variables) {
            LOGGER.trace("Processing ComparisonSpecification {}", spec);
            if (spec.value() instanceof ValueComposite) {
                throw new UnsupportedOperationException("ElasticSearch Index/Query does not support complex queries, ie. queries by 'example value'.");
            }
            if (COMPLEX_TYPE_SUPPORTS.get(spec.value().getClass()) != null) {
                ElasticSearchFinderSupport.ComplexTypeSupport support = COMPLEX_TYPE_SUPPORTS.get(spec.value().getClass());
                Mixin.addFilter(support.comparison(spec, variables), filterBuilder);
            } else {
                String name = spec.property().toString();
                Object value = ElasticSearchFinderSupport.resolveVariable(spec.value(), variables);
                if (spec instanceof EqSpecification) {
                    Mixin.addFilter((FilterBuilder)FilterBuilders.termFilter((String)name, (Object)value), filterBuilder);
                } else if (spec instanceof NeSpecification) {
                    Mixin.addFilter((FilterBuilder)FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.existsFilter((String)name), FilterBuilders.notFilter((FilterBuilder)FilterBuilders.termFilter((String)name, (Object)value))}), filterBuilder);
                } else if (spec instanceof GeSpecification) {
                    Mixin.addFilter((FilterBuilder)FilterBuilders.rangeFilter((String)name).gte(value), filterBuilder);
                } else if (spec instanceof GtSpecification) {
                    Mixin.addFilter((FilterBuilder)FilterBuilders.rangeFilter((String)name).gt(value), filterBuilder);
                } else if (spec instanceof LeSpecification) {
                    Mixin.addFilter((FilterBuilder)FilterBuilders.rangeFilter((String)name).lte(value), filterBuilder);
                } else if (spec instanceof LtSpecification) {
                    Mixin.addFilter((FilterBuilder)FilterBuilders.rangeFilter((String)name).lt(value), filterBuilder);
                } else {
                    throw new UnsupportedOperationException("Query specification unsupported by Elastic Search (New Query API support missing?): " + spec.getClass() + ": " + spec);
                }
            }
        }

        private void processContainsAllSpecification(FilterBuilder filterBuilder, ContainsAllSpecification<?> spec, Map<String, Object> variables) {
            LOGGER.trace("Processing ContainsAllSpecification {}", spec);
            Object firstValue = Iterables.first((Iterable)spec.containedValues());
            if (firstValue instanceof ValueComposite) {
                throw new UnsupportedOperationException("ElasticSearch Index/Query does not support complex queries, ie. queries by 'example value'.");
            }
            if (COMPLEX_TYPE_SUPPORTS.get(firstValue.getClass()) != null) {
                ElasticSearchFinderSupport.ComplexTypeSupport support = COMPLEX_TYPE_SUPPORTS.get(firstValue.getClass());
                Mixin.addFilter(support.containsAll(spec, variables), filterBuilder);
            } else {
                String name = spec.collectionProperty().toString();
                AndFilterBuilder contAllFilter = new AndFilterBuilder(new FilterBuilder[0]);
                for (Object value : spec.containedValues()) {
                    contAllFilter.add((FilterBuilder)FilterBuilders.termFilter((String)name, (Object)ElasticSearchFinderSupport.resolveVariable(value, variables)));
                }
                Mixin.addFilter((FilterBuilder)contAllFilter, filterBuilder);
            }
        }

        private void processContainsSpecification(FilterBuilder filterBuilder, ContainsSpecification<?> spec, Map<String, Object> variables) {
            LOGGER.trace("Processing ContainsSpecification {}", spec);
            String name = spec.collectionProperty().toString();
            if (spec.value() instanceof ValueComposite) {
                throw new UnsupportedOperationException("ElasticSearch Index/Query does not support complex queries, ie. queries by 'example value'.");
            }
            if (COMPLEX_TYPE_SUPPORTS.get(spec.value().getClass()) != null) {
                ElasticSearchFinderSupport.ComplexTypeSupport support = COMPLEX_TYPE_SUPPORTS.get(spec.value().getClass());
                Mixin.addFilter(support.contains(spec, variables), filterBuilder);
            } else {
                Object value = ElasticSearchFinderSupport.resolveVariable(spec.value(), variables);
                Mixin.addFilter((FilterBuilder)FilterBuilders.termFilter((String)name, (Object)value), filterBuilder);
            }
        }

        private void processMatchesSpecification(FilterBuilder filterBuilder, MatchesSpecification spec, Map<String, Object> variables) {
            LOGGER.trace("Processing MatchesSpecification {}", (Object)spec);
            String name = spec.property().toString();
            String regexp = ElasticSearchFinderSupport.resolveVariable(spec.regexp(), variables).toString();
            Mixin.addFilter((FilterBuilder)FilterBuilders.regexpFilter((String)name, (String)regexp), filterBuilder);
        }

        private void processPropertyNotNullSpecification(FilterBuilder filterBuilder, PropertyNotNullSpecification<?> spec) {
            LOGGER.trace("Processing PropertyNotNullSpecification {}", spec);
            Mixin.addFilter((FilterBuilder)FilterBuilders.existsFilter((String)spec.property().toString()), filterBuilder);
        }

        private void processPropertyNullSpecification(FilterBuilder filterBuilder, PropertyNullSpecification<?> spec) {
            LOGGER.trace("Processing PropertyNullSpecification {}", spec);
            Mixin.addFilter((FilterBuilder)FilterBuilders.missingFilter((String)spec.property().toString()), filterBuilder);
        }

        private void processAssociationNotNullSpecification(FilterBuilder filterBuilder, AssociationNotNullSpecification<?> spec) {
            LOGGER.trace("Processing AssociationNotNullSpecification {}", spec);
            Mixin.addFilter((FilterBuilder)FilterBuilders.existsFilter((String)(spec.association().toString() + ".identity")), filterBuilder);
        }

        private void processAssociationNullSpecification(FilterBuilder filterBuilder, AssociationNullSpecification<?> spec) {
            LOGGER.trace("Processing AssociationNullSpecification {}", spec);
            Mixin.addFilter((FilterBuilder)FilterBuilders.missingFilter((String)(spec.association().toString() + ".identity")), filterBuilder);
        }

        private void processManyAssociationContainsSpecification(FilterBuilder filterBuilder, ManyAssociationContainsSpecification<?> spec, Map<String, Object> variables) {
            LOGGER.trace("Processing ManyAssociationContainsSpecification {}", spec);
            String name = spec.manyAssociation().toString() + ".identity";
            Object value = ElasticSearchFinderSupport.resolveVariable(spec.value(), variables);
            Mixin.addFilter((FilterBuilder)FilterBuilders.termFilter((String)name, (Object)value), filterBuilder);
        }

        private void processNamedAssociationContainsSpecification(FilterBuilder filterBuilder, NamedAssociationContainsSpecification<?> spec, Map<String, Object> variables) {
            LOGGER.trace("Processing NamedAssociationContainsSpecification {}", spec);
            String name = spec.namedAssociation().toString() + ".identity";
            Object value = ElasticSearchFinderSupport.resolveVariable(spec.value(), variables);
            Mixin.addFilter((FilterBuilder)FilterBuilders.termFilter((String)name, (Object)value), filterBuilder);
        }

        private void processNamedAssociationContainsNameSpecification(FilterBuilder filterBuilder, NamedAssociationContainsNameSpecification<?> spec, Map<String, Object> variables) {
            LOGGER.trace("Processing NamedAssociationContainsNameSpecification {}", spec);
            String name = spec.namedAssociation().toString() + "._named";
            Object value = ElasticSearchFinderSupport.resolveVariable(spec.name(), variables);
            Mixin.addFilter((FilterBuilder)FilterBuilders.termFilter((String)name, (Object)value), filterBuilder);
        }
    }
}

