/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.elasticsearch.filesystem;

import java.io.File;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.This;
import org.qi4j.index.elasticsearch.ElasticSearchConfiguration;
import org.qi4j.index.elasticsearch.internal.AbstractElasticSearchSupport;
import org.qi4j.library.fileconfig.FileConfiguration;

public class ESFilesystemSupport
extends AbstractElasticSearchSupport {
    @This
    private Configuration<ElasticSearchConfiguration> configuration;
    @This
    private Identity hasIdentity;
    @Service
    private FileConfiguration fileConfig;
    private Node node;

    @Override
    protected void activateElasticSearch() throws Exception {
        this.configuration.refresh();
        ElasticSearchConfiguration config = (ElasticSearchConfiguration)this.configuration.get();
        String clusterName = config.clusterName().get() == null ? "qi4j_cluster" : (String)config.clusterName().get();
        this.index = config.index().get() == null ? "qi4j_index" : (String)config.index().get();
        this.indexNonAggregatedAssociations = (Boolean)config.indexNonAggregatedAssociations().get();
        String identity = (String)this.hasIdentity.identity().get();
        Settings settings = ImmutableSettings.settingsBuilder().put("path.work", new File(this.fileConfig.temporaryDirectory(), identity).getAbsolutePath()).put("path.logs", new File(this.fileConfig.logDirectory(), identity).getAbsolutePath()).put("path.data", new File(this.fileConfig.dataDirectory(), identity).getAbsolutePath()).put("path.conf", new File(this.fileConfig.configurationDirectory(), identity).getAbsolutePath()).put("gateway.type", "local").put("http.enabled", false).put("index.cache.type", "weak").put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("index.refresh_interval", -1).build();
        this.node = NodeBuilder.nodeBuilder().clusterName(clusterName).settings(settings).local(true).node();
        this.client = this.node.client();
    }

    @Override
    public void passivateElasticSearch() throws Exception {
        this.node.close();
        this.node = null;
    }
}

