/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.envisage.detail;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.qi4j.api.service.ServiceDescriptor;
import org.qi4j.envisage.detail.DetailModelPane;
import org.qi4j.envisage.detail.DetailPane;
import org.qi4j.envisage.event.LinkEvent;
import org.qi4j.envisage.util.TableRow;
import org.qi4j.tools.model.descriptor.LayerDetailDescriptor;
import org.qi4j.tools.model.descriptor.ModuleDetailDescriptor;
import org.qi4j.tools.model.descriptor.ServiceDetailDescriptor;
import org.qi4j.tools.model.util.DescriptorUtilities;

final class APIPane
extends DetailPane {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(APIPane.class.getName());
    private JPanel contentPane;
    private JTable apiTable;
    private APITableModel apiTableModel;
    private Object linkObject;
    private Cursor defaultCursor;
    private Cursor linkCursor;

    APIPane(DetailModelPane detailModelPane) {
        super(detailModelPane);
        this.$$$setupUI$$$();
        this.setLayout(new BorderLayout());
        this.add((Component)this.contentPane, "Center");
        this.apiTableModel = new APITableModel();
        this.apiTable.setModel(this.apiTableModel);
        this.apiTable.setSelectionMode(0);
        TableColumnModel columnModel = this.apiTable.getColumnModel();
        columnModel.getColumn(0).setCellRenderer(new ServiceCellRenderer());
        this.defaultCursor = this.getCursor();
        this.linkCursor = LinkEvent.LINK_CURSOR;
        MouseInputAdapter mouseInputListener = new MouseInputAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                int col = APIPane.this.apiTable.columnAtPoint(evt.getPoint());
                if (col == 0) {
                    APIPane.this.setCursor(APIPane.this.linkCursor);
                } else if (!APIPane.this.getCursor().equals(APIPane.this.defaultCursor)) {
                    APIPane.this.setCursor(APIPane.this.defaultCursor);
                }
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                int col = APIPane.this.apiTable.columnAtPoint(evt.getPoint());
                if (col != 0) {
                    return;
                }
                int row = APIPane.this.apiTable.rowAtPoint(evt.getPoint());
                if (row < 0) {
                    return;
                }
                APIPane.this.linkObject = APIPane.this.apiTableModel.getValueAt(row, col);
                APIPane.this.linkActivated();
                APIPane.this.linkObject = null;
            }
        };
        this.apiTable.addMouseMotionListener(mouseInputListener);
        this.apiTable.addMouseListener(mouseInputListener);
    }

    @Override
    protected void setDescriptor(Object objectDesciptor) {
        this.clear();
        List list = null;
        if (objectDesciptor instanceof LayerDetailDescriptor) {
            list = DescriptorUtilities.findLayerAPI((LayerDetailDescriptor)((LayerDetailDescriptor)objectDesciptor));
        } else if (objectDesciptor instanceof ModuleDetailDescriptor) {
            list = DescriptorUtilities.findModuleAPI((ModuleDetailDescriptor)((ModuleDetailDescriptor)objectDesciptor));
        }
        if (list != null) {
            this.apiTableModel.addRow(list);
        }
    }

    private void clear() {
        this.linkObject = null;
        this.apiTableModel.clear();
    }

    private void linkActivated() {
        if (this.linkObject == null) {
            return;
        }
        LinkEvent linkEvt = new LinkEvent(this, this.linkObject);
        this.detailModelPane.fireLinkActivated(linkEvt);
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane1 = new JScrollPane();
        this.contentPane.add((Component)scrollPane1, "Center");
        this.apiTable = new JTable();
        this.apiTable.setShowVerticalLines(true);
        scrollPane1.setViewportView(this.apiTable);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    static /* synthetic */ ResourceBundle access$1000() {
        return BUNDLE;
    }

    private static class ServiceCellRenderer
    extends DefaultTableCellRenderer {
        private ServiceCellRenderer() {
        }

        @Override
        public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                value = "<html><a href=\"" + value.toString() + "\">" + value.toString() + "</a></html>";
            }
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return this;
        }
    }

    private static class APITableModel
    extends AbstractTableModel {
        private static final String[] COLUMN_NAMES = new String[]{APIPane.access$1000().getString("Service.Column"), APIPane.access$1000().getString("Module.Column"), APIPane.access$1000().getString("Visibility.Column")};
        private final ArrayList<TableRow> rows = new ArrayList();

        private APITableModel() {
        }

        private void addRow(List<ServiceDetailDescriptor> list) {
            if (list.isEmpty()) {
                return;
            }
            int i1 = this.rows.size();
            if (i1 > 0) {
                --i1;
            }
            int i2 = 0;
            for (ServiceDetailDescriptor descriptor : list) {
                TableRow row = new TableRow(COLUMN_NAMES.length);
                row.set(0, descriptor);
                row.set(1, descriptor.module());
                row.set(2, ((ServiceDescriptor)descriptor.descriptor()).visibility().toString());
                this.rows.add(row);
                ++i2;
            }
            this.fireTableRowsInserted(i1, i1 + i2);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            TableRow row = this.rows.get(rowIndex);
            return row.get(columnIndex);
        }

        private void clear() {
            this.rows.clear();
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public String getColumnName(int col) {
            return COLUMN_NAMES[col];
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }
    }
}

