/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.envisage.detail;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.qi4j.api.composite.CompositeDescriptor;
import org.qi4j.envisage.detail.DetailModelPane;
import org.qi4j.envisage.detail.DetailPane;
import org.qi4j.envisage.event.LinkEvent;
import org.qi4j.functional.Iterables;
import org.qi4j.tools.model.descriptor.CompositeDetailDescriptor;
import org.qi4j.tools.model.descriptor.EntityDetailDescriptor;
import org.qi4j.tools.model.descriptor.ObjectDetailDescriptor;
import org.qi4j.tools.model.descriptor.ServiceDetailDescriptor;
import org.qi4j.tools.model.descriptor.ValueDetailDescriptor;
import org.qi4j.tools.model.util.DescriptorUtilities;

final class ServiceConfigurationPane
extends DetailPane {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(ServiceConfigurationPane.class.getName());
    private JPanel contentPane;
    private JLabel nameLabel;
    private JLabel classLabel;
    private JButton linkButton;
    private JLabel typeLabel;
    private Object configDescriptor;
    private Cursor defaultCursor;
    private Cursor linkCursor;

    ServiceConfigurationPane(DetailModelPane detailModelPane) {
        super(detailModelPane);
        this.$$$setupUI$$$();
        this.setLayout(new BorderLayout());
        this.add((Component)this.contentPane, "Center");
        this.defaultCursor = this.getCursor();
        this.linkCursor = LinkEvent.LINK_CURSOR;
        this.linkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServiceConfigurationPane.this.linkActivated();
            }
        });
        this.nameLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ServiceConfigurationPane.this.linkActivated();
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                ServiceConfigurationPane.this.setCursor(ServiceConfigurationPane.this.linkCursor);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ServiceConfigurationPane.this.setCursor(ServiceConfigurationPane.this.defaultCursor);
            }
        });
    }

    private void linkActivated() {
        if (this.configDescriptor == null) {
            return;
        }
        LinkEvent linkEvt = new LinkEvent(this, this.configDescriptor);
        this.detailModelPane.fireLinkActivated(linkEvt);
    }

    private void clear() {
        this.nameLabel.setText(null);
        this.classLabel.setText(null);
        this.typeLabel.setText(null);
        this.linkButton.setEnabled(false);
        this.configDescriptor = null;
    }

    @Override
    protected void setDescriptor(Object objectDesciptor) {
        this.clear();
        if (!(objectDesciptor instanceof ServiceDetailDescriptor)) {
            return;
        }
        this.configDescriptor = DescriptorUtilities.findServiceConfiguration((ServiceDetailDescriptor)((ServiceDetailDescriptor)objectDesciptor));
        if (this.configDescriptor == null) {
            return;
        }
        CompositeDescriptor spiDescriptor = null;
        String typeString = null;
        if (this.configDescriptor instanceof ServiceDetailDescriptor) {
            spiDescriptor = ((ServiceDetailDescriptor)this.configDescriptor).descriptor();
            typeString = "Service";
        } else if (this.configDescriptor instanceof EntityDetailDescriptor) {
            spiDescriptor = ((EntityDetailDescriptor)this.configDescriptor).descriptor();
            typeString = "Entity";
        } else if (this.configDescriptor instanceof ValueDetailDescriptor) {
            spiDescriptor = ((ValueDetailDescriptor)this.configDescriptor).descriptor();
            typeString = "Value";
        } else if (this.configDescriptor instanceof ObjectDetailDescriptor) {
            spiDescriptor = ((ObjectDetailDescriptor)this.configDescriptor).descriptor();
            typeString = "Object";
        } else if (this.configDescriptor instanceof CompositeDetailDescriptor) {
            spiDescriptor = ((ObjectDetailDescriptor)this.configDescriptor).descriptor();
            typeString = "Transient";
        }
        Class type = (Class)Iterables.first((Iterable)spiDescriptor.types());
        String simpleName = type.getSimpleName();
        this.nameLabel.setText("<html><a href='" + simpleName + "'>" + simpleName + "</a></html>");
        this.classLabel.setText(type.getName());
        this.typeLabel.setText(typeString);
        this.linkButton.setEnabled(true);
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new GridBagLayout());
        JLabel label1 = new JLabel();
        this.$$$loadLabelText$$$(label1, ResourceBundle.getBundle("org/qi4j/envisage/detail/ServiceConfigurationPane").getString("CTL_Name.Text"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 13;
        this.contentPane.add((Component)label1, gbc);
        JPanel spacer1 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 2;
        this.contentPane.add((Component)spacer1, gbc);
        JPanel spacer2 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 3;
        this.contentPane.add((Component)spacer2, gbc);
        this.nameLabel = new JLabel();
        this.nameLabel.setText("Label");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 17;
        this.contentPane.add((Component)this.nameLabel, gbc);
        JPanel spacer3 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        this.contentPane.add((Component)spacer3, gbc);
        JLabel label2 = new JLabel();
        this.$$$loadLabelText$$$(label2, ResourceBundle.getBundle("org/qi4j/envisage/detail/ServiceConfigurationPane").getString("CTL_Class.Text"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 13;
        this.contentPane.add((Component)label2, gbc);
        this.classLabel = new JLabel();
        this.classLabel.setText("Label");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        this.contentPane.add((Component)this.classLabel, gbc);
        JPanel spacer4 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.fill = 3;
        this.contentPane.add((Component)spacer4, gbc);
        this.linkButton = new JButton();
        this.$$$loadButtonText$$$(this.linkButton, ResourceBundle.getBundle("org/qi4j/envisage/detail/ServiceConfigurationPane").getString("CTL_Link.Text"));
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 7;
        gbc.anchor = 17;
        this.contentPane.add((Component)this.linkButton, gbc);
        JPanel spacer5 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 3;
        this.contentPane.add((Component)spacer5, gbc);
        JLabel label3 = new JLabel();
        this.$$$loadLabelText$$$(label3, ResourceBundle.getBundle("org/qi4j/envisage/detail/ServiceConfigurationPane").getString("CTL_Type.Text"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.anchor = 13;
        this.contentPane.add((Component)label3, gbc);
        this.typeLabel = new JLabel();
        this.typeLabel.setText("Label");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 5;
        gbc.anchor = 17;
        this.contentPane.add((Component)this.typeLabel, gbc);
        JPanel spacer6 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.fill = 3;
        this.contentPane.add((Component)spacer6, gbc);
    }

    private void $$$loadLabelText$$$(JLabel component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

