/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.envisage.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.qi4j.envisage.event.LinkEvent;
import org.qi4j.envisage.event.LinkListener;
import org.qi4j.envisage.graph.GraphBuilder;
import org.qi4j.envisage.graph.GraphDisplay;
import org.qi4j.envisage.graph.StackedGraphDisplay;
import org.qi4j.envisage.graph.TreeGraphDisplay;
import org.qi4j.tools.model.descriptor.ApplicationDetailDescriptor;
import prefuse.data.Graph;

public final class GraphPane
extends JPanel {
    private TreeGraphDisplay treeDisplay = new TreeGraphDisplay();
    private final StackedGraphDisplay stackedDisplay = new StackedGraphDisplay();
    private final List<GraphDisplay> displays;
    private JTabbedPane tabPane;
    private final JScrollPane scrollPane;

    public GraphPane() {
        ArrayList<GraphDisplay> tmpList = new ArrayList<GraphDisplay>(2);
        tmpList.add(this.treeDisplay);
        tmpList.add(this.stackedDisplay);
        this.displays = Collections.unmodifiableList(tmpList);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView((Component)((Object)this.stackedDisplay));
        int unitInc = 50;
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(unitInc);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(unitInc);
        this.tabPane = new JTabbedPane();
        this.tabPane.add("Tree", (Component)((Object)this.treeDisplay));
        this.tabPane.add("Stacked", this.scrollPane);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabPane, "Center");
        this.treeDisplay.addLinkListener(new LinkListener(){

            @Override
            public void activated(LinkEvent evt) {
                GraphPane.this.graphItemLinkActivated(evt);
            }
        });
        this.stackedDisplay.addLinkListener(new LinkListener(){

            @Override
            public void activated(LinkEvent evt) {
                GraphPane.this.graphItemLinkActivated(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                Dimension size = GraphPane.this.getSize();
                GraphPane.this.treeDisplay.setSize(size.width, size.height);
                GraphPane.this.tabPane.revalidate();
                GraphPane.this.tabPane.repaint();
            }
        });
    }

    public void initQi4J(ApplicationDetailDescriptor descriptor) {
        Graph graph = GraphBuilder.buildGraph(descriptor);
        Dimension size = this.getSize();
        this.treeDisplay.setSize(size.width, size.height);
        this.treeDisplay.run(graph);
        graph = GraphBuilder.buildGraph(descriptor);
        this.stackedDisplay.setSize(size.width, size.height);
        this.stackedDisplay.run(graph);
    }

    public void refresh() {
        this.treeDisplay.run();
        this.stackedDisplay.run();
    }

    public List<GraphDisplay> getGraphDisplays() {
        return this.displays;
    }

    public void setSelectedValue(Object obj) {
        this.treeDisplay.setSelectedValue(obj);
        this.stackedDisplay.setSelectedValue(obj);
    }

    private void graphItemLinkActivated(LinkEvent evt) {
        if (evt.getSource().equals((Object)this.treeDisplay)) {
            this.stackedDisplay.setSelectedValue(evt.getObject());
        } else if (evt.getSource().equals((Object)this.stackedDisplay)) {
            this.treeDisplay.setSelectedValue(evt.getObject());
        }
    }

    public void addLinkListener(LinkListener listener) {
        this.treeDisplay.addLinkListener(listener);
        this.stackedDisplay.addLinkListener(listener);
    }

    public void removeLinkListener(LinkListener listener) {
        this.treeDisplay.removeLinkListener(listener);
        this.stackedDisplay.removeLinkListener(listener);
    }
}

